/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.core.conditions.query;

import com.baomidou.mybatisplus.core.conditions.AbstractWrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.segments.MergeSegments;
import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.toolkit.ArrayUtils;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.sql.SqlUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;

public class QueryWrapper<T>
extends AbstractWrapper<T, String, QueryWrapper<T>> {
    private String predicateSelect;
    private String[] sqlSelect;
    @Deprecated
    private String[] excludeColumns = new String[0];

    public QueryWrapper() {
        this(null);
    }

    public QueryWrapper(T entity) {
        this(entity, null);
    }

    public QueryWrapper(T entity, String ... column) {
        this.sqlSelect = column;
        this.entity = entity;
        this.initEntityClass();
        this.initNeed();
    }

    private QueryWrapper(T entity, String[] sqlSelect, AtomicInteger paramNameSeq, Map<String, Object> paramNameValuePairs, MergeSegments mergeSegments) {
        this.entity = entity;
        this.sqlSelect = sqlSelect;
        this.paramNameSeq = paramNameSeq;
        this.paramNameValuePairs = paramNameValuePairs;
        this.expression = mergeSegments;
        this.initEntityClass();
    }

    @Override
    public String getSqlSelect() {
        if (StringUtils.isNotEmpty(this.predicateSelect)) {
            return this.predicateSelect;
        }
        if (ArrayUtils.isNotEmpty(this.sqlSelect)) {
            List<String> excludeColumnList = Arrays.asList(this.excludeColumns);
            this.sqlSelect = (String[])Arrays.stream(this.sqlSelect).filter(i -> !excludeColumnList.contains(i)).toArray(String[]::new);
        } else if (this.entityClass != null) {
            this.sqlSelect = TableInfoHelper.getTableColumns(this.entityClass, this.excludeColumns);
        }
        return ArrayUtils.isNotEmpty(this.sqlSelect) ? SqlUtils.stripSqlInjection(String.join((CharSequence)",", this.sqlSelect)) : null;
    }

    public QueryWrapper<T> select(String ... sqlSelect) {
        if (ArrayUtils.isNotEmpty(sqlSelect)) {
            this.sqlSelect = sqlSelect;
        }
        return (QueryWrapper)this.typedThis;
    }

    public QueryWrapper<T> select(Predicate<TableFieldInfo> predicate) {
        return this.select(this.entityClass, predicate);
    }

    public QueryWrapper<T> select(Class<T> entityClass, Predicate<TableFieldInfo> predicate) {
        this.entityClass = entityClass;
        this.checkEntityClass();
        this.predicateSelect = TableInfoHelper.getTableInfo(entityClass).chooseSelect(predicate);
        return (QueryWrapper)this.typedThis;
    }

    @Deprecated
    public QueryWrapper<T> excludeColumns(Class<T> entityClass, String ... excludeColumns) {
        Assert.notEmpty(excludeColumns, "excludeColumns must not empty");
        this.excludeColumns = excludeColumns;
        this.entityClass = entityClass;
        this.checkEntityClass();
        return (QueryWrapper)this.typedThis;
    }

    @Deprecated
    public QueryWrapper<T> excludeColumns(String ... excludeColumns) {
        this.checkEntityClass();
        return this.excludeColumns(this.entityClass, excludeColumns);
    }

    public LambdaQueryWrapper<T> lambda() {
        return new LambdaQueryWrapper<Object>(this.entity, this.paramNameSeq, this.paramNameValuePairs, this.expression);
    }

    @Override
    protected String columnToString(String column) {
        return column;
    }

    @Override
    protected QueryWrapper<T> instance(AtomicInteger paramNameSeq, Map<String, Object> paramNameValuePairs) {
        return new QueryWrapper<Object>(this.entity, this.sqlSelect, paramNameSeq, paramNameValuePairs, new MergeSegments());
    }
}

