/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.core.metadata;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.KeySequence;
import com.baomidou.mybatisplus.core.MybatisConfiguration;
import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.baomidou.mybatisplus.core.toolkit.ExceptionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.sql.SqlScriptUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.ibatis.mapping.ResultFlag;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.ResultMapping;
import org.apache.ibatis.session.Configuration;

public class TableInfo
implements Constants {
    private Class<?> entityType;
    private IdType idType = IdType.NONE;
    private String tableName;
    private String resultMap;
    private boolean autoInitResultMap;
    private boolean initResultMap;
    private boolean keyRelated;
    private String keyColumn;
    private String keyProperty;
    private Class<?> keyType;
    private KeySequence keySequence;
    private List<TableFieldInfo> fieldList;
    private String currentNamespace;
    private MybatisConfiguration configuration;
    private boolean logicDelete;
    private boolean underCamel;
    private String allSqlSelect;
    private String sqlSelect;
    private boolean withInsertFill;
    private boolean withUpdateFill;
    private boolean withVersion;
    private TableFieldInfo versionFieldInfo;

    public TableInfo(Class<?> entityType) {
        this.entityType = entityType;
    }

    public String getSqlStatement(String sqlMethod) {
        return this.currentNamespace + "." + sqlMethod;
    }

    void setConfiguration(Configuration configuration) {
        Assert.notNull(configuration, "Error: You need Initialize MybatisConfiguration !", new Object[0]);
        this.configuration = (MybatisConfiguration)configuration;
        this.underCamel = configuration.isMapUnderscoreToCamelCase();
    }

    public boolean havePK() {
        return StringUtils.isNotBlank(this.keyColumn);
    }

    public String getKeySqlSelect() {
        if (this.sqlSelect != null) {
            return this.sqlSelect;
        }
        if (this.havePK()) {
            this.sqlSelect = this.keyColumn;
            if (this.keyRelated) {
                this.sqlSelect = this.sqlSelect + " AS " + this.keyProperty;
            }
        } else {
            this.sqlSelect = "";
        }
        return this.sqlSelect;
    }

    public String getAllSqlSelect() {
        if (this.allSqlSelect != null) {
            return this.allSqlSelect;
        }
        this.allSqlSelect = this.chooseSelect(TableFieldInfo::isSelect);
        return this.allSqlSelect;
    }

    public String chooseSelect(Predicate<TableFieldInfo> predicate) {
        String sqlSelect = this.getKeySqlSelect();
        String fieldsSqlSelect = this.fieldList.stream().filter(predicate).map(TableFieldInfo::getSqlSelect).collect(Collectors.joining(","));
        if (StringUtils.isNotBlank(sqlSelect) && StringUtils.isNotBlank(fieldsSqlSelect)) {
            return sqlSelect + "," + fieldsSqlSelect;
        }
        if (StringUtils.isNotBlank(fieldsSqlSelect)) {
            return fieldsSqlSelect;
        }
        return sqlSelect;
    }

    public String getKeyInsertSqlProperty(String prefix, boolean newLine) {
        String newPrefix;
        String string = newPrefix = prefix == null ? "" : prefix;
        if (this.havePK()) {
            if (this.idType == IdType.AUTO) {
                return "";
            }
            return SqlScriptUtils.safeParam(newPrefix + this.keyProperty) + "," + (newLine ? "\n" : "");
        }
        return "";
    }

    public String getKeyInsertSqlColumn(boolean newLine) {
        if (this.havePK()) {
            if (this.idType == IdType.AUTO) {
                return "";
            }
            return this.keyColumn + "," + (newLine ? "\n" : "");
        }
        return "";
    }

    public String getAllInsertSqlPropertyMaybeIf(String prefix) {
        String newPrefix = prefix == null ? "" : prefix;
        return this.getKeyInsertSqlProperty(newPrefix, true) + this.fieldList.stream().map(i -> i.getInsertSqlPropertyMaybeIf(newPrefix)).filter(Objects::nonNull).collect(Collectors.joining("\n"));
    }

    public String getAllInsertSqlColumnMaybeIf() {
        return this.getKeyInsertSqlColumn(true) + this.fieldList.stream().map(TableFieldInfo::getInsertSqlColumnMaybeIf).filter(Objects::nonNull).collect(Collectors.joining("\n"));
    }

    public String getAllSqlWhere(boolean ignoreLogicDelFiled, boolean withId, String prefix) {
        String newPrefix = prefix == null ? "" : prefix;
        String filedSqlScript = this.fieldList.stream().filter(i -> {
            if (ignoreLogicDelFiled) {
                return !this.isLogicDelete() || !i.isLogicDelete();
            }
            return true;
        }).map(i -> i.getSqlWhere(newPrefix)).filter(Objects::nonNull).collect(Collectors.joining("\n"));
        if (!withId || StringUtils.isBlank(this.keyProperty)) {
            return filedSqlScript;
        }
        String newKeyProperty = newPrefix + this.keyProperty;
        String keySqlScript = this.keyColumn + "=" + SqlScriptUtils.safeParam(newKeyProperty);
        return SqlScriptUtils.convertIf(keySqlScript, String.format("%s != null", newKeyProperty), false) + "\n" + filedSqlScript;
    }

    public String getAllSqlSet(boolean ignoreLogicDelFiled, String prefix) {
        String newPrefix = prefix == null ? "" : prefix;
        return this.fieldList.stream().filter(i -> {
            if (ignoreLogicDelFiled) {
                return !this.isLogicDelete() || !i.isLogicDelete();
            }
            return true;
        }).map(i -> i.getSqlSet(newPrefix)).filter(Objects::nonNull).collect(Collectors.joining("\n"));
    }

    public String getLogicDeleteSql(boolean startWithAnd, boolean isWhere) {
        if (this.logicDelete) {
            TableFieldInfo field = this.fieldList.stream().filter(TableFieldInfo::isLogicDelete).findFirst().orElseThrow(() -> ExceptionUtils.mpe("can't find the logicFiled from table {%s}", this.tableName));
            String logicDeleteSql = this.formatLogicDeleteSql(field, isWhere);
            if (startWithAnd) {
                logicDeleteSql = " AND " + logicDeleteSql;
            }
            return logicDeleteSql;
        }
        return "";
    }

    private String formatLogicDeleteSql(TableFieldInfo field, boolean isWhere) {
        String value;
        String string = value = isWhere ? field.getLogicNotDeleteValue() : field.getLogicDeleteValue();
        if (isWhere) {
            if ("null".equalsIgnoreCase(value)) {
                return field.getColumn() + " IS NULL";
            }
            return field.getColumn() + "=" + String.format(field.isCharSequence() ? "'%s'" : "%s", value);
        }
        String targetStr = field.getColumn() + "=";
        if ("null".equalsIgnoreCase(value)) {
            return targetStr + "null";
        }
        return targetStr + String.format(field.isCharSequence() ? "'%s'" : "%s", value);
    }

    void initResultMapIfNeed() {
        if (this.autoInitResultMap && null == this.resultMap) {
            String id = this.currentNamespace + "." + "mybatis-plus" + "_" + this.entityType.getSimpleName();
            ArrayList<ResultMapping> resultMappings = new ArrayList<ResultMapping>();
            if (this.havePK()) {
                ResultMapping idMapping = new ResultMapping.Builder((Configuration)this.configuration, this.keyProperty, this.keyColumn, this.keyType).flags(Collections.singletonList(ResultFlag.ID)).build();
                resultMappings.add(idMapping);
            }
            if (CollectionUtils.isNotEmpty(this.fieldList)) {
                this.fieldList.forEach(i -> resultMappings.add(i.getResultMapping(this.configuration)));
            }
            ResultMap resultMap = new ResultMap.Builder((Configuration)this.configuration, id, this.entityType, resultMappings).build();
            this.configuration.addResultMap(resultMap);
            this.resultMap = id;
        }
    }

    void setFieldList(List<TableFieldInfo> fieldList) {
        this.fieldList = fieldList;
        fieldList.forEach(i -> {
            if (i.isLogicDelete()) {
                this.logicDelete = true;
            }
            if (i.isWithInsertFill()) {
                this.withInsertFill = true;
            }
            if (i.isWithUpdateFill()) {
                this.withUpdateFill = true;
            }
            if (i.isVersion()) {
                this.withVersion = true;
                this.versionFieldInfo = i;
            }
        });
    }

    public Class<?> getEntityType() {
        return this.entityType;
    }

    public IdType getIdType() {
        return this.idType;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getResultMap() {
        return this.resultMap;
    }

    public boolean isAutoInitResultMap() {
        return this.autoInitResultMap;
    }

    public boolean isInitResultMap() {
        return this.initResultMap;
    }

    public boolean isKeyRelated() {
        return this.keyRelated;
    }

    public String getKeyColumn() {
        return this.keyColumn;
    }

    public String getKeyProperty() {
        return this.keyProperty;
    }

    public Class<?> getKeyType() {
        return this.keyType;
    }

    public KeySequence getKeySequence() {
        return this.keySequence;
    }

    public List<TableFieldInfo> getFieldList() {
        return this.fieldList;
    }

    public String getCurrentNamespace() {
        return this.currentNamespace;
    }

    public boolean isLogicDelete() {
        return this.logicDelete;
    }

    public boolean isUnderCamel() {
        return this.underCamel;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableInfo)) {
            return false;
        }
        TableInfo other = (TableInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Class<?> this$entityType = this.getEntityType();
        Class<?> other$entityType = other.getEntityType();
        if (this$entityType == null ? other$entityType != null : !this$entityType.equals(other$entityType)) {
            return false;
        }
        IdType this$idType = this.getIdType();
        IdType other$idType = other.getIdType();
        if (this$idType == null ? other$idType != null : !this$idType.equals(other$idType)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$resultMap = this.getResultMap();
        String other$resultMap = other.getResultMap();
        if (this$resultMap == null ? other$resultMap != null : !this$resultMap.equals(other$resultMap)) {
            return false;
        }
        if (this.isAutoInitResultMap() != other.isAutoInitResultMap()) {
            return false;
        }
        if (this.isInitResultMap() != other.isInitResultMap()) {
            return false;
        }
        if (this.isKeyRelated() != other.isKeyRelated()) {
            return false;
        }
        String this$keyColumn = this.getKeyColumn();
        String other$keyColumn = other.getKeyColumn();
        if (this$keyColumn == null ? other$keyColumn != null : !this$keyColumn.equals(other$keyColumn)) {
            return false;
        }
        String this$keyProperty = this.getKeyProperty();
        String other$keyProperty = other.getKeyProperty();
        if (this$keyProperty == null ? other$keyProperty != null : !this$keyProperty.equals(other$keyProperty)) {
            return false;
        }
        Class<?> this$keyType = this.getKeyType();
        Class<?> other$keyType = other.getKeyType();
        if (this$keyType == null ? other$keyType != null : !this$keyType.equals(other$keyType)) {
            return false;
        }
        KeySequence this$keySequence = this.getKeySequence();
        KeySequence other$keySequence = other.getKeySequence();
        if (this$keySequence == null ? other$keySequence != null : !this$keySequence.equals(other$keySequence)) {
            return false;
        }
        List<TableFieldInfo> this$fieldList = this.getFieldList();
        List<TableFieldInfo> other$fieldList = other.getFieldList();
        if (this$fieldList == null ? other$fieldList != null : !((Object)this$fieldList).equals(other$fieldList)) {
            return false;
        }
        String this$currentNamespace = this.getCurrentNamespace();
        String other$currentNamespace = other.getCurrentNamespace();
        if (this$currentNamespace == null ? other$currentNamespace != null : !this$currentNamespace.equals(other$currentNamespace)) {
            return false;
        }
        MybatisConfiguration this$configuration = this.getConfiguration();
        MybatisConfiguration other$configuration = other.getConfiguration();
        if (this$configuration == null ? other$configuration != null : !((Object)((Object)this$configuration)).equals((Object)other$configuration)) {
            return false;
        }
        if (this.isLogicDelete() != other.isLogicDelete()) {
            return false;
        }
        if (this.isUnderCamel() != other.isUnderCamel()) {
            return false;
        }
        String this$allSqlSelect = this.getAllSqlSelect();
        String other$allSqlSelect = other.getAllSqlSelect();
        if (this$allSqlSelect == null ? other$allSqlSelect != null : !this$allSqlSelect.equals(other$allSqlSelect)) {
            return false;
        }
        String this$sqlSelect = this.sqlSelect;
        String other$sqlSelect = other.sqlSelect;
        if (this$sqlSelect == null ? other$sqlSelect != null : !this$sqlSelect.equals(other$sqlSelect)) {
            return false;
        }
        if (this.isWithInsertFill() != other.isWithInsertFill()) {
            return false;
        }
        if (this.isWithUpdateFill() != other.isWithUpdateFill()) {
            return false;
        }
        if (this.isWithVersion() != other.isWithVersion()) {
            return false;
        }
        TableFieldInfo this$versionFieldInfo = this.getVersionFieldInfo();
        TableFieldInfo other$versionFieldInfo = other.getVersionFieldInfo();
        return !(this$versionFieldInfo == null ? other$versionFieldInfo != null : !((Object)this$versionFieldInfo).equals(other$versionFieldInfo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TableInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Class<?> $entityType = this.getEntityType();
        result = result * 59 + ($entityType == null ? 43 : $entityType.hashCode());
        IdType $idType = this.getIdType();
        result = result * 59 + ($idType == null ? 43 : $idType.hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $resultMap = this.getResultMap();
        result = result * 59 + ($resultMap == null ? 43 : $resultMap.hashCode());
        result = result * 59 + (this.isAutoInitResultMap() ? 79 : 97);
        result = result * 59 + (this.isInitResultMap() ? 79 : 97);
        result = result * 59 + (this.isKeyRelated() ? 79 : 97);
        String $keyColumn = this.getKeyColumn();
        result = result * 59 + ($keyColumn == null ? 43 : $keyColumn.hashCode());
        String $keyProperty = this.getKeyProperty();
        result = result * 59 + ($keyProperty == null ? 43 : $keyProperty.hashCode());
        Class<?> $keyType = this.getKeyType();
        result = result * 59 + ($keyType == null ? 43 : $keyType.hashCode());
        KeySequence $keySequence = this.getKeySequence();
        result = result * 59 + ($keySequence == null ? 43 : $keySequence.hashCode());
        List<TableFieldInfo> $fieldList = this.getFieldList();
        result = result * 59 + ($fieldList == null ? 43 : ((Object)$fieldList).hashCode());
        String $currentNamespace = this.getCurrentNamespace();
        result = result * 59 + ($currentNamespace == null ? 43 : $currentNamespace.hashCode());
        MybatisConfiguration $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : ((Object)((Object)$configuration)).hashCode());
        result = result * 59 + (this.isLogicDelete() ? 79 : 97);
        result = result * 59 + (this.isUnderCamel() ? 79 : 97);
        String $allSqlSelect = this.getAllSqlSelect();
        result = result * 59 + ($allSqlSelect == null ? 43 : $allSqlSelect.hashCode());
        String $sqlSelect = this.sqlSelect;
        result = result * 59 + ($sqlSelect == null ? 43 : $sqlSelect.hashCode());
        result = result * 59 + (this.isWithInsertFill() ? 79 : 97);
        result = result * 59 + (this.isWithUpdateFill() ? 79 : 97);
        result = result * 59 + (this.isWithVersion() ? 79 : 97);
        TableFieldInfo $versionFieldInfo = this.getVersionFieldInfo();
        result = result * 59 + ($versionFieldInfo == null ? 43 : ((Object)$versionFieldInfo).hashCode());
        return result;
    }

    public String toString() {
        return "TableInfo(entityType=" + this.getEntityType() + ", idType=" + this.getIdType() + ", tableName=" + this.getTableName() + ", resultMap=" + this.getResultMap() + ", autoInitResultMap=" + this.isAutoInitResultMap() + ", initResultMap=" + this.isInitResultMap() + ", keyRelated=" + this.isKeyRelated() + ", keyColumn=" + this.getKeyColumn() + ", keyProperty=" + this.getKeyProperty() + ", keyType=" + this.getKeyType() + ", keySequence=" + this.getKeySequence() + ", fieldList=" + this.getFieldList() + ", currentNamespace=" + this.getCurrentNamespace() + ", configuration=" + (Object)((Object)this.getConfiguration()) + ", logicDelete=" + this.isLogicDelete() + ", underCamel=" + this.isUnderCamel() + ", allSqlSelect=" + this.getAllSqlSelect() + ", sqlSelect=" + this.sqlSelect + ", withInsertFill=" + this.isWithInsertFill() + ", withUpdateFill=" + this.isWithUpdateFill() + ", withVersion=" + this.isWithVersion() + ", versionFieldInfo=" + this.getVersionFieldInfo() + ")";
    }

    TableInfo setEntityType(Class<?> entityType) {
        this.entityType = entityType;
        return this;
    }

    TableInfo setIdType(IdType idType) {
        this.idType = idType;
        return this;
    }

    TableInfo setTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    TableInfo setResultMap(String resultMap) {
        this.resultMap = resultMap;
        return this;
    }

    TableInfo setAutoInitResultMap(boolean autoInitResultMap) {
        this.autoInitResultMap = autoInitResultMap;
        return this;
    }

    TableInfo setInitResultMap(boolean initResultMap) {
        this.initResultMap = initResultMap;
        return this;
    }

    TableInfo setKeyRelated(boolean keyRelated) {
        this.keyRelated = keyRelated;
        return this;
    }

    TableInfo setKeyColumn(String keyColumn) {
        this.keyColumn = keyColumn;
        return this;
    }

    TableInfo setKeyProperty(String keyProperty) {
        this.keyProperty = keyProperty;
        return this;
    }

    TableInfo setKeyType(Class<?> keyType) {
        this.keyType = keyType;
        return this;
    }

    TableInfo setKeySequence(KeySequence keySequence) {
        this.keySequence = keySequence;
        return this;
    }

    TableInfo setCurrentNamespace(String currentNamespace) {
        this.currentNamespace = currentNamespace;
        return this;
    }

    TableInfo setUnderCamel(boolean underCamel) {
        this.underCamel = underCamel;
        return this;
    }

    public MybatisConfiguration getConfiguration() {
        return this.configuration;
    }

    public boolean isWithInsertFill() {
        return this.withInsertFill;
    }

    public boolean isWithUpdateFill() {
        return this.withUpdateFill;
    }

    public boolean isWithVersion() {
        return this.withVersion;
    }

    public TableFieldInfo getVersionFieldInfo() {
        return this.versionFieldInfo;
    }
}

