/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.core.plugins;

import com.baomidou.mybatisplus.annotation.InterceptorIgnore;
import com.baomidou.mybatisplus.core.toolkit.ArrayUtils;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.ExceptionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public abstract class InterceptorIgnoreHelper {
    private static final Map<String, InterceptorIgnoreCache> INTERCEPTOR_IGNORE_CACHE = new ConcurrentHashMap<String, InterceptorIgnoreCache>();

    public static synchronized InterceptorIgnoreCache initSqlParserInfoCache(Class<?> mapperClass) {
        InterceptorIgnore ignore = mapperClass.getAnnotation(InterceptorIgnore.class);
        if (ignore != null) {
            String key = mapperClass.getName();
            InterceptorIgnoreCache cache = InterceptorIgnoreHelper.buildInterceptorIgnoreCache(key, ignore);
            INTERCEPTOR_IGNORE_CACHE.put(key, cache);
            return cache;
        }
        return null;
    }

    public static void initSqlParserInfoCache(InterceptorIgnoreCache mapperAnnotation, String mapperClassName, Method method) {
        InterceptorIgnore ignore = method.getAnnotation(InterceptorIgnore.class);
        String key = mapperClassName.concat(".").concat(method.getName());
        String name = mapperClassName.concat("#").concat(method.getName());
        if (ignore != null) {
            InterceptorIgnoreCache methodCache = InterceptorIgnoreHelper.buildInterceptorIgnoreCache(name, ignore);
            if (mapperAnnotation == null) {
                INTERCEPTOR_IGNORE_CACHE.put(key, methodCache);
                return;
            }
            INTERCEPTOR_IGNORE_CACHE.put(key, InterceptorIgnoreHelper.chooseCache(mapperAnnotation, methodCache));
        }
    }

    public static boolean willIgnoreTenantLine(String id) {
        return InterceptorIgnoreHelper.willIgnore(id, InterceptorIgnoreCache::getTenantLine);
    }

    public static boolean willIgnoreDynamicTableName(String id) {
        return InterceptorIgnoreHelper.willIgnore(id, InterceptorIgnoreCache::getDynamicTableName);
    }

    public static boolean willIgnoreBlockAttack(String id) {
        return InterceptorIgnoreHelper.willIgnore(id, InterceptorIgnoreCache::getBlockAttack);
    }

    public static boolean willIgnoreIllegalSql(String id) {
        return InterceptorIgnoreHelper.willIgnore(id, InterceptorIgnoreCache::getIllegalSql);
    }

    public static boolean willIgnoreDataPermission(String id) {
        return InterceptorIgnoreHelper.willIgnore(id, InterceptorIgnoreCache::getDataPermission);
    }

    public static boolean willIgnoreOthersByKey(String id, String key) {
        return InterceptorIgnoreHelper.willIgnore(id, i -> CollectionUtils.isNotEmpty(i.getOthers()) && i.getOthers().getOrDefault(key, false) != false);
    }

    public static boolean willIgnore(String id, Function<InterceptorIgnoreCache, Boolean> function) {
        InterceptorIgnoreCache cache = INTERCEPTOR_IGNORE_CACHE.get(id);
        if (cache == null) {
            cache = INTERCEPTOR_IGNORE_CACHE.get(id.substring(0, id.lastIndexOf(".")));
        }
        if (cache != null) {
            Boolean apply = function.apply(cache);
            return apply != null && apply != false;
        }
        return false;
    }

    private static InterceptorIgnoreCache chooseCache(InterceptorIgnoreCache mapper, InterceptorIgnoreCache method) {
        return InterceptorIgnoreCache.builder().tenantLine(InterceptorIgnoreHelper.chooseBoolean(mapper.getTenantLine(), method.getTenantLine())).dynamicTableName(InterceptorIgnoreHelper.chooseBoolean(mapper.getDynamicTableName(), method.getDynamicTableName())).blockAttack(InterceptorIgnoreHelper.chooseBoolean(mapper.getBlockAttack(), method.getBlockAttack())).illegalSql(InterceptorIgnoreHelper.chooseBoolean(mapper.getIllegalSql(), method.getIllegalSql())).dataPermission(InterceptorIgnoreHelper.chooseBoolean(mapper.getDataPermission(), method.getDataPermission())).others(InterceptorIgnoreHelper.chooseOthers(mapper.getOthers(), method.getOthers())).build();
    }

    private static InterceptorIgnoreCache buildInterceptorIgnoreCache(String name, InterceptorIgnore ignore) {
        return InterceptorIgnoreCache.builder().tenantLine(InterceptorIgnoreHelper.getBoolean("tenantLine", name, ignore.tenantLine())).dynamicTableName(InterceptorIgnoreHelper.getBoolean("dynamicTableName", name, ignore.dynamicTableName())).blockAttack(InterceptorIgnoreHelper.getBoolean("blockAttack", name, ignore.blockAttack())).illegalSql(InterceptorIgnoreHelper.getBoolean("illegalSql", name, ignore.illegalSql())).dataPermission(InterceptorIgnoreHelper.getBoolean("dataPermission", name, ignore.dataPermission())).others(InterceptorIgnoreHelper.getOthers(name, ignore.others())).build();
    }

    private static Boolean getBoolean(String node, String name, String value) {
        if (StringUtils.isBlank(value)) {
            return null;
        }
        if ("1".equals(value) || "true".equals(value) || "on".equals(value)) {
            return true;
        }
        if ("0".equals(value) || "false".equals(value) || "off".equals(value)) {
            return false;
        }
        throw ExceptionUtils.mpe("unsupported value \"%s\" by `@InterceptorIgnore#%s` on top of \"%s\"", value, node, name);
    }

    private static Map<String, Boolean> getOthers(String name, String[] values) {
        if (ArrayUtils.isEmpty(values)) {
            return null;
        }
        HashMap<String, Boolean> map = CollectionUtils.newHashMapWithExpectedSize(values.length);
        for (String s : values) {
            int index = s.indexOf("@");
            Assert.isTrue(index > 0, "unsupported value \"%s\" by `@InterceptorIgnore#others` on top of \"%s\"", s, name);
            String key = s.substring(0, index);
            Boolean value = InterceptorIgnoreHelper.getBoolean("others", name, s.substring(index + 1));
            map.put(key, value);
        }
        return map;
    }

    private static Boolean chooseBoolean(Boolean mapper, Boolean method) {
        if (mapper == null && method == null) {
            return null;
        }
        if (method != null) {
            return method;
        }
        return mapper;
    }

    private static Map<String, Boolean> chooseOthers(Map<String, Boolean> mapper, Map<String, Boolean> method) {
        boolean emptyMapper = CollectionUtils.isEmpty(mapper);
        boolean emptyMethod = CollectionUtils.isEmpty(method);
        if (emptyMapper && emptyMethod) {
            return null;
        }
        if (emptyMapper) {
            return method;
        }
        if (emptyMethod) {
            return mapper;
        }
        Set<String> mapperKeys = mapper.keySet();
        Set<String> methodKeys = method.keySet();
        HashSet<String> keys = new HashSet<String>(mapperKeys.size() + methodKeys.size());
        keys.addAll(methodKeys);
        keys.addAll(mapperKeys);
        HashMap<String, Boolean> map = CollectionUtils.newHashMapWithExpectedSize(keys.size());
        methodKeys.forEach(k -> map.put((String)k, InterceptorIgnoreHelper.chooseBoolean((Boolean)mapper.get(k), (Boolean)method.get(k))));
        return map;
    }

    public static class InterceptorIgnoreCache {
        private Boolean tenantLine;
        private Boolean dynamicTableName;
        private Boolean blockAttack;
        private Boolean illegalSql;
        private Boolean dataPermission;
        private Map<String, Boolean> others;

        InterceptorIgnoreCache(Boolean tenantLine, Boolean dynamicTableName, Boolean blockAttack, Boolean illegalSql, Boolean dataPermission, Map<String, Boolean> others) {
            this.tenantLine = tenantLine;
            this.dynamicTableName = dynamicTableName;
            this.blockAttack = blockAttack;
            this.illegalSql = illegalSql;
            this.dataPermission = dataPermission;
            this.others = others;
        }

        public static InterceptorIgnoreCacheBuilder builder() {
            return new InterceptorIgnoreCacheBuilder();
        }

        public Boolean getTenantLine() {
            return this.tenantLine;
        }

        public Boolean getDynamicTableName() {
            return this.dynamicTableName;
        }

        public Boolean getBlockAttack() {
            return this.blockAttack;
        }

        public Boolean getIllegalSql() {
            return this.illegalSql;
        }

        public Boolean getDataPermission() {
            return this.dataPermission;
        }

        public Map<String, Boolean> getOthers() {
            return this.others;
        }

        public void setTenantLine(Boolean tenantLine) {
            this.tenantLine = tenantLine;
        }

        public void setDynamicTableName(Boolean dynamicTableName) {
            this.dynamicTableName = dynamicTableName;
        }

        public void setBlockAttack(Boolean blockAttack) {
            this.blockAttack = blockAttack;
        }

        public void setIllegalSql(Boolean illegalSql) {
            this.illegalSql = illegalSql;
        }

        public void setDataPermission(Boolean dataPermission) {
            this.dataPermission = dataPermission;
        }

        public void setOthers(Map<String, Boolean> others) {
            this.others = others;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InterceptorIgnoreCache)) {
                return false;
            }
            InterceptorIgnoreCache other = (InterceptorIgnoreCache)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$tenantLine = this.getTenantLine();
            Boolean other$tenantLine = other.getTenantLine();
            if (this$tenantLine == null ? other$tenantLine != null : !((Object)this$tenantLine).equals(other$tenantLine)) {
                return false;
            }
            Boolean this$dynamicTableName = this.getDynamicTableName();
            Boolean other$dynamicTableName = other.getDynamicTableName();
            if (this$dynamicTableName == null ? other$dynamicTableName != null : !((Object)this$dynamicTableName).equals(other$dynamicTableName)) {
                return false;
            }
            Boolean this$blockAttack = this.getBlockAttack();
            Boolean other$blockAttack = other.getBlockAttack();
            if (this$blockAttack == null ? other$blockAttack != null : !((Object)this$blockAttack).equals(other$blockAttack)) {
                return false;
            }
            Boolean this$illegalSql = this.getIllegalSql();
            Boolean other$illegalSql = other.getIllegalSql();
            if (this$illegalSql == null ? other$illegalSql != null : !((Object)this$illegalSql).equals(other$illegalSql)) {
                return false;
            }
            Boolean this$dataPermission = this.getDataPermission();
            Boolean other$dataPermission = other.getDataPermission();
            if (this$dataPermission == null ? other$dataPermission != null : !((Object)this$dataPermission).equals(other$dataPermission)) {
                return false;
            }
            Map<String, Boolean> this$others = this.getOthers();
            Map<String, Boolean> other$others = other.getOthers();
            return !(this$others == null ? other$others != null : !((Object)this$others).equals(other$others));
        }

        protected boolean canEqual(Object other) {
            return other instanceof InterceptorIgnoreCache;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $tenantLine = this.getTenantLine();
            result = result * 59 + ($tenantLine == null ? 43 : ((Object)$tenantLine).hashCode());
            Boolean $dynamicTableName = this.getDynamicTableName();
            result = result * 59 + ($dynamicTableName == null ? 43 : ((Object)$dynamicTableName).hashCode());
            Boolean $blockAttack = this.getBlockAttack();
            result = result * 59 + ($blockAttack == null ? 43 : ((Object)$blockAttack).hashCode());
            Boolean $illegalSql = this.getIllegalSql();
            result = result * 59 + ($illegalSql == null ? 43 : ((Object)$illegalSql).hashCode());
            Boolean $dataPermission = this.getDataPermission();
            result = result * 59 + ($dataPermission == null ? 43 : ((Object)$dataPermission).hashCode());
            Map<String, Boolean> $others = this.getOthers();
            result = result * 59 + ($others == null ? 43 : ((Object)$others).hashCode());
            return result;
        }

        public String toString() {
            return "InterceptorIgnoreHelper.InterceptorIgnoreCache(tenantLine=" + this.getTenantLine() + ", dynamicTableName=" + this.getDynamicTableName() + ", blockAttack=" + this.getBlockAttack() + ", illegalSql=" + this.getIllegalSql() + ", dataPermission=" + this.getDataPermission() + ", others=" + this.getOthers() + ")";
        }

        public static class InterceptorIgnoreCacheBuilder {
            private Boolean tenantLine;
            private Boolean dynamicTableName;
            private Boolean blockAttack;
            private Boolean illegalSql;
            private Boolean dataPermission;
            private Map<String, Boolean> others;

            InterceptorIgnoreCacheBuilder() {
            }

            public InterceptorIgnoreCacheBuilder tenantLine(Boolean tenantLine) {
                this.tenantLine = tenantLine;
                return this;
            }

            public InterceptorIgnoreCacheBuilder dynamicTableName(Boolean dynamicTableName) {
                this.dynamicTableName = dynamicTableName;
                return this;
            }

            public InterceptorIgnoreCacheBuilder blockAttack(Boolean blockAttack) {
                this.blockAttack = blockAttack;
                return this;
            }

            public InterceptorIgnoreCacheBuilder illegalSql(Boolean illegalSql) {
                this.illegalSql = illegalSql;
                return this;
            }

            public InterceptorIgnoreCacheBuilder dataPermission(Boolean dataPermission) {
                this.dataPermission = dataPermission;
                return this;
            }

            public InterceptorIgnoreCacheBuilder others(Map<String, Boolean> others) {
                this.others = others;
                return this;
            }

            public InterceptorIgnoreCache build() {
                return new InterceptorIgnoreCache(this.tenantLine, this.dynamicTableName, this.blockAttack, this.illegalSql, this.dataPermission, this.others);
            }

            public String toString() {
                return "InterceptorIgnoreHelper.InterceptorIgnoreCache.InterceptorIgnoreCacheBuilder(tenantLine=" + this.tenantLine + ", dynamicTableName=" + this.dynamicTableName + ", blockAttack=" + this.blockAttack + ", illegalSql=" + this.illegalSql + ", dataPermission=" + this.dataPermission + ", others=" + this.others + ")";
            }
        }
    }
}

