/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.core;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.ibatis.builder.BaseBuilder;
import org.apache.ibatis.builder.BuilderException;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.parsing.XNode;
import org.apache.ibatis.scripting.defaults.RawSqlSource;
import org.apache.ibatis.scripting.xmltags.ChooseSqlNode;
import org.apache.ibatis.scripting.xmltags.DynamicSqlSource;
import org.apache.ibatis.scripting.xmltags.ForEachSqlNode;
import org.apache.ibatis.scripting.xmltags.IfSqlNode;
import org.apache.ibatis.scripting.xmltags.MixedSqlNode;
import org.apache.ibatis.scripting.xmltags.SetSqlNode;
import org.apache.ibatis.scripting.xmltags.SqlNode;
import org.apache.ibatis.scripting.xmltags.StaticTextSqlNode;
import org.apache.ibatis.scripting.xmltags.TextSqlNode;
import org.apache.ibatis.scripting.xmltags.TrimSqlNode;
import org.apache.ibatis.scripting.xmltags.VarDeclSqlNode;
import org.apache.ibatis.scripting.xmltags.WhereSqlNode;
import org.apache.ibatis.session.Configuration;
import org.w3c.dom.NodeList;

public class MybatisXMLScriptBuilder
extends BaseBuilder {
    private final XNode context;
    private boolean isDynamic;
    private final Class<?> parameterType;
    private final Map<String, NodeHandler> nodeHandlerMap = new HashMap<String, NodeHandler>();
    private static final Map<String, WeakReference<String>> CACHE_STRING = new WeakHashMap<String, WeakReference<String>>();
    private static final StaticTextSqlNode SPACE_SQL_NODE = new StaticTextSqlNode(" ");

    public MybatisXMLScriptBuilder(Configuration configuration, XNode context) {
        this(configuration, context, null);
    }

    public MybatisXMLScriptBuilder(Configuration configuration, XNode context, Class<?> parameterType) {
        super(configuration);
        this.context = context;
        this.parameterType = parameterType;
        this.initNodeHandlerMap();
    }

    private void initNodeHandlerMap() {
        this.nodeHandlerMap.put("trim", new TrimHandler());
        this.nodeHandlerMap.put("where", new WhereHandler());
        this.nodeHandlerMap.put("set", new SetHandler());
        this.nodeHandlerMap.put("foreach", new ForEachHandler());
        this.nodeHandlerMap.put("if", new IfHandler());
        this.nodeHandlerMap.put("choose", new ChooseHandler());
        this.nodeHandlerMap.put("when", new IfHandler());
        this.nodeHandlerMap.put("otherwise", new OtherwiseHandler());
        this.nodeHandlerMap.put("bind", new BindHandler());
    }

    public SqlSource parseScriptNode() {
        MixedSqlNode rootSqlNode = this.parseDynamicTags(this.context);
        Object sqlSource = this.isDynamic ? new DynamicSqlSource(this.configuration, (SqlNode)rootSqlNode) : new RawSqlSource(this.configuration, (SqlNode)rootSqlNode, this.parameterType);
        return sqlSource;
    }

    private static synchronized String cacheStr(String str) {
        if (str == null) {
            return null;
        }
        String value = (String)CACHE_STRING.computeIfAbsent(str, WeakReference::new).get();
        if (StringUtils.isNotBlank(value)) {
            return value;
        }
        return str;
    }

    protected MixedSqlNode parseDynamicTags(XNode node) {
        ArrayList<SqlNode> contents = new ArrayList<SqlNode>();
        NodeList children = node.getNode().getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            XNode child = node.newXNode(children.item(i));
            if (child.getNode().getNodeType() == 4 || child.getNode().getNodeType() == 3) {
                String text = MybatisXMLScriptBuilder.cacheStr(child.getStringBody("")).trim();
                if (text.isEmpty()) {
                    contents.add((SqlNode)SPACE_SQL_NODE);
                    continue;
                }
                TextSqlNode textSqlNode = new TextSqlNode(text);
                if (textSqlNode.isDynamic()) {
                    contents.add((SqlNode)textSqlNode);
                    this.isDynamic = true;
                    continue;
                }
                contents.add((SqlNode)new StaticTextSqlNode(text));
                continue;
            }
            if (child.getNode().getNodeType() != 1) continue;
            String nodeName = child.getNode().getNodeName();
            NodeHandler handler = this.nodeHandlerMap.get(nodeName);
            if (handler == null) {
                throw new BuilderException("Unknown element <" + nodeName + "> in SQL statement.");
            }
            handler.handleNode(child, contents);
            this.isDynamic = true;
        }
        return new MixedSqlNode(contents);
    }

    private class TrimHandler
    implements NodeHandler {
        @Override
        public void handleNode(XNode nodeToHandle, List<SqlNode> targetContents) {
            MixedSqlNode mixedSqlNode = MybatisXMLScriptBuilder.this.parseDynamicTags(nodeToHandle);
            String prefix = MybatisXMLScriptBuilder.cacheStr(nodeToHandle.getStringAttribute("prefix"));
            String prefixOverrides = MybatisXMLScriptBuilder.cacheStr(nodeToHandle.getStringAttribute("prefixOverrides"));
            String suffix = MybatisXMLScriptBuilder.cacheStr(nodeToHandle.getStringAttribute("suffix"));
            String suffixOverrides = MybatisXMLScriptBuilder.cacheStr(nodeToHandle.getStringAttribute("suffixOverrides"));
            TrimSqlNode trim = new TrimSqlNode(MybatisXMLScriptBuilder.this.configuration, (SqlNode)mixedSqlNode, prefix, prefixOverrides, suffix, suffixOverrides);
            targetContents.add((SqlNode)trim);
        }
    }

    private class WhereHandler
    implements NodeHandler {
        @Override
        public void handleNode(XNode nodeToHandle, List<SqlNode> targetContents) {
            MixedSqlNode mixedSqlNode = MybatisXMLScriptBuilder.this.parseDynamicTags(nodeToHandle);
            WhereSqlNode where = new WhereSqlNode(MybatisXMLScriptBuilder.this.configuration, (SqlNode)mixedSqlNode);
            targetContents.add((SqlNode)where);
        }
    }

    private class SetHandler
    implements NodeHandler {
        @Override
        public void handleNode(XNode nodeToHandle, List<SqlNode> targetContents) {
            MixedSqlNode mixedSqlNode = MybatisXMLScriptBuilder.this.parseDynamicTags(nodeToHandle);
            SetSqlNode set = new SetSqlNode(MybatisXMLScriptBuilder.this.configuration, (SqlNode)mixedSqlNode);
            targetContents.add((SqlNode)set);
        }
    }

    private class ForEachHandler
    implements NodeHandler {
        @Override
        public void handleNode(XNode nodeToHandle, List<SqlNode> targetContents) {
            MixedSqlNode mixedSqlNode = MybatisXMLScriptBuilder.this.parseDynamicTags(nodeToHandle);
            String collection = MybatisXMLScriptBuilder.cacheStr(nodeToHandle.getStringAttribute("collection"));
            Boolean nullable = nodeToHandle.getBooleanAttribute("nullable");
            String item = MybatisXMLScriptBuilder.cacheStr(nodeToHandle.getStringAttribute("item"));
            String index = MybatisXMLScriptBuilder.cacheStr(nodeToHandle.getStringAttribute("index"));
            String open = MybatisXMLScriptBuilder.cacheStr(nodeToHandle.getStringAttribute("open"));
            String close = MybatisXMLScriptBuilder.cacheStr(nodeToHandle.getStringAttribute("close"));
            String separator = MybatisXMLScriptBuilder.cacheStr(nodeToHandle.getStringAttribute("separator"));
            ForEachSqlNode forEachSqlNode = new ForEachSqlNode(MybatisXMLScriptBuilder.this.configuration, (SqlNode)mixedSqlNode, collection, nullable, index, item, open, close, separator);
            targetContents.add((SqlNode)forEachSqlNode);
        }
    }

    private class IfHandler
    implements NodeHandler {
        @Override
        public void handleNode(XNode nodeToHandle, List<SqlNode> targetContents) {
            MixedSqlNode mixedSqlNode = MybatisXMLScriptBuilder.this.parseDynamicTags(nodeToHandle);
            String test = MybatisXMLScriptBuilder.cacheStr(nodeToHandle.getStringAttribute("test"));
            IfSqlNode ifSqlNode = new IfSqlNode((SqlNode)mixedSqlNode, test);
            targetContents.add((SqlNode)ifSqlNode);
        }
    }

    private class ChooseHandler
    implements NodeHandler {
        @Override
        public void handleNode(XNode nodeToHandle, List<SqlNode> targetContents) {
            ArrayList<SqlNode> whenSqlNodes = new ArrayList<SqlNode>();
            ArrayList<SqlNode> otherwiseSqlNodes = new ArrayList<SqlNode>();
            this.handleWhenOtherwiseNodes(nodeToHandle, whenSqlNodes, otherwiseSqlNodes);
            SqlNode defaultSqlNode = this.getDefaultSqlNode(otherwiseSqlNodes);
            ChooseSqlNode chooseSqlNode = new ChooseSqlNode(whenSqlNodes, defaultSqlNode);
            targetContents.add((SqlNode)chooseSqlNode);
        }

        private void handleWhenOtherwiseNodes(XNode chooseSqlNode, List<SqlNode> ifSqlNodes, List<SqlNode> defaultSqlNodes) {
            List children = chooseSqlNode.getChildren();
            for (XNode child : children) {
                String nodeName = child.getNode().getNodeName();
                NodeHandler handler = (NodeHandler)MybatisXMLScriptBuilder.this.nodeHandlerMap.get(nodeName);
                if (handler instanceof IfHandler) {
                    handler.handleNode(child, ifSqlNodes);
                    continue;
                }
                if (!(handler instanceof OtherwiseHandler)) continue;
                handler.handleNode(child, defaultSqlNodes);
            }
        }

        private SqlNode getDefaultSqlNode(List<SqlNode> defaultSqlNodes) {
            SqlNode defaultSqlNode = null;
            if (defaultSqlNodes.size() == 1) {
                defaultSqlNode = defaultSqlNodes.get(0);
            } else if (defaultSqlNodes.size() > 1) {
                throw new BuilderException("Too many default (otherwise) elements in choose statement.");
            }
            return defaultSqlNode;
        }
    }

    private class OtherwiseHandler
    implements NodeHandler {
        @Override
        public void handleNode(XNode nodeToHandle, List<SqlNode> targetContents) {
            MixedSqlNode mixedSqlNode = MybatisXMLScriptBuilder.this.parseDynamicTags(nodeToHandle);
            targetContents.add((SqlNode)mixedSqlNode);
        }
    }

    private class BindHandler
    implements NodeHandler {
        @Override
        public void handleNode(XNode nodeToHandle, List<SqlNode> targetContents) {
            String name = MybatisXMLScriptBuilder.cacheStr(nodeToHandle.getStringAttribute("name"));
            String expression = MybatisXMLScriptBuilder.cacheStr(nodeToHandle.getStringAttribute("value"));
            VarDeclSqlNode node = new VarDeclSqlNode(name, expression);
            targetContents.add((SqlNode)node);
        }
    }

    private static interface NodeHandler {
        public void handleNode(XNode var1, List<SqlNode> var2);
    }
}

