/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.extension.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.enums.SqlMethod;
import com.baomidou.mybatisplus.core.exceptions.MybatisPlusException;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.baomidou.mybatisplus.core.toolkit.ReflectionKit;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.sql.SqlHelper;
import com.baomidou.mybatisplus.extension.service.IService;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.binding.MapperMethod;
import org.apache.ibatis.session.SqlSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class ServiceImpl<M extends BaseMapper<T>, T>
implements IService<T> {
    @Autowired
    protected M baseMapper;

    protected static boolean retBool(Integer result) {
        return SqlHelper.retBool((Integer)result);
    }

    protected Class<T> currentModelClass() {
        return ReflectionKit.getSuperClassGenricType(this.getClass(), (int)1);
    }

    protected SqlSession sqlSessionBatch() {
        return SqlHelper.sqlSessionBatch(this.currentModelClass());
    }

    protected String sqlStatement(SqlMethod sqlMethod) {
        return SqlHelper.table(this.currentModelClass()).getSqlStatement(sqlMethod.getMethod());
    }

    @Override
    public boolean save(T entity) {
        return ServiceImpl.retBool(this.baseMapper.insert(entity));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean saveBatch(Collection<T> entityList) {
        return this.saveBatch(entityList, 30);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean saveBatch(Collection<T> entityList, int batchSize) {
        if (CollectionUtils.isEmpty(entityList)) {
            throw new IllegalArgumentException("Error: entityList must not be empty");
        }
        try (SqlSession batchSqlSession = this.sqlSessionBatch();){
            int i = 0;
            String sqlStatement = this.sqlStatement(SqlMethod.INSERT_ONE);
            Iterator<T> iterator = entityList.iterator();
            while (iterator.hasNext()) {
                batchSqlSession.insert(sqlStatement, iterator.next());
                if (i >= 1 && i % batchSize == 0) {
                    batchSqlSession.flushStatements();
                }
                ++i;
            }
            batchSqlSession.flushStatements();
        }
        catch (Throwable e) {
            throw new MybatisPlusException("Error: Cannot execute saveBatch Method. Cause", e);
        }
        return true;
    }

    @Override
    public boolean saveOrUpdate(T entity) {
        if (null != entity) {
            Class<?> cls = entity.getClass();
            TableInfo tableInfo = TableInfoHelper.getTableInfo(cls);
            if (null != tableInfo && StringUtils.isNotEmpty((CharSequence)tableInfo.getKeyProperty())) {
                Object idVal = ReflectionKit.getMethodValue(cls, entity, (String)tableInfo.getKeyProperty());
                if (StringUtils.checkValNull((Object)idVal)) {
                    return this.save(entity);
                }
                return this.updateById(entity) || this.save(entity);
            }
            throw new MybatisPlusException("Error:  Can not execute. Could not find @TableId.");
        }
        return false;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean saveOrUpdateBatch(Collection<T> entityList) {
        return this.saveOrUpdateBatch(entityList, 30);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean saveOrUpdateBatch(Collection<T> entityList, int batchSize) {
        if (CollectionUtils.isEmpty(entityList)) {
            throw new IllegalArgumentException("Error: entityList must not be empty");
        }
        try (SqlSession batchSqlSession = this.sqlSessionBatch();){
            Iterator<T> iterator = entityList.iterator();
            while (iterator.hasNext()) {
                this.saveOrUpdate(iterator.next());
            }
            batchSqlSession.flushStatements();
        }
        catch (Throwable e) {
            throw new MybatisPlusException("Error: Cannot execute saveOrUpdateBatch Method. Cause", e);
        }
        return true;
    }

    @Override
    public boolean removeById(Serializable id) {
        return SqlHelper.delBool((Integer)this.baseMapper.deleteById(id));
    }

    @Override
    public boolean removeByMap(Map<String, Object> columnMap) {
        if (ObjectUtils.isEmpty(columnMap)) {
            throw new MybatisPlusException("removeByMap columnMap is empty.");
        }
        return SqlHelper.delBool((Integer)this.baseMapper.deleteByMap(columnMap));
    }

    @Override
    public boolean remove(Wrapper<T> wrapper) {
        return SqlHelper.delBool((Integer)this.baseMapper.delete(wrapper));
    }

    @Override
    public boolean removeByIds(Collection<? extends Serializable> idList) {
        return SqlHelper.delBool((Integer)this.baseMapper.deleteBatchIds(idList));
    }

    @Override
    public boolean updateById(T entity) {
        return ServiceImpl.retBool(this.baseMapper.updateById(entity));
    }

    @Override
    public boolean update(T entity, Wrapper<T> wrapper) {
        return ServiceImpl.retBool(this.baseMapper.update(entity, wrapper));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateBatchById(Collection<T> entityList) {
        return this.updateBatchById(entityList, 30);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateBatchById(Collection<T> entityList, int batchSize) {
        if (CollectionUtils.isEmpty(entityList)) {
            throw new IllegalArgumentException("Error: entityList must not be empty");
        }
        try (SqlSession batchSqlSession = this.sqlSessionBatch();){
            int i = 0;
            String sqlStatement = this.sqlStatement(SqlMethod.UPDATE_BY_ID);
            Iterator<T> iterator = entityList.iterator();
            while (iterator.hasNext()) {
                MapperMethod.ParamMap param = new MapperMethod.ParamMap();
                param.put((Object)"et", iterator.next());
                batchSqlSession.update(sqlStatement, (Object)param);
                if (i >= 1 && i % batchSize == 0) {
                    batchSqlSession.flushStatements();
                }
                ++i;
            }
            batchSqlSession.flushStatements();
        }
        catch (Throwable e) {
            throw new MybatisPlusException("Error: Cannot execute updateBatchById Method. Cause", e);
        }
        return true;
    }

    @Override
    public T getById(Serializable id) {
        return (T)this.baseMapper.selectById(id);
    }

    @Override
    public Collection<T> listByIds(Collection<? extends Serializable> idList) {
        return this.baseMapper.selectBatchIds(idList);
    }

    @Override
    public Collection<T> listByMap(Map<String, Object> columnMap) {
        return this.baseMapper.selectByMap(columnMap);
    }

    @Override
    public T getOne(Wrapper<T> wrapper) {
        return (T)SqlHelper.getObject((List)this.baseMapper.selectList(wrapper));
    }

    @Override
    public Map<String, Object> getMap(Wrapper<T> wrapper) {
        return (Map)SqlHelper.getObject((List)this.baseMapper.selectMaps(wrapper));
    }

    @Override
    public Object getObj(Wrapper<T> wrapper) {
        return SqlHelper.getObject((List)this.baseMapper.selectObjs(wrapper));
    }

    @Override
    public int count(Wrapper<T> wrapper) {
        return SqlHelper.retCount((Integer)this.baseMapper.selectCount(wrapper));
    }

    @Override
    public List<T> list(Wrapper<T> wrapper) {
        return this.baseMapper.selectList(wrapper);
    }

    @Override
    public IPage<T> page(IPage<T> page, Wrapper<T> wrapper) {
        wrapper = SqlHelper.fillWrapper(page, wrapper);
        return this.baseMapper.selectPage(page, wrapper);
    }

    @Override
    public List<Map<String, Object>> listMaps(Wrapper<T> wrapper) {
        return this.baseMapper.selectMaps(wrapper);
    }

    @Override
    public List<Object> listObjs(Wrapper<T> wrapper) {
        return this.baseMapper.selectObjs(wrapper);
    }

    @Override
    public IPage<Map<String, Object>> pageMaps(IPage page, Wrapper<T> wrapper) {
        wrapper = SqlHelper.fillWrapper((IPage)page, wrapper);
        return this.baseMapper.selectMapsPage(page, wrapper);
    }
}

