/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.extension.activerecord;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.enums.SqlMethod;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.sql.SqlHelper;
import com.baomidou.mybatisplus.extension.toolkit.SqlRunner;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import org.apache.ibatis.session.SqlSession;
import org.springframework.transaction.annotation.Transactional;

public abstract class Model<T extends Model>
implements Serializable {
    private static final long serialVersionUID = 1L;

    @Transactional(rollbackFor={Exception.class})
    public boolean insert() {
        try (SqlSession session = this.sqlSession();){
            boolean bl = SqlHelper.retBool((Integer)session.insert(this.sqlStatement(SqlMethod.INSERT_ONE), (Object)this));
            return bl;
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean insertOrUpdate() {
        if (StringUtils.checkValNull((Object)this.pkVal())) {
            return this.insert();
        }
        return this.updateById() || this.insert();
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean deleteById(Serializable id) {
        try (SqlSession session = this.sqlSession();){
            boolean bl = SqlHelper.delBool((Integer)session.delete(this.sqlStatement(SqlMethod.DELETE_BY_ID), (Object)id));
            return bl;
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean deleteById() {
        Assert.isFalse((boolean)StringUtils.checkValNull((Object)this.pkVal()), (String)"deleteById primaryKey is null.");
        return this.deleteById(this.pkVal());
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean delete(Wrapper wrapper) {
        HashMap<String, Wrapper> map = new HashMap<String, Wrapper>(1);
        map.put("ew", wrapper);
        try (SqlSession session = this.sqlSession();){
            boolean bl = SqlHelper.delBool((Integer)session.delete(this.sqlStatement(SqlMethod.DELETE), map));
            return bl;
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean updateById() {
        Assert.isFalse((boolean)StringUtils.checkValNull((Object)this.pkVal()), (String)"updateById primaryKey is null.");
        HashMap<String, Model> map = new HashMap<String, Model>(1);
        map.put("et", this);
        return SqlHelper.retBool((Integer)this.sqlSession().update(this.sqlStatement(SqlMethod.UPDATE_BY_ID), map));
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean update(Wrapper wrapper) {
        HashMap<String, Model<T>> map = new HashMap<String, Model<T>>(2);
        map.put("et", this);
        map.put("ew", (Model<T>)wrapper);
        try (SqlSession session = this.sqlSession();){
            boolean bl = SqlHelper.retBool((Integer)session.update(this.sqlStatement(SqlMethod.UPDATE), map));
            return bl;
        }
    }

    public List<T> selectAll() {
        try (SqlSession session = this.sqlSession();){
            List list = session.selectList(this.sqlStatement(SqlMethod.SELECT_LIST));
            return list;
        }
    }

    public T selectById(Serializable id) {
        try (SqlSession session = this.sqlSession();){
            Model model = (Model)session.selectOne(this.sqlStatement(SqlMethod.SELECT_BY_ID), (Object)id);
            return (T)model;
        }
    }

    public T selectById() {
        Assert.isFalse((boolean)StringUtils.checkValNull((Object)this.pkVal()), (String)"selectById primaryKey is null.");
        return this.selectById(this.pkVal());
    }

    public List<T> selectList(Wrapper wrapper) {
        HashMap<String, Wrapper> map = new HashMap<String, Wrapper>(1);
        map.put("ew", wrapper);
        try (SqlSession session = this.sqlSession();){
            List list = session.selectList(this.sqlStatement(SqlMethod.SELECT_LIST), map);
            return list;
        }
    }

    public T selectOne(Wrapper wrapper) {
        return (T)((Model)SqlHelper.getObject(this.selectList(wrapper)));
    }

    public IPage<T> selectPage(IPage<T> page, Wrapper<T> wrapper) {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put("ew", SqlHelper.fillWrapper(page, wrapper));
        map.put("page", page);
        try (SqlSession session = this.sqlSession();){
            page.setRecords(session.selectList(this.sqlStatement(SqlMethod.SELECT_PAGE), map));
        }
        return page;
    }

    public int selectCount(Wrapper wrapper) {
        HashMap<String, Wrapper> map = new HashMap<String, Wrapper>(1);
        map.put("ew", wrapper);
        try (SqlSession session = this.sqlSession();){
            int n = SqlHelper.retCount((Integer)((Integer)session.selectOne(this.sqlStatement(SqlMethod.SELECT_COUNT), map)));
            return n;
        }
    }

    public SqlRunner sql() {
        return new SqlRunner(this.getClass());
    }

    protected SqlSession sqlSession() {
        return SqlHelper.sqlSession(this.getClass());
    }

    protected String sqlStatement(SqlMethod sqlMethod) {
        return this.sqlStatement(sqlMethod.getMethod());
    }

    protected String sqlStatement(String sqlMethod) {
        return SqlHelper.table(this.getClass()).getSqlStatement(sqlMethod);
    }

    protected abstract Serializable pkVal();
}

