/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.extension.plugins.pagination.optimize;

import com.baomidou.mybatisplus.core.parser.ISqlParser;
import com.baomidou.mybatisplus.core.parser.SqlInfo;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.sql.SqlUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.select.Distinct;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.reflection.MetaObject;

public class JsqlParserCountOptimize
implements ISqlParser {
    private final Log logger = LogFactory.getLog(JsqlParserCountOptimize.class);
    private static final List<SelectItem> COUNT_SELECT_ITEM = JsqlParserCountOptimize.countSelectItem();

    public SqlInfo optimizeSql(MetaObject metaObject, String sql) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" JsqlParserCountOptimize sql=" + sql);
        }
        SqlInfo sqlInfo = SqlInfo.newInstance();
        try {
            Select selectStatement = (Select)CCJSqlParserUtil.parse((String)sql);
            PlainSelect plainSelect = (PlainSelect)selectStatement.getSelectBody();
            Distinct distinct = plainSelect.getDistinct();
            List groupBy = plainSelect.getGroupByColumnReferences();
            List orderBy = plainSelect.getOrderByElements();
            if (CollectionUtils.isEmpty((Collection)groupBy) && CollectionUtils.isNotEmpty((Collection)orderBy)) {
                plainSelect.setOrderByElements(null);
                sqlInfo.setOrderBy(false);
            }
            for (SelectItem item : plainSelect.getSelectItems()) {
                if (!item.toString().contains("?")) continue;
                sqlInfo.setSql(SqlUtils.getOriginalCountSql((String)selectStatement.toString()));
                return sqlInfo;
            }
            if (distinct != null || CollectionUtils.isNotEmpty((Collection)groupBy)) {
                sqlInfo.setSql(SqlUtils.getOriginalCountSql((String)selectStatement.toString()));
                return sqlInfo;
            }
            plainSelect.setSelectItems(COUNT_SELECT_ITEM);
            sqlInfo.setSql(selectStatement.toString());
            return sqlInfo;
        }
        catch (Throwable e) {
            sqlInfo.setSql(SqlUtils.getOriginalCountSql((String)sql));
            return sqlInfo;
        }
    }

    private static List<SelectItem> countSelectItem() {
        Function function = new Function();
        function.setName("COUNT");
        ArrayList<LongValue> expressions = new ArrayList<LongValue>();
        LongValue longValue = new LongValue(1L);
        ExpressionList expressionList = new ExpressionList();
        expressions.add(longValue);
        expressionList.setExpressions(expressions);
        function.setParameters(expressionList);
        ArrayList<SelectItem> selectItems = new ArrayList<SelectItem>();
        SelectExpressionItem selectExpressionItem = new SelectExpressionItem((Expression)function);
        selectItems.add((SelectItem)selectExpressionItem);
        return selectItems;
    }
}

