/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.extension.activerecord;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.enums.SqlMethod;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.GlobalConfigUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.sql.SqlHelper;
import com.baomidou.mybatisplus.extension.toolkit.SqlRunner;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionUtils;
import org.springframework.transaction.annotation.Transactional;

public abstract class Model<T extends Model>
implements Serializable {
    private static final long serialVersionUID = 1L;

    @Transactional(rollbackFor={Exception.class})
    public boolean insert() {
        SqlSession sqlSession = this.sqlSession();
        try {
            boolean bl = SqlHelper.retBool((Integer)sqlSession.insert(this.sqlStatement(SqlMethod.INSERT_ONE), (Object)this));
            return bl;
        }
        finally {
            this.closeSqlSession(sqlSession);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean insertOrUpdate() {
        if (StringUtils.checkValNull((Object)this.pkVal())) {
            return this.insert();
        }
        return this.updateById() || this.insert();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(rollbackFor={Exception.class})
    public boolean deleteById(Serializable id) {
        SqlSession sqlSession = this.sqlSession();
        try {
            boolean bl = SqlHelper.delBool((Integer)sqlSession.delete(this.sqlStatement(SqlMethod.DELETE_BY_ID), (Object)id));
            return bl;
        }
        finally {
            this.closeSqlSession(sqlSession);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean deleteById() {
        Assert.isFalse((boolean)StringUtils.checkValNull((Object)this.pkVal()), (String)"deleteById primaryKey is null.");
        return this.deleteById(this.pkVal());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(rollbackFor={Exception.class})
    public boolean delete(Wrapper wrapper) {
        HashMap<String, Wrapper> map = new HashMap<String, Wrapper>(1);
        map.put("ew", wrapper);
        SqlSession sqlSession = this.sqlSession();
        try {
            boolean bl = SqlHelper.delBool((Integer)sqlSession.delete(this.sqlStatement(SqlMethod.DELETE), map));
            return bl;
        }
        finally {
            this.closeSqlSession(sqlSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(rollbackFor={Exception.class})
    public boolean updateById() {
        Assert.isFalse((boolean)StringUtils.checkValNull((Object)this.pkVal()), (String)"updateById primaryKey is null.");
        HashMap<String, Model> map = new HashMap<String, Model>(1);
        map.put("et", this);
        SqlSession sqlSession = this.sqlSession();
        try {
            boolean bl = SqlHelper.retBool((Integer)sqlSession.update(this.sqlStatement(SqlMethod.UPDATE_BY_ID), map));
            return bl;
        }
        finally {
            this.closeSqlSession(sqlSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(rollbackFor={Exception.class})
    public boolean update(Wrapper wrapper) {
        HashMap<String, Model<T>> map = new HashMap<String, Model<T>>(2);
        map.put("et", this);
        map.put("ew", (Model<T>)wrapper);
        SqlSession sqlSession = this.sqlSession();
        try {
            boolean bl = SqlHelper.retBool((Integer)sqlSession.update(this.sqlStatement(SqlMethod.UPDATE), map));
            return bl;
        }
        finally {
            this.closeSqlSession(sqlSession);
        }
    }

    public List<T> selectAll() {
        SqlSession sqlSession = this.sqlSession();
        try {
            List list = sqlSession.selectList(this.sqlStatement(SqlMethod.SELECT_LIST));
            return list;
        }
        finally {
            this.closeSqlSession(sqlSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T selectById(Serializable id) {
        SqlSession sqlSession = this.sqlSession();
        try {
            Model model = (Model)sqlSession.selectOne(this.sqlStatement(SqlMethod.SELECT_BY_ID), (Object)id);
            return (T)model;
        }
        finally {
            this.closeSqlSession(sqlSession);
        }
    }

    public T selectById() {
        Assert.isFalse((boolean)StringUtils.checkValNull((Object)this.pkVal()), (String)"selectById primaryKey is null.");
        return this.selectById(this.pkVal());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> selectList(Wrapper wrapper) {
        HashMap<String, Wrapper> map = new HashMap<String, Wrapper>(1);
        map.put("ew", wrapper);
        SqlSession sqlSession = this.sqlSession();
        try {
            List list = sqlSession.selectList(this.sqlStatement(SqlMethod.SELECT_LIST), map);
            return list;
        }
        finally {
            this.closeSqlSession(sqlSession);
        }
    }

    public T selectOne(Wrapper wrapper) {
        return (T)((Model)SqlHelper.getObject(this.selectList(wrapper)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPage<T> selectPage(IPage<T> page, Wrapper<T> wrapper) {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put("ew", wrapper);
        map.put("page", page);
        SqlSession sqlSession = this.sqlSession();
        try {
            page.setRecords(sqlSession.selectList(this.sqlStatement(SqlMethod.SELECT_PAGE), map));
        }
        finally {
            this.closeSqlSession(sqlSession);
        }
        return page;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int selectCount(Wrapper wrapper) {
        HashMap<String, Wrapper> map = new HashMap<String, Wrapper>(1);
        map.put("ew", wrapper);
        SqlSession sqlSession = this.sqlSession();
        try {
            int n = SqlHelper.retCount((Integer)((Integer)sqlSession.selectOne(this.sqlStatement(SqlMethod.SELECT_COUNT), map)));
            return n;
        }
        finally {
            this.closeSqlSession(sqlSession);
        }
    }

    public SqlRunner sql() {
        return new SqlRunner(this.getClass());
    }

    protected SqlSession sqlSession() {
        return SqlHelper.sqlSession(this.getClass());
    }

    protected String sqlStatement(SqlMethod sqlMethod) {
        return this.sqlStatement(sqlMethod.getMethod());
    }

    protected String sqlStatement(String sqlMethod) {
        return SqlHelper.table(this.getClass()).getSqlStatement(sqlMethod);
    }

    protected abstract Serializable pkVal();

    protected void closeSqlSession(SqlSession sqlSession) {
        SqlSessionUtils.closeSqlSession((SqlSession)sqlSession, (SqlSessionFactory)GlobalConfigUtils.currentSessionFactory(this.getClass()));
    }
}

