/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.generator.config.converts;

import com.baomidou.mybatisplus.generator.config.GlobalConfig;
import com.baomidou.mybatisplus.generator.config.ITypeConvert;
import com.baomidou.mybatisplus.generator.config.rules.DbColumnType;
import com.baomidou.mybatisplus.generator.config.rules.IColumnType;

public class SqlServerTypeConvert
implements ITypeConvert {
    @Override
    public IColumnType processTypeConvert(GlobalConfig globalConfig, String fieldType) {
        String t = fieldType.toLowerCase();
        if (t.contains("char") || t.contains("text") || t.contains("xml")) {
            return DbColumnType.STRING;
        }
        if (t.contains("bigint")) {
            return DbColumnType.LONG;
        }
        if (t.contains("int")) {
            return DbColumnType.INTEGER;
        }
        if (t.contains("date") || t.contains("time")) {
            return DbColumnType.DATE;
        }
        if (t.contains("text")) {
            return DbColumnType.STRING;
        }
        if (t.contains("bit")) {
            return DbColumnType.BOOLEAN;
        }
        if (t.contains("decimal") || t.contains("numeric")) {
            return DbColumnType.DOUBLE;
        }
        if (t.contains("money")) {
            return DbColumnType.BIG_DECIMAL;
        }
        if (t.contains("binary") || t.contains("image")) {
            return DbColumnType.BYTE_ARRAY;
        }
        if (t.contains("float") || t.contains("real")) {
            return DbColumnType.FLOAT;
        }
        return DbColumnType.STRING;
    }
}

