/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.generator.config.querys;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.generator.config.IDbQuery;
import com.baomidou.mybatisplus.generator.config.querys.DB2Query;
import com.baomidou.mybatisplus.generator.config.querys.DMQuery;
import com.baomidou.mybatisplus.generator.config.querys.FirebirdQuery;
import com.baomidou.mybatisplus.generator.config.querys.GaussQuery;
import com.baomidou.mybatisplus.generator.config.querys.H2Query;
import com.baomidou.mybatisplus.generator.config.querys.KingbaseESQuery;
import com.baomidou.mybatisplus.generator.config.querys.MariadbQuery;
import com.baomidou.mybatisplus.generator.config.querys.MySqlQuery;
import com.baomidou.mybatisplus.generator.config.querys.OracleQuery;
import com.baomidou.mybatisplus.generator.config.querys.OscarQuery;
import com.baomidou.mybatisplus.generator.config.querys.PostgreSqlQuery;
import com.baomidou.mybatisplus.generator.config.querys.SqlServerQuery;
import com.baomidou.mybatisplus.generator.config.querys.SqliteQuery;
import java.util.EnumMap;
import java.util.Map;

public class DbQueryRegistry {
    private final Map<DbType, IDbQuery> db_query_enum_map = new EnumMap<DbType, IDbQuery>(DbType.class);

    public DbQueryRegistry() {
        this.db_query_enum_map.put(DbType.ORACLE, new OracleQuery());
        this.db_query_enum_map.put(DbType.SQL_SERVER, new SqlServerQuery());
        this.db_query_enum_map.put(DbType.POSTGRE_SQL, new PostgreSqlQuery());
        this.db_query_enum_map.put(DbType.DB2, new DB2Query());
        this.db_query_enum_map.put(DbType.MARIADB, new MariadbQuery());
        this.db_query_enum_map.put(DbType.H2, new H2Query());
        this.db_query_enum_map.put(DbType.SQLITE, new SqliteQuery());
        this.db_query_enum_map.put(DbType.DM, new DMQuery());
        this.db_query_enum_map.put(DbType.KINGBASE_ES, new KingbaseESQuery());
        this.db_query_enum_map.put(DbType.MYSQL, new MySqlQuery());
        this.db_query_enum_map.put(DbType.GAUSS, new GaussQuery());
        this.db_query_enum_map.put(DbType.OSCAR, new OscarQuery());
        this.db_query_enum_map.put(DbType.FIREBIRD, new FirebirdQuery());
    }

    public IDbQuery getDbQuery(DbType dbType) {
        return this.db_query_enum_map.get(dbType);
    }
}

