/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.generator.config.builder;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.generator.config.GlobalConfig;
import com.baomidou.mybatisplus.generator.config.PackageConfig;
import com.baomidou.mybatisplus.generator.config.TemplateConfig;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

class PathInfoHandler {
    private final Map<String, String> pathInfo = new HashMap<String, String>();
    private final String outputDir;
    private final PackageConfig packageConfig;

    PathInfoHandler(GlobalConfig globalConfig, TemplateConfig templateConfig, PackageConfig packageConfig) {
        this.outputDir = globalConfig.getOutputDir();
        this.packageConfig = packageConfig;
        Map<String, String> pathInfo = packageConfig.getPathInfo();
        if (CollectionUtils.isNotEmpty(pathInfo)) {
            this.pathInfo.putAll(pathInfo);
        } else {
            this.putPathInfo(templateConfig.getEntity(globalConfig.isKotlin()), "entity_path", "Entity");
            this.putPathInfo(templateConfig.getMapper(), "mapper_path", "Mapper");
            this.putPathInfo(templateConfig.getXml(), "xml_path", "Mapper");
            this.putPathInfo(templateConfig.getService(), "service_path", "Service");
            this.putPathInfo(templateConfig.getServiceImpl(), "service_impl_path", "ServiceImpl");
            this.putPathInfo(templateConfig.getController(), "controller_path", "Controller");
        }
    }

    public Map<String, String> getPathInfo() {
        return Collections.unmodifiableMap(this.pathInfo);
    }

    private void putPathInfo(String template, String path, String module) {
        if (StringUtils.isNotBlank((CharSequence)template)) {
            this.pathInfo.put(path, this.joinPath(this.outputDir, this.packageConfig.getPackageInfo(module)));
        }
    }

    private String joinPath(String parentDir, String packageName) {
        if (StringUtils.isBlank((CharSequence)parentDir)) {
            parentDir = System.getProperty("java.io.tmpdir");
        }
        if (!StringUtils.endsWith((String)parentDir, (String)File.separator)) {
            parentDir = parentDir + File.separator;
        }
        packageName = packageName.replaceAll("\\.", "\\" + File.separator);
        return parentDir + packageName;
    }
}

