/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.generator.config;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.generator.config.StrategyConfig;
import com.baomidou.mybatisplus.generator.config.po.TableField;
import com.baomidou.mybatisplus.generator.config.po.TableInfo;
import com.baomidou.mybatisplus.generator.config.rules.NamingStrategy;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public interface INameConvert {
    @NotNull
    public String entityNameConvert(@NotNull TableInfo var1);

    @NotNull
    public String propertyNameConvert(@NotNull TableField var1);

    public static class DefaultNameConvert
    implements INameConvert {
        private final StrategyConfig strategyConfig;

        public DefaultNameConvert(StrategyConfig strategyConfig) {
            this.strategyConfig = strategyConfig;
        }

        @Override
        @NotNull
        public String entityNameConvert(@NotNull TableInfo tableInfo) {
            return NamingStrategy.capitalFirst(this.processName(tableInfo.getName(), this.strategyConfig.entity().getNaming(), this.strategyConfig.getTablePrefix(), this.strategyConfig.getTableSuffix()));
        }

        @Override
        @NotNull
        public String propertyNameConvert(@NotNull TableField field) {
            return this.processName(field.getName(), this.strategyConfig.entity().getColumnNaming(), this.strategyConfig.getFieldPrefix(), this.strategyConfig.getFieldSuffix());
        }

        private String processName(String name, NamingStrategy strategy, Set<String> prefix, Set<String> suffix) {
            String propertyName = name;
            if (!prefix.isEmpty()) {
                propertyName = NamingStrategy.removePrefix(propertyName, prefix);
            }
            if (!suffix.isEmpty()) {
                propertyName = NamingStrategy.removeSuffix(propertyName, suffix);
            }
            if (StringUtils.isBlank((CharSequence)propertyName)) {
                throw new RuntimeException(String.format("%s \u7684\u540d\u79f0\u8f6c\u6362\u7ed3\u679c\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u914d\u7f6e\u95ee\u9898", name));
            }
            if (NamingStrategy.underline_to_camel.equals((Object)strategy)) {
                return NamingStrategy.underlineToCamel(propertyName);
            }
            return propertyName;
        }
    }
}

