/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.generator.index;

import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.kotlin.KtQueryWrapper;
import com.baomidou.mybatisplus.extension.kotlin.KtUpdateWrapper;
import com.baomidou.mybatisplus.generator.config.GlobalConfig;
import com.baomidou.mybatisplus.generator.config.StrategyConfig;
import com.baomidou.mybatisplus.generator.config.builder.Entity;
import com.baomidou.mybatisplus.generator.config.po.TableField;
import com.baomidou.mybatisplus.generator.config.po.TableInfo;
import com.baomidou.mybatisplus.generator.index.AbstractMapperMethodHandler;
import com.baomidou.mybatisplus.generator.jdbc.DatabaseMetaDataWrapper;
import com.baomidou.mybatisplus.generator.model.MapperMethod;
import com.baomidou.mybatisplus.generator.util.KotlinTypeUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class DefaultGenerateMapperLambdaMethodHandler
extends AbstractMapperMethodHandler {
    private final boolean singleIndex;

    public DefaultGenerateMapperLambdaMethodHandler() {
        this(true);
    }

    public DefaultGenerateMapperLambdaMethodHandler(boolean singleIndex) {
        this.singleIndex = singleIndex;
    }

    @Override
    public List<MapperMethod> getMethodList(TableInfo tableInfo) {
        Map<String, List<DatabaseMetaDataWrapper.Index>> indexlistMap = tableInfo.getIndexList().stream().collect(Collectors.groupingBy(DatabaseMetaDataWrapper.Index::getName));
        String entityName = tableInfo.getEntityName();
        GlobalConfig globalConfig = tableInfo.getGlobalConfig();
        StrategyConfig strategyConfig = tableInfo.getStrategyConfig();
        Entity entity = strategyConfig.entity();
        Set<Map.Entry<String, List<DatabaseMetaDataWrapper.Index>>> entrySet = indexlistMap.entrySet();
        ArrayList<MapperMethod> methodList = new ArrayList<MapperMethod>();
        for (Map.Entry<String, List<DatabaseMetaDataWrapper.Index>> entry : entrySet) {
            String deleteByMethod;
            String updateByMethod;
            String selectByMethod;
            String indexName = entry.getKey();
            List<DatabaseMetaDataWrapper.Index> indexList = entry.getValue();
            int indexSize = indexList.size();
            if (this.singleIndex && indexSize > 1 || "PRIMARY".equals(indexName) && indexSize == 1) continue;
            Map<String, TableField> tableFieldMap = tableInfo.getTableFieldMap();
            StringBuilder baseMethodNameBuilder = new StringBuilder();
            StringBuilder argsBuilder = new StringBuilder();
            StringBuilder baseWrapperBuilder = new StringBuilder();
            boolean uniqueKey = false;
            ArrayList<TableField> tableFieldList = new ArrayList<TableField>();
            for (int i = 0; i < indexSize; ++i) {
                DatabaseMetaDataWrapper.Index index = indexList.get(i);
                if (index.isUnique()) {
                    uniqueKey = true;
                }
                TableField tableField = tableFieldMap.get(index.getColumnName());
                if (index.getColumnName().equals(entity.getLogicDeleteColumnName()) || tableField.getPropertyName().equals(entity.getLogicDeletePropertyName())) continue;
                tableFieldList.add(tableField);
                baseMethodNameBuilder.append(tableField.getCapitalName());
                if (indexSize > 1) {
                    baseWrapperBuilder.append("eq(ObjectUtils.isNotNull(").append(tableField.getPropertyName()).append(")").append(", ").append(entityName).append("::");
                } else {
                    baseWrapperBuilder.append("eq(").append(entityName).append("::");
                }
                if (globalConfig.isKotlin()) {
                    baseWrapperBuilder.append(tableField.getPropertyName()).append(",").append(" ").append(tableField.getPropertyName()).append(")");
                    argsBuilder.append(tableField.getPropertyName()).append(":").append(" ").append(KotlinTypeUtils.getStringType(tableField.getColumnType()));
                    if (i > 0) {
                        argsBuilder.append("?");
                    }
                } else {
                    if ("boolean".equals(tableField.getPropertyType())) {
                        baseWrapperBuilder.append("is").append(tableField.getCapitalName());
                    } else {
                        baseWrapperBuilder.append("get").append(tableField.getCapitalName());
                    }
                    baseWrapperBuilder.append(",").append(" ").append(tableField.getPropertyName()).append(")");
                    argsBuilder.append(tableField.getColumnType().getType()).append(" ").append(tableField.getPropertyName());
                }
                if (i >= indexSize - 1) continue;
                baseWrapperBuilder.append(".");
                baseMethodNameBuilder.append("And");
                argsBuilder.append(", ");
            }
            String baseMethodName = baseMethodNameBuilder.toString();
            if (StringUtils.isBlank((CharSequence)baseMethodName)) continue;
            boolean returnList = indexSize > 1 || !uniqueKey;
            String args = argsBuilder.toString();
            String baseWrapper = baseWrapperBuilder.toString();
            if (globalConfig.isKotlin()) {
                selectByMethod = returnList ? this.buildKotlinMethod("selectBy" + baseMethodName, args, "List<" + tableInfo.getEntityName() + ">?", "selectList(KtQueryWrapper(" + tableInfo.getEntityName() + "::class.java)." + baseWrapper + ")") : this.buildKotlinMethod("selectBy" + baseMethodName, args, tableInfo.getEntityName() + "?", "selectOne(KtQueryWrapper(" + tableInfo.getEntityName() + "::class.java)." + baseWrapper + ")");
                updateByMethod = this.buildKotlinMethod("updateBy" + baseMethodName, "entity: " + tableInfo.getEntityName() + ", " + args, "Int", "update(entity, KtUpdateWrapper(" + tableInfo.getEntityName() + "::class.java)." + baseWrapper + ")");
                deleteByMethod = this.buildKotlinMethod("deleteBy" + baseMethodName, args, "Int", "delete(KtUpdateWrapper(" + tableInfo.getEntityName() + "::class.java)." + baseWrapper + ")");
                methodList.add(new MapperMethod(indexName, selectByMethod, tableFieldList));
                methodList.add(new MapperMethod(indexName, updateByMethod, tableFieldList));
                methodList.add(new MapperMethod(indexName, deleteByMethod, tableFieldList));
                continue;
            }
            selectByMethod = returnList ? this.buildMethod("selectBy" + baseMethodName, args, "List<" + entityName + ">", "selectList(Wrappers.<" + tableInfo.getEntityName() + ">lambdaQuery()." + baseWrapper + ")") : this.buildMethod("selectBy" + baseMethodName, args, entityName, "selectOne(Wrappers.<" + tableInfo.getEntityName() + ">lambdaQuery()." + baseWrapper + ")");
            updateByMethod = this.buildMethod("updateBy" + baseMethodName, tableInfo.getEntityName() + " entity, " + args, "int", "update(entity, Wrappers.<" + tableInfo.getEntityName() + ">lambdaUpdate()." + baseWrapper + ")");
            deleteByMethod = this.buildMethod("deleteBy" + baseMethodName, args, "int", "delete(Wrappers.<" + tableInfo.getEntityName() + ">lambdaUpdate()." + baseWrapper + ")");
            methodList.add(new MapperMethod(indexName, selectByMethod, tableFieldList));
            methodList.add(new MapperMethod(indexName, updateByMethod, tableFieldList));
            methodList.add(new MapperMethod(indexName, deleteByMethod, tableFieldList));
        }
        return methodList;
    }

    @Override
    public Set<String> getImportPackages(TableInfo tableInfo) {
        GlobalConfig globalConfig = tableInfo.getGlobalConfig();
        HashSet<String> imports = new HashSet<String>();
        if (!this.singleIndex) {
            imports.add(ObjectUtils.class.getName());
        }
        if (!globalConfig.isKotlin()) {
            imports.add(List.class.getName());
        }
        if (globalConfig.isKotlin()) {
            imports.add(KtQueryWrapper.class.getName());
            imports.add(KtUpdateWrapper.class.getName());
        } else {
            imports.add(Wrappers.class.getName());
        }
        return imports;
    }
}

