/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.generator.jdbc;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.ibatis.type.JdbcType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseMetaDataWrapper {
    private static final Logger logger = LoggerFactory.getLogger(DatabaseMetaDataWrapper.class);
    private final Connection connection;
    private final DatabaseMetaData databaseMetaData;
    private final String catalog;
    private final String schema;

    public DatabaseMetaDataWrapper(Connection connection, String schemaName) {
        try {
            if (null == connection) {
                throw new RuntimeException("\u6570\u636e\u5e93\u8fde\u63a5\u4e0d\u80fd\u4e3a\u7a7a");
            }
            this.connection = connection;
            this.databaseMetaData = connection.getMetaData();
            this.catalog = connection.getCatalog();
            this.schema = schemaName;
        }
        catch (SQLException e) {
            throw new RuntimeException("\u83b7\u53d6\u5143\u6570\u636e\u9519\u8bef:", e);
        }
    }

    public void closeConnection() {
        Optional.ofNullable(this.connection).ifPresent(con -> {
            try {
                con.close();
            }
            catch (SQLException sqlException) {
                sqlException.printStackTrace();
            }
        });
    }

    public Map<String, Column> getColumnsInfo(String tableNamePattern, boolean queryPrimaryKey) {
        return this.getColumnsInfo(this.catalog, this.schema, tableNamePattern, queryPrimaryKey);
    }

    public List<Index> getIndex(String tableName) {
        ArrayList<Index> indexList = new ArrayList<Index>();
        try (ResultSet resultSet = this.databaseMetaData.getIndexInfo(this.catalog, this.schema, tableName, false, false);){
            while (resultSet.next()) {
                Index index = new Index(resultSet);
                if (!StringUtils.isNotBlank((CharSequence)index.getColumnName())) continue;
                indexList.add(new Index(resultSet));
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("\u8bfb\u53d6\u7d22\u5f15\u4fe1\u606f:" + tableName + "\u9519\u8bef:", e);
        }
        return indexList;
    }

    public Map<String, Column> getColumnsInfo(String catalog, String schema, String tableName, boolean queryPrimaryKey) {
        Map<String, Column> map;
        block22: {
            HashSet<String> primaryKeys = new HashSet<String>();
            if (queryPrimaryKey) {
                try (ResultSet primaryKeysResultSet = this.databaseMetaData.getPrimaryKeys(catalog, schema, tableName);){
                    while (primaryKeysResultSet.next()) {
                        String columnName = primaryKeysResultSet.getString("COLUMN_NAME");
                        primaryKeys.add(columnName);
                    }
                    if (primaryKeys.size() > 1) {
                        logger.warn("\u5f53\u524d\u8868:{}\uff0c\u5b58\u5728\u591a\u4e3b\u952e\u60c5\u51b5\uff01", (Object)tableName);
                    }
                }
                catch (SQLException e) {
                    throw new RuntimeException("\u8bfb\u53d6\u8868\u4e3b\u952e\u4fe1\u606f:" + tableName + "\u9519\u8bef:", e);
                }
            }
            LinkedHashMap<String, Column> columnsInfoMap = new LinkedHashMap<String, Column>();
            ResultSet resultSet = this.databaseMetaData.getColumns(catalog, schema, tableName, "%");
            try {
                while (resultSet.next()) {
                    Column column = new Column();
                    String name = resultSet.getString("COLUMN_NAME");
                    column.name = name;
                    column.primaryKey = primaryKeys.contains(name);
                    column.typeName = resultSet.getString("TYPE_NAME");
                    int dataType = resultSet.getInt("DATA_TYPE");
                    JdbcType jdbcType = JdbcType.forCode((int)dataType);
                    if (jdbcType == null) {
                        jdbcType = JdbcType.OTHER;
                    }
                    column.jdbcType = jdbcType;
                    column.length = resultSet.getInt("COLUMN_SIZE");
                    column.scale = resultSet.getInt("DECIMAL_DIGITS");
                    column.remarks = this.formatComment(resultSet.getString("REMARKS"));
                    column.defaultValue = resultSet.getString("COLUMN_DEF");
                    column.nullable = resultSet.getInt("NULLABLE") == 1;
                    column.generatedColumn = this.isGeneratedOrAutoIncrementColumn(resultSet, "IS_GENERATEDCOLUMN");
                    column.autoIncrement = this.isGeneratedOrAutoIncrementColumn(resultSet, "IS_AUTOINCREMENT");
                    columnsInfoMap.put(name.toLowerCase(), column);
                }
                map = Collections.unmodifiableMap(columnsInfoMap);
                if (resultSet == null) break block22;
            }
            catch (Throwable throwable) {
                try {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new RuntimeException("\u8bfb\u53d6\u8868\u5b57\u6bb5\u4fe1\u606f:" + tableName + "\u9519\u8bef:", e);
                }
            }
            resultSet.close();
        }
        return map;
    }

    private boolean isGeneratedOrAutoIncrementColumn(ResultSet resultSet, String columnLabel) {
        try {
            return "YES".equals(resultSet.getString(columnLabel));
        }
        catch (SQLException sQLException) {
            return false;
        }
    }

    public String formatComment(String comment) {
        return StringUtils.isBlank((CharSequence)comment) ? "" : comment.replaceAll("\r\n", "\t");
    }

    public Table getTableInfo(String tableName) {
        return this.getTableInfo(this.catalog, this.schema, tableName);
    }

    public List<Table> getTables(String tableNamePattern, String[] types) {
        return this.getTables(this.catalog, this.schema, tableNamePattern, types);
    }

    public List<Table> getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) {
        ArrayList<Table> tables = new ArrayList<Table>();
        try (ResultSet resultSet = this.databaseMetaData.getTables(catalog, schemaPattern, tableNamePattern, types);){
            while (resultSet.next()) {
                Table table = new Table();
                table.name = resultSet.getString("TABLE_NAME");
                table.remarks = this.formatComment(resultSet.getString("REMARKS"));
                table.tableType = resultSet.getString("TABLE_TYPE");
                tables.add(table);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("\u8bfb\u53d6\u6570\u636e\u5e93\u8868\u4fe1\u606f\u51fa\u73b0\u9519\u8bef", e);
        }
        return tables;
    }

    public Table getTableInfo(String catalog, String schema, String tableName) {
        Table table = new Table();
        try (ResultSet resultSet = this.databaseMetaData.getTables(catalog, schema, tableName, new String[]{"TABLE", "VIEW"});){
            table.name = tableName;
            while (resultSet.next()) {
                table.remarks = this.formatComment(resultSet.getString("REMARKS"));
                table.tableType = resultSet.getString("TABLE_TYPE");
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("\u8bfb\u53d6\u8868\u4fe1\u606f:" + tableName + "\u9519\u8bef:", e);
        }
        return table;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public static class Index {
        private final String name;
        private final boolean unique;
        private final String columnName;
        private final String ascOrDesc;
        private final int cardinality;
        private final int ordinalPosition;

        public Index(ResultSet resultSet) throws SQLException {
            this.unique = !resultSet.getBoolean("NON_UNIQUE");
            this.name = resultSet.getString("INDEX_NAME");
            this.columnName = resultSet.getString("COLUMN_NAME");
            this.ascOrDesc = resultSet.getString("ASC_OR_DESC");
            this.cardinality = resultSet.getInt("CARDINALITY");
            this.ordinalPosition = resultSet.getInt("ORDINAL_POSITION");
        }

        public String getName() {
            return this.name;
        }

        public boolean isUnique() {
            return this.unique;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public String getAscOrDesc() {
            return this.ascOrDesc;
        }

        public int getCardinality() {
            return this.cardinality;
        }

        public int getOrdinalPosition() {
            return this.ordinalPosition;
        }

        public String toString() {
            return "DatabaseMetaDataWrapper.Index(name=" + this.getName() + ", unique=" + this.isUnique() + ", columnName=" + this.getColumnName() + ", ascOrDesc=" + this.getAscOrDesc() + ", cardinality=" + this.getCardinality() + ", ordinalPosition=" + this.getOrdinalPosition() + ")";
        }
    }

    public static class Column {
        private boolean primaryKey;
        private boolean autoIncrement;
        private String name;
        private int length;
        private boolean nullable;
        private String remarks;
        private String defaultValue;
        private int scale;
        private JdbcType jdbcType;
        private String typeName;
        private boolean generatedColumn;

        public boolean isPrimaryKey() {
            return this.primaryKey;
        }

        public boolean isAutoIncrement() {
            return this.autoIncrement;
        }

        public String getName() {
            return this.name;
        }

        public int getLength() {
            return this.length;
        }

        public boolean isNullable() {
            return this.nullable;
        }

        public String getRemarks() {
            return this.remarks;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public int getScale() {
            return this.scale;
        }

        public JdbcType getJdbcType() {
            return this.jdbcType;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public boolean isGeneratedColumn() {
            return this.generatedColumn;
        }

        public void setTypeName(String typeName) {
            this.typeName = typeName;
        }
    }

    public static class Table {
        private String name;
        private String remarks;
        private String tableType;

        public boolean isView() {
            return "VIEW".equals(this.tableType);
        }

        public String getName() {
            return this.name;
        }

        public String getRemarks() {
            return this.remarks;
        }

        public String getTableType() {
            return this.tableType;
        }
    }
}

