/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.generator.config.builder;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.generator.IGenerateMapperMethodHandler;
import com.baomidou.mybatisplus.generator.ITemplate;
import com.baomidou.mybatisplus.generator.config.PackageConfig;
import com.baomidou.mybatisplus.generator.config.StrategyConfig;
import com.baomidou.mybatisplus.generator.config.builder.BaseBuilder;
import com.baomidou.mybatisplus.generator.config.po.TableInfo;
import com.baomidou.mybatisplus.generator.function.ConverterFileName;
import com.baomidou.mybatisplus.generator.model.MapperMethod;
import com.baomidou.mybatisplus.generator.util.ClassUtils;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ibatis.cache.Cache;
import org.apache.ibatis.cache.decorators.LoggingCache;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Mapper
implements ITemplate {
    private static final Logger LOGGER = LoggerFactory.getLogger(Mapper.class);
    private String superClass = "com.baomidou.mybatisplus.core.mapper.BaseMapper";
    @Deprecated
    private boolean mapperAnnotation;
    private Class<? extends Annotation> mapperAnnotationClass;
    private boolean baseResultMap;
    private boolean baseColumnList;
    private ConverterFileName converterMapperFileName = entityName -> entityName + "Mapper";
    private ConverterFileName converterXmlFileName = entityName -> entityName + "Mapper";
    private boolean fileOverride;
    private Class<? extends Cache> cache;
    private boolean generateMapperXml = true;
    private boolean generateMapper = true;
    private String mapperTemplatePath = "/templates/mapper.java";
    private String mapperXmlTemplatePath = "/templates/mapper.xml";
    private IGenerateMapperMethodHandler generateMapperMethodHandler;
    private Function<Set<String>, List<String>> importPackageFunction;

    private Mapper() {
    }

    @NotNull
    public String getSuperClass() {
        return this.superClass;
    }

    @Deprecated
    public boolean isMapperAnnotation() {
        return this.mapperAnnotationClass != null;
    }

    public Class<? extends Cache> getCache() {
        return this.cache == null ? LoggingCache.class : this.cache;
    }

    @Override
    @NotNull
    public Map<String, Object> renderData(@NotNull TableInfo tableInfo) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        boolean enableCache = this.cache != null;
        data.put("enableCache", enableCache);
        data.put("mapperAnnotation", this.mapperAnnotationClass != null);
        data.put("mapperAnnotationClass", this.mapperAnnotationClass);
        data.put("baseResultMap", this.baseResultMap);
        data.put("baseColumnList", this.baseColumnList);
        data.put("superMapperClassPackage", this.superClass);
        if (enableCache) {
            Class<? extends Cache> cacheClass = this.getCache();
            data.put("cache", cacheClass);
            data.put("cacheClassName", cacheClass.getName());
        }
        data.put("superMapperClass", ClassUtils.getSimpleName(this.superClass));
        data.put("generateMapperXml", this.generateMapperXml);
        data.put("generateMapper", this.generateMapper);
        List<MapperMethod> methodList = null;
        HashSet<String> importPackages = new HashSet<String>();
        if (this.generateMapperMethodHandler != null) {
            methodList = this.generateMapperMethodHandler.getMethodList(tableInfo);
            importPackages.addAll(this.generateMapperMethodHandler.getImportPackages(tableInfo));
        }
        if (StringUtils.isNotBlank((CharSequence)this.superClass)) {
            importPackages.add(this.superClass);
        }
        if (this.mapperAnnotationClass != null) {
            importPackages.add(this.mapperAnnotationClass.getName());
        }
        PackageConfig packageConfig = tableInfo.getPackageConfig();
        String entityPackage = packageConfig.getPackageInfo(null, "Entity") + "." + tableInfo.getEntityName();
        importPackages.add(entityPackage);
        Set javaPackages = importPackages.stream().filter(pkg -> pkg.startsWith("java")).collect(Collectors.toSet());
        Set frameworkPackages = importPackages.stream().filter(pkg -> !pkg.startsWith("java")).collect(Collectors.toSet());
        data.put("importPackages", this.importPackageFunction != null ? this.importPackageFunction.apply(importPackages) : importPackages.stream().sorted().collect(Collectors.toList()));
        data.put("importMapperFrameworkPackages", this.importPackageFunction != null ? this.importPackageFunction.apply(frameworkPackages) : frameworkPackages.stream().sorted().collect(Collectors.toList()));
        data.put("importMapperJavaPackages", this.importPackageFunction != null ? this.importPackageFunction.apply(javaPackages) : javaPackages.stream().sorted().collect(Collectors.toList()));
        data.put("mapperMethodList", methodList == null ? Collections.emptyList() : methodList);
        return data;
    }

    public boolean isBaseResultMap() {
        return this.baseResultMap;
    }

    public boolean isBaseColumnList() {
        return this.baseColumnList;
    }

    public ConverterFileName getConverterMapperFileName() {
        return this.converterMapperFileName;
    }

    public ConverterFileName getConverterXmlFileName() {
        return this.converterXmlFileName;
    }

    public boolean isFileOverride() {
        return this.fileOverride;
    }

    public boolean isGenerateMapperXml() {
        return this.generateMapperXml;
    }

    public boolean isGenerateMapper() {
        return this.generateMapper;
    }

    public String getMapperTemplatePath() {
        return this.mapperTemplatePath;
    }

    public String getMapperXmlTemplatePath() {
        return this.mapperXmlTemplatePath;
    }

    public static class Builder
    extends BaseBuilder {
        private final Mapper mapper = new Mapper();

        public Builder(StrategyConfig strategyConfig) {
            super(strategyConfig);
        }

        public Builder superClass(@NotNull String superClass) {
            this.mapper.superClass = superClass;
            return this;
        }

        public Builder superClass(@NotNull Class<?> superClass) {
            return this.superClass(superClass.getName());
        }

        @Deprecated
        public Builder enableMapperAnnotation() {
            this.mapper.mapperAnnotation = true;
            this.mapper.mapperAnnotationClass = org.apache.ibatis.annotations.Mapper.class;
            return this;
        }

        public Builder mapperAnnotation(Class<? extends Annotation> annotationClass) {
            this.mapper.mapperAnnotationClass = annotationClass;
            return this;
        }

        public Builder enableBaseResultMap() {
            this.mapper.baseResultMap = true;
            return this;
        }

        public Builder enableBaseColumnList() {
            this.mapper.baseColumnList = true;
            return this;
        }

        public Builder cache(@NotNull Class<? extends Cache> cache) {
            this.mapper.cache = cache;
            return this;
        }

        public Builder convertMapperFileName(@NotNull ConverterFileName converter) {
            this.mapper.converterMapperFileName = converter;
            return this;
        }

        public Builder convertXmlFileName(@NotNull ConverterFileName converter) {
            this.mapper.converterXmlFileName = converter;
            return this;
        }

        public Builder formatMapperFileName(@NotNull String format) {
            return this.convertMapperFileName(entityName -> String.format(format, entityName));
        }

        public Builder formatXmlFileName(@NotNull String format) {
            return this.convertXmlFileName(entityName -> String.format(format, entityName));
        }

        @Deprecated
        public Builder fileOverride() {
            LOGGER.warn("fileOverride\u65b9\u6cd5\u540e\u7eed\u4f1a\u5220\u9664\uff0c\u66ff\u4ee3\u65b9\u6cd5\u4e3aenableFileOverride\u65b9\u6cd5");
            this.mapper.fileOverride = true;
            return this;
        }

        public Builder enableFileOverride() {
            this.mapper.fileOverride = true;
            return this;
        }

        public Builder mapperTemplate(@NotNull String template) {
            this.mapper.mapperTemplatePath = template;
            return this;
        }

        public Builder mapperXmlTemplate(@NotNull String template) {
            this.mapper.mapperXmlTemplatePath = template;
            return this;
        }

        public Builder disable() {
            this.mapper.generateMapper = false;
            this.mapper.generateMapperXml = false;
            return this;
        }

        public Builder disableMapper() {
            this.mapper.generateMapper = false;
            return this;
        }

        public Builder disableMapperXml() {
            this.mapper.generateMapperXml = false;
            return this;
        }

        public Builder generateMapperMethodHandler(IGenerateMapperMethodHandler generateMapperMethodHandler) {
            this.mapper.generateMapperMethodHandler = generateMapperMethodHandler;
            return this;
        }

        public Builder importPackageFunction(Function<Set<String>, List<String>> importPackageFunction) {
            this.mapper.importPackageFunction = importPackageFunction;
            return this;
        }

        @NotNull
        public Mapper get() {
            return this.mapper;
        }
    }
}

