/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.generator.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.ibatis.type.JdbcType;

public class DatabaseMetaDataWrapper {
    private final DatabaseMetaData databaseMetaData;

    public DatabaseMetaDataWrapper(Connection connection) throws SQLException {
        this.databaseMetaData = connection.getMetaData();
    }

    public Map<String, ColumnsInfo> getColumnsInfo(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        ResultSet resultSet = this.databaseMetaData.getColumns(catalog, schemaPattern, tableNamePattern, "%");
        HashMap<String, ColumnsInfo> columnsInfoMap = new HashMap<String, ColumnsInfo>();
        while (resultSet.next()) {
            ColumnsInfo columnsInfo = new ColumnsInfo();
            String name = resultSet.getString("COLUMN_NAME");
            columnsInfo.name = name;
            columnsInfo.jdbcType = JdbcType.forCode((int)resultSet.getInt("DATA_TYPE"));
            columnsInfo.length = resultSet.getInt("COLUMN_SIZE");
            columnsInfo.scale = resultSet.getInt("DECIMAL_DIGITS");
            columnsInfo.remarks = resultSet.getString("REMARKS");
            columnsInfo.defaultValue = resultSet.getString("COLUMN_DEF");
            columnsInfo.nullable = resultSet.getInt("NULLABLE") == 1;
            columnsInfoMap.put(name.toLowerCase(), columnsInfo);
        }
        return Collections.unmodifiableMap(columnsInfoMap);
    }

    public static class ColumnsInfo {
        private String name;
        private int length;
        private boolean nullable;
        private String remarks;
        private String defaultValue;
        private int scale;
        private JdbcType jdbcType;

        public String getName() {
            return this.name;
        }

        public int getLength() {
            return this.length;
        }

        public boolean isNullable() {
            return this.nullable;
        }

        public String getRemarks() {
            return this.remarks;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public int getScale() {
            return this.scale;
        }

        public JdbcType getJdbcType() {
            return this.jdbcType;
        }
    }
}

