/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.generator.config.builder;

import com.baomidou.mybatisplus.generator.ITemplate;
import com.baomidou.mybatisplus.generator.config.StrategyConfig;
import com.baomidou.mybatisplus.generator.config.builder.BaseBuilder;
import com.baomidou.mybatisplus.generator.config.po.TableInfo;
import com.baomidou.mybatisplus.generator.function.ConverterFileName;
import com.baomidou.mybatisplus.generator.util.ClassUtils;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import org.apache.ibatis.cache.Cache;
import org.apache.ibatis.cache.decorators.LoggingCache;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Mapper
implements ITemplate {
    private static final Logger LOGGER = LoggerFactory.getLogger(Mapper.class);
    private String superClass = "com.baomidou.mybatisplus.core.mapper.BaseMapper";
    @Deprecated
    private boolean mapperAnnotation;
    private Class<? extends Annotation> mapperAnnotationClass;
    private boolean baseResultMap;
    private boolean baseColumnList;
    private ConverterFileName converterMapperFileName = entityName -> entityName + "Mapper";
    private ConverterFileName converterXmlFileName = entityName -> entityName + "Mapper";
    private boolean fileOverride;
    private Class<? extends Cache> cache;

    private Mapper() {
    }

    @NotNull
    public String getSuperClass() {
        return this.superClass;
    }

    @Deprecated
    public boolean isMapperAnnotation() {
        return this.mapperAnnotationClass != null;
    }

    public boolean isBaseResultMap() {
        return this.baseResultMap;
    }

    public boolean isBaseColumnList() {
        return this.baseColumnList;
    }

    public ConverterFileName getConverterMapperFileName() {
        return this.converterMapperFileName;
    }

    public ConverterFileName getConverterXmlFileName() {
        return this.converterXmlFileName;
    }

    public Class<? extends Cache> getCache() {
        return this.cache == null ? LoggingCache.class : this.cache;
    }

    public boolean isFileOverride() {
        return this.fileOverride;
    }

    @Override
    @NotNull
    public Map<String, Object> renderData(@NotNull TableInfo tableInfo) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        boolean enableCache = this.cache != null;
        data.put("enableCache", enableCache);
        data.put("mapperAnnotation", this.mapperAnnotationClass != null);
        data.put("mapperAnnotationClass", this.mapperAnnotationClass);
        data.put("baseResultMap", this.baseResultMap);
        data.put("baseColumnList", this.baseColumnList);
        data.put("superMapperClassPackage", this.superClass);
        if (enableCache) {
            Class<? extends Cache> cacheClass = this.getCache();
            data.put("cache", cacheClass);
            data.put("cacheClassName", cacheClass.getName());
        }
        data.put("superMapperClass", ClassUtils.getSimpleName(this.superClass));
        return data;
    }

    public static class Builder
    extends BaseBuilder {
        private final Mapper mapper = new Mapper();

        public Builder(StrategyConfig strategyConfig) {
            super(strategyConfig);
        }

        public Builder superClass(@NotNull String superClass) {
            this.mapper.superClass = superClass;
            return this;
        }

        public Builder superClass(@NotNull Class<?> superClass) {
            return this.superClass(superClass.getName());
        }

        @Deprecated
        public Builder enableMapperAnnotation() {
            this.mapper.mapperAnnotation = true;
            this.mapper.mapperAnnotationClass = org.apache.ibatis.annotations.Mapper.class;
            return this;
        }

        public Builder mapperAnnotation(Class<? extends Annotation> annotationClass) {
            this.mapper.mapperAnnotationClass = annotationClass;
            return this;
        }

        public Builder enableBaseResultMap() {
            this.mapper.baseResultMap = true;
            return this;
        }

        public Builder enableBaseColumnList() {
            this.mapper.baseColumnList = true;
            return this;
        }

        public Builder cache(@NotNull Class<? extends Cache> cache) {
            this.mapper.cache = cache;
            return this;
        }

        public Builder convertMapperFileName(@NotNull ConverterFileName converter) {
            this.mapper.converterMapperFileName = converter;
            return this;
        }

        public Builder convertXmlFileName(@NotNull ConverterFileName converter) {
            this.mapper.converterXmlFileName = converter;
            return this;
        }

        public Builder formatMapperFileName(@NotNull String format) {
            return this.convertMapperFileName(entityName -> String.format(format, entityName));
        }

        public Builder formatXmlFileName(@NotNull String format) {
            return this.convertXmlFileName(entityName -> String.format(format, entityName));
        }

        @Deprecated
        public Builder fileOverride() {
            LOGGER.warn("fileOverride\u65b9\u6cd5\u540e\u7eed\u4f1a\u5220\u9664\uff0c\u66ff\u4ee3\u65b9\u6cd5\u4e3aenableFileOverride\u65b9\u6cd5");
            this.mapper.fileOverride = true;
            return this;
        }

        public Builder enableFileOverride() {
            this.mapper.fileOverride = true;
            return this;
        }

        @NotNull
        public Mapper get() {
            return this.mapper;
        }
    }
}

