/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.extension.spi;

import com.baomidou.mybatisplus.core.toolkit.ExceptionUtils;
import com.baomidou.mybatisplus.extension.spi.CompatibleSet;
import java.io.InputStream;
import java.util.function.Consumer;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.reflection.ExceptionUtil;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.noear.solon.Solon;
import org.noear.solon.core.util.ResourceUtil;
import org.noear.solon.data.tran.TranUtils;

public class SolonCompatibleSet
implements CompatibleSet {
    public SqlSession getSqlSession(SqlSessionFactory sessionFactory) {
        return sessionFactory.openSession();
    }

    public void closeSqlSession(SqlSession sqlSession, SqlSessionFactory sqlSessionFactory) {
        if (sqlSession != null) {
            sqlSession.close();
        }
    }

    public boolean executeBatch(SqlSessionFactory sqlSessionFactory, Log log, Consumer<SqlSession> consumer) {
        boolean transaction = TranUtils.inTrans();
        SqlSession sqlSession = sqlSessionFactory.openSession(ExecutorType.BATCH);
        if (!transaction) {
            log.warn("SqlSession [" + sqlSession + "] Transaction not enabled");
        }
        try {
            consumer.accept(sqlSession);
            sqlSession.commit(!transaction);
            boolean bl = true;
            return bl;
        }
        catch (RuntimeException t) {
            throw t;
        }
        catch (Throwable t) {
            sqlSession.rollback();
            Throwable unwrapped = ExceptionUtil.unwrapThrowable((Throwable)t);
            if (unwrapped instanceof RuntimeException) {
                throw (RuntimeException)unwrapped;
            }
            throw ExceptionUtils.mpe((Throwable)unwrapped);
        }
        finally {
            sqlSession.close();
        }
    }

    public InputStream getInputStream(String path) throws Exception {
        return ResourceUtil.findResource((String)path).openStream();
    }

    public <T> T getBean(Class<T> clz) {
        return (T)Solon.context().getBean(clz);
    }

    public Object getProxyTargetObject(Object mapper) {
        return mapper;
    }
}

