/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.solon.integration;

import com.baomidou.mybatisplus.core.MybatisConfiguration;
import com.baomidou.mybatisplus.core.MybatisSqlSessionFactoryBuilder;
import com.baomidou.mybatisplus.core.config.GlobalConfig;
import com.baomidou.mybatisplus.core.override.SolonMybatisMapperProxy;
import com.baomidou.mybatisplus.core.toolkit.GlobalConfigUtils;
import com.baomidou.mybatisplus.solon.integration.SolonSqlSession;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.solon.integration.MybatisAdapterDefault;
import org.noear.solon.Utils;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.Props;
import org.noear.solon.core.VarHolder;

public class MybatisAdapterPlus
extends MybatisAdapterDefault {
    MybatisSqlSessionFactoryBuilder factoryBuilderPlus;
    GlobalConfig globalConfig;
    SqlSession sqlSession;
    Map<Class<?>, Object> mapperCached = new HashMap();

    protected MybatisAdapterPlus(BeanWrap dsWrap) {
        super(dsWrap);
        this.factoryBuilderPlus = new MybatisSqlSessionFactoryBuilder();
        dsWrap.context().getBeanAsync(MybatisSqlSessionFactoryBuilder.class, bean -> {
            this.factoryBuilderPlus = bean;
        });
    }

    protected MybatisAdapterPlus(BeanWrap dsWrap, Props dsProps) {
        super(dsWrap, dsProps);
        this.factoryBuilderPlus = new MybatisSqlSessionFactoryBuilder();
        dsWrap.context().getBeanAsync(MybatisSqlSessionFactoryBuilder.class, bean -> {
            this.factoryBuilderPlus = bean;
        });
    }

    protected void initConfiguration(Environment environment) {
        this.config = new MybatisConfiguration(environment);
        Props cfgProps = this.dsProps.getProp("configuration");
        if (cfgProps.size() > 0) {
            Utils.injectProperties((Object)this.config, (Properties)cfgProps);
        }
        this.globalConfig = new GlobalConfig().setDbConfig(new GlobalConfig.DbConfig());
        Props globalProps = this.dsProps.getProp("globalConfig");
        if (globalProps.size() > 0) {
            Utils.injectProperties((Object)this.globalConfig, (Properties)globalProps);
        }
        GlobalConfigUtils.setGlobalConfig((Configuration)this.config, (GlobalConfig)this.globalConfig);
    }

    public SqlSessionFactory getFactory() {
        if (this.factory == null) {
            this.factory = this.factoryBuilderPlus.build(this.getConfiguration());
        }
        return this.factory;
    }

    public SqlSession getSession() {
        if (this.sqlSession == null) {
            this.sqlSession = new SolonSqlSession(this.getFactory());
        }
        return this.sqlSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getMapper(Class<T> mapperClz) {
        Object mapper = this.mapperCached.get(mapperClz);
        if (mapper == null) {
            Class<T> clazz = mapperClz;
            synchronized (clazz) {
                mapper = this.mapperCached.get(mapperClz);
                if (mapper == null) {
                    SolonMybatisMapperProxy<T> tMybatisMapperProxy = new SolonMybatisMapperProxy<T>(this.getFactory(), this.getSession(), mapperClz);
                    mapper = Proxy.newProxyInstance(mapperClz.getClassLoader(), new Class[]{mapperClz}, tMybatisMapperProxy);
                    this.mapperCached.put(mapperClz, mapper);
                }
            }
        }
        return (T)mapper;
    }

    public GlobalConfig getGlobalConfig() {
        return this.globalConfig;
    }

    public void injectTo(VarHolder varH) {
        super.injectTo(varH);
        if (GlobalConfig.class.isAssignableFrom(varH.getType())) {
            varH.setValue((Object)this.getGlobalConfig());
            return;
        }
    }
}

