/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.plugins.pagination;

import com.baomidou.mybatisplus.exceptions.MybatisPlusException;
import com.baomidou.mybatisplus.plugins.pagination.Pagination;

public class PageHelper {
    private static final ThreadLocal<Pagination> LOCAL_PAGE = new ThreadLocal();

    public static int getTotal() {
        if (PageHelper.isPageable()) {
            return LOCAL_PAGE.get().getTotal();
        }
        throw new MybatisPlusException("The current thread does not start paging. Please call before PageHelper.startPage");
    }

    public static int offsetCurrent(int current, int size) {
        if (current > 0) {
            return (current - 1) * size;
        }
        return 0;
    }

    public static int offsetCurrent(Pagination pagination) {
        if (null == pagination) {
            return 0;
        }
        return PageHelper.offsetCurrent(pagination.getCurrent(), pagination.getSize());
    }

    public static int freeTotal() {
        int total = PageHelper.getTotal();
        PageHelper.remove();
        return total;
    }

    public static Pagination getPagination() {
        return LOCAL_PAGE.get();
    }

    public static void setPagination(Pagination page) {
        LOCAL_PAGE.set(page);
    }

    public static void startPage(int current, int size) {
        LOCAL_PAGE.set(new Pagination(current, size));
    }

    public static boolean isPageable() {
        return LOCAL_PAGE.get() != null;
    }

    public static void remove() {
        LOCAL_PAGE.remove();
    }
}

