/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.activerecord;

import com.baomidou.mybatisplus.enums.SqlMethod;
import com.baomidou.mybatisplus.exceptions.MybatisPlusException;
import com.baomidou.mybatisplus.mapper.Condition;
import com.baomidou.mybatisplus.mapper.SqlHelper;
import com.baomidou.mybatisplus.mapper.SqlRunner;
import com.baomidou.mybatisplus.mapper.Wrapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.toolkit.GlobalConfigUtils;
import com.baomidou.mybatisplus.toolkit.StringUtils;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionUtils;
import org.springframework.transaction.annotation.Transactional;

public abstract class Model<T extends Model>
implements Serializable {
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public boolean insert() {
        SqlSession sqlSession = this.sqlSession();
        try {
            boolean bl = SqlHelper.retBool(sqlSession.insert(this.sqlStatement(SqlMethod.INSERT_ONE), (Object)this));
            return bl;
        }
        finally {
            this.closeSqlSession(sqlSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public boolean insertAllColumn() {
        SqlSession sqlSession = this.sqlSession();
        try {
            boolean bl = SqlHelper.retBool(sqlSession.insert(this.sqlStatement(SqlMethod.INSERT_ONE_ALL_COLUMN), (Object)this));
            return bl;
        }
        finally {
            this.closeSqlSession(sqlSession);
        }
    }

    @Transactional
    public boolean insertOrUpdate() {
        if (StringUtils.checkValNull(this.pkVal())) {
            return this.insert();
        }
        return this.updateById() || this.insert();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public boolean deleteById(Serializable id) {
        SqlSession sqlSession = this.sqlSession();
        try {
            boolean bl = SqlHelper.delBool(sqlSession.delete(this.sqlStatement(SqlMethod.DELETE_BY_ID), (Object)id));
            return bl;
        }
        finally {
            this.closeSqlSession(sqlSession);
        }
    }

    @Transactional
    public boolean deleteById() {
        if (StringUtils.checkValNull(this.pkVal())) {
            throw new MybatisPlusException("deleteById primaryKey is null.");
        }
        return this.deleteById(this.pkVal());
    }

    @Transactional
    public boolean delete(String whereClause, Object ... args) {
        return this.delete(Condition.create().where(whereClause, args));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public boolean delete(Wrapper wrapper) {
        HashMap<String, Wrapper> map = new HashMap<String, Wrapper>();
        map.put("ew", wrapper);
        SqlSession sqlSession = this.sqlSession();
        try {
            boolean bl = SqlHelper.delBool(sqlSession.delete(this.sqlStatement(SqlMethod.DELETE), map));
            return bl;
        }
        finally {
            this.closeSqlSession(sqlSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public boolean updateById() {
        if (StringUtils.checkValNull(this.pkVal())) {
            throw new MybatisPlusException("updateById primaryKey is null.");
        }
        HashMap<String, Model> map = new HashMap<String, Model>();
        map.put("et", this);
        SqlSession sqlSession = this.sqlSession();
        try {
            boolean bl = SqlHelper.retBool(sqlSession.update(this.sqlStatement(SqlMethod.UPDATE_BY_ID), map));
            return bl;
        }
        finally {
            this.closeSqlSession(sqlSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public boolean updateAllColumnById() {
        if (StringUtils.checkValNull(this.pkVal())) {
            throw new MybatisPlusException("updateAllColumnById primaryKey is null.");
        }
        HashMap<String, Model> map = new HashMap<String, Model>();
        map.put("et", this);
        SqlSession sqlSession = this.sqlSession();
        try {
            boolean bl = SqlHelper.retBool(sqlSession.update(this.sqlStatement(SqlMethod.UPDATE_ALL_COLUMN_BY_ID), map));
            return bl;
        }
        finally {
            this.closeSqlSession(sqlSession);
        }
    }

    @Transactional
    public boolean update(String whereClause, Object ... args) {
        return this.update(Condition.create().where(whereClause, args));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public boolean update(Wrapper wrapper) {
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put("et", this);
        map.put("ew", wrapper);
        SqlSession sqlSession = this.sqlSession();
        try {
            boolean bl = SqlHelper.retBool(sqlSession.update(this.sqlStatement(SqlMethod.UPDATE), map));
            return bl;
        }
        finally {
            this.closeSqlSession(sqlSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> selectAll() {
        SqlSession sqlSession = this.sqlSession();
        try {
            List list = sqlSession.selectList(this.sqlStatement(SqlMethod.SELECT_LIST));
            return list;
        }
        finally {
            this.closeSqlSession(sqlSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T selectById(Serializable id) {
        SqlSession sqlSession = this.sqlSession();
        try {
            Model model = (Model)sqlSession.selectOne(this.sqlStatement(SqlMethod.SELECT_BY_ID), (Object)id);
            return (T)model;
        }
        finally {
            this.closeSqlSession(sqlSession);
        }
    }

    public T selectById() {
        if (StringUtils.checkValNull(this.pkVal())) {
            throw new MybatisPlusException("selectById primaryKey is null.");
        }
        return this.selectById(this.pkVal());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> selectList(Wrapper wrapper) {
        HashMap<String, Wrapper> map = new HashMap<String, Wrapper>();
        map.put("ew", wrapper);
        SqlSession sqlSession = this.sqlSession();
        try {
            List list = sqlSession.selectList(this.sqlStatement(SqlMethod.SELECT_LIST), map);
            return list;
        }
        finally {
            this.closeSqlSession(sqlSession);
        }
    }

    public List<T> selectList(String whereClause, Object ... args) {
        return this.selectList(Condition.create().where(whereClause, args));
    }

    public T selectOne(Wrapper wrapper) {
        return (T)((Model)SqlHelper.getObject(this.selectList(wrapper)));
    }

    public T selectOne(String whereClause, Object ... args) {
        return this.selectOne(Condition.create().where(whereClause, args));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Page<T> selectPage(Page<T> page, Wrapper<T> wrapper) {
        HashMap<String, Wrapper<T>> map = new HashMap<String, Wrapper<T>>();
        wrapper = SqlHelper.fillWrapper(page, wrapper);
        map.put("ew", wrapper);
        SqlSession sqlSession = this.sqlSession();
        try {
            List tl = sqlSession.selectList(this.sqlStatement(SqlMethod.SELECT_PAGE), map, page);
            page.setRecords(tl);
            Page<T> page2 = page;
            return page2;
        }
        finally {
            this.closeSqlSession(sqlSession);
        }
    }

    public Page<T> selectPage(Page<T> page, String whereClause, Object ... args) {
        return this.selectPage(page, Condition.create().where(whereClause, args));
    }

    public int selectCount(String whereClause, Object ... args) {
        return this.selectCount(Condition.create().where(whereClause, args));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int selectCount(Wrapper wrapper) {
        HashMap<String, Wrapper> map = new HashMap<String, Wrapper>();
        map.put("ew", wrapper);
        SqlSession sqlSession = this.sqlSession();
        try {
            int n = SqlHelper.retCount((Integer)sqlSession.selectOne(this.sqlStatement(SqlMethod.SELECT_COUNT), map));
            return n;
        }
        finally {
            this.closeSqlSession(sqlSession);
        }
    }

    public SqlRunner sql() {
        return new SqlRunner(this.getClass());
    }

    protected SqlSession sqlSession() {
        return SqlHelper.sqlSession(this.getClass());
    }

    protected String sqlStatement(SqlMethod sqlMethod) {
        return this.sqlStatement(sqlMethod.getMethod());
    }

    protected String sqlStatement(String sqlMethod) {
        return SqlHelper.table(this.getClass()).getSqlStatement(sqlMethod);
    }

    protected abstract Serializable pkVal();

    protected void closeSqlSession(SqlSession sqlSession) {
        SqlSessionUtils.closeSqlSession((SqlSession)sqlSession, (SqlSessionFactory)GlobalConfigUtils.currentSessionFactory(this.getClass()));
    }
}

