/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.mapper;

import com.baomidou.mybatisplus.MybatisConfiguration;
import com.baomidou.mybatisplus.annotations.FieldStrategy;
import com.baomidou.mybatisplus.annotations.IdType;
import com.baomidou.mybatisplus.mapper.BaseMapper;
import com.baomidou.mybatisplus.mapper.DBType;
import com.baomidou.mybatisplus.mapper.ISqlInjector;
import com.baomidou.mybatisplus.mapper.SqlMethod;
import com.baomidou.mybatisplus.toolkit.TableFieldInfo;
import com.baomidou.mybatisplus.toolkit.TableInfo;
import com.baomidou.mybatisplus.toolkit.TableInfoHelper;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.ibatis.builder.MapperBuilderAssistant;
import org.apache.ibatis.executor.keygen.Jdbc3KeyGenerator;
import org.apache.ibatis.executor.keygen.KeyGenerator;
import org.apache.ibatis.executor.keygen.NoKeyGenerator;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.mapping.StatementType;
import org.apache.ibatis.scripting.LanguageDriver;
import org.apache.ibatis.scripting.defaults.RawSqlSource;
import org.apache.ibatis.session.Configuration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoSqlInjector
implements ISqlInjector {
    protected static final Logger logger = Logger.getLogger("AutoSqlInjector");
    protected Configuration configuration;
    protected LanguageDriver languageDriver;
    protected MapperBuilderAssistant builderAssistant;
    protected DBType dbType = DBType.MYSQL;

    @Override
    public void inspectInject(Configuration configuration, MapperBuilderAssistant builderAssistant, Class<?> mapperClass) {
        Set<String> mapperRegistryCache = MybatisConfiguration.MAPPER_REGISTRY_CACHE;
        String className = mapperClass.toString();
        if (!mapperRegistryCache.contains(className)) {
            this.inject(configuration, builderAssistant, mapperClass);
            mapperRegistryCache.add(className);
        }
    }

    @Override
    public void inject(Configuration configuration, MapperBuilderAssistant builderAssistant, Class<?> mapperClass) {
        Class<?> modelClass;
        TableInfo table;
        this.configuration = configuration;
        this.builderAssistant = builderAssistant;
        this.languageDriver = configuration.getDefaultScriptingLanuageInstance();
        this.dbType = MybatisConfiguration.DB_TYPE;
        if (!MybatisConfiguration.DB_COLUMN_UNDERLINE) {
            MybatisConfiguration.DB_COLUMN_UNDERLINE = configuration.isMapUnderscoreToCamelCase();
        }
        if (null != (table = TableInfoHelper.initTableInfo(modelClass = this.extractModelClass(mapperClass))) && null != table.getKeyProperty()) {
            this.injectInsertOneSql(false, mapperClass, modelClass, table);
            this.injectInsertOneSql(true, mapperClass, modelClass, table);
            this.injectInsertBatchSql(mapperClass, modelClass, table);
            this.injectDeleteSelectiveSql(mapperClass, modelClass, table);
            this.injectDeleteByMapSql(mapperClass, table);
            this.injectDeleteSql(false, mapperClass, modelClass, table);
            this.injectDeleteSql(true, mapperClass, modelClass, table);
            this.injectUpdateByIdSql(false, mapperClass, modelClass, table);
            this.injectUpdateByIdSql(true, mapperClass, modelClass, table);
            this.injectUpdateSql(false, mapperClass, modelClass, table);
            this.injectUpdateSql(true, mapperClass, modelClass, table);
            this.injectUpdateBatchById(mapperClass, modelClass, table);
            this.injectSelectSql(false, mapperClass, modelClass, table);
            this.injectSelectSql(true, mapperClass, modelClass, table);
            this.injectSelectByMapSql(mapperClass, modelClass, table);
            this.injectSelectOneSql(mapperClass, modelClass, table);
            this.injectSelectCountSql(mapperClass, modelClass, table);
            this.injectSelectCountByEWSql(SqlMethod.SELECT_COUNT_EW, mapperClass, modelClass, table);
            this.injectSelectListSql(SqlMethod.SELECT_LIST, mapperClass, modelClass, table);
            this.injectSelectListSql(SqlMethod.SELECT_PAGE, mapperClass, modelClass, table);
            this.inject(configuration, builderAssistant, mapperClass, modelClass, table);
        } else {
            logger.warning(String.format("%s ,Not found @TableId annotation, cannot use mybatis-plus curd method.", modelClass.toString()));
        }
    }

    public void inject(Configuration configuration, MapperBuilderAssistant builderAssistant, Class<?> mapperClass, Class<?> modelClass, TableInfo table) {
    }

    protected Class<?> extractModelClass(Class<?> mapperClass) {
        Type[] types = mapperClass.getGenericInterfaces();
        ParameterizedType target = null;
        for (Type type : types) {
            if (!(type instanceof ParameterizedType) || !BaseMapper.class.isAssignableFrom(mapperClass)) continue;
            target = (ParameterizedType)type;
            break;
        }
        Type[] parameters = target.getActualTypeArguments();
        Class modelClass = (Class)parameters[0];
        return modelClass;
    }

    protected void injectInsertOneSql(boolean selective, Class<?> mapperClass, Class<?> modelClass, TableInfo table) {
        NoKeyGenerator keyGenerator = new NoKeyGenerator();
        StringBuilder fieldBuilder = new StringBuilder();
        StringBuilder placeholderBuilder = new StringBuilder();
        SqlMethod sqlMethod = SqlMethod.INSERT_ONE;
        if (selective) {
            sqlMethod = SqlMethod.INSERT_ONE_SELECTIVE;
        }
        fieldBuilder.append("\n<trim prefix=\"(\" suffix=\")\" suffixOverrides=\",\">\n");
        placeholderBuilder.append("\n<trim prefix=\"(\" suffix=\")\" suffixOverrides=\",\">\n");
        String keyProperty = null;
        String keyColumn = null;
        if (table.getIdType() == IdType.AUTO) {
            keyGenerator = new Jdbc3KeyGenerator();
            keyProperty = table.getKeyProperty();
            keyColumn = table.getKeyColumn();
        } else {
            fieldBuilder.append(table.getKeyColumn()).append(",");
            placeholderBuilder.append("#{").append(table.getKeyProperty()).append("},");
        }
        List<TableFieldInfo> fieldList = table.getFieldList();
        for (TableFieldInfo fieldInfo : fieldList) {
            if (selective) {
                fieldBuilder.append(this.convertIfTagInsert(fieldInfo, false));
                placeholderBuilder.append(this.convertIfTagInsert(fieldInfo, false));
            }
            fieldBuilder.append(fieldInfo.getColumn()).append(",");
            placeholderBuilder.append("#{").append(fieldInfo.getEl()).append("},");
            if (!selective) continue;
            fieldBuilder.append(this.convertIfTagInsert(fieldInfo, true));
            placeholderBuilder.append(this.convertIfTagInsert(fieldInfo, true));
        }
        fieldBuilder.append("\n</trim>");
        placeholderBuilder.append("\n</trim>");
        String sql = String.format(sqlMethod.getSql(), table.getTableName(), fieldBuilder.toString(), placeholderBuilder.toString());
        SqlSource sqlSource = this.languageDriver.createSqlSource(this.configuration, sql, modelClass);
        this.addInsertMappedStatement(mapperClass, modelClass, sqlMethod.getMethod(), sqlSource, (KeyGenerator)keyGenerator, keyProperty, keyColumn);
    }

    protected void injectInsertBatchSql(Class<?> mapperClass, Class<?> modelClass, TableInfo table) {
        NoKeyGenerator keyGenerator = new NoKeyGenerator();
        StringBuilder fieldBuilder = new StringBuilder();
        StringBuilder placeholderBuilder = new StringBuilder();
        SqlMethod sqlMethod = SqlMethod.INSERT_BATCH_MYSQL;
        if (DBType.ORACLE == this.dbType) {
            sqlMethod = SqlMethod.INSERT_BATCH_ORACLE;
            placeholderBuilder.append("\n<trim prefix=\"(SELECT \" suffix=\" FROM DUAL)\" suffixOverrides=\",\">\n");
        } else {
            placeholderBuilder.append("\n<trim prefix=\"(\" suffix=\")\" suffixOverrides=\",\">\n");
        }
        fieldBuilder.append("\n<trim prefix=\"(\" suffix=\")\" suffixOverrides=\",\">\n");
        String keyProperty = null;
        String keyColumn = null;
        if (table.getIdType() == IdType.AUTO) {
            keyGenerator = new Jdbc3KeyGenerator();
            keyProperty = table.getKeyProperty();
            keyColumn = table.getKeyColumn();
        } else {
            fieldBuilder.append(table.getKeyColumn()).append(",");
            placeholderBuilder.append("#{item.").append(table.getKeyProperty()).append("},");
        }
        List<TableFieldInfo> fieldList = table.getFieldList();
        for (TableFieldInfo fieldInfo : fieldList) {
            fieldBuilder.append(fieldInfo.getColumn()).append(",");
            placeholderBuilder.append("#{item.").append(fieldInfo.getEl()).append("},");
        }
        fieldBuilder.append("\n</trim>");
        placeholderBuilder.append("\n</trim>");
        String sql = String.format(sqlMethod.getSql(), table.getTableName(), fieldBuilder.toString(), placeholderBuilder.toString());
        SqlSource sqlSource = this.languageDriver.createSqlSource(this.configuration, sql, modelClass);
        this.addInsertMappedStatement(mapperClass, modelClass, sqlMethod.getMethod(), sqlSource, (KeyGenerator)keyGenerator, keyProperty, keyColumn);
    }

    protected void injectDeleteSelectiveSql(Class<?> mapperClass, Class<?> modelClass, TableInfo table) {
        SqlMethod sqlMethod = SqlMethod.DELETE_SELECTIVE;
        String sql = String.format(sqlMethod.getSql(), table.getTableName(), this.sqlWhere(table, false));
        SqlSource sqlSource = this.languageDriver.createSqlSource(this.configuration, sql, modelClass);
        this.addDeleteMappedStatement(mapperClass, sqlMethod.getMethod(), sqlSource);
    }

    protected void injectDeleteByMapSql(Class<?> mapperClass, TableInfo table) {
        SqlMethod sqlMethod = SqlMethod.DELETE_BY_MAP;
        String sql = String.format(sqlMethod.getSql(), table.getTableName(), this.sqlWhereByMap());
        SqlSource sqlSource = this.languageDriver.createSqlSource(this.configuration, sql, Map.class);
        this.addDeleteMappedStatement(mapperClass, sqlMethod.getMethod(), sqlSource);
    }

    protected void injectDeleteSql(boolean batch, Class<?> mapperClass, Class<?> modelClass, TableInfo table) {
        SqlMethod sqlMethod = SqlMethod.DELETE_BY_ID;
        RawSqlSource sqlSource = null;
        if (batch) {
            sqlMethod = SqlMethod.DELETE_BATCH;
            StringBuilder ids = new StringBuilder();
            ids.append("\n<foreach item=\"item\" index=\"index\" collection=\"list\" separator=\",\">");
            ids.append("#{item}");
            ids.append("\n</foreach>");
            String sql = String.format(sqlMethod.getSql(), table.getTableName(), table.getKeyColumn(), ids.toString());
            sqlSource = this.languageDriver.createSqlSource(this.configuration, sql, modelClass);
        } else {
            String sql = String.format(sqlMethod.getSql(), table.getTableName(), table.getKeyColumn(), table.getKeyColumn());
            sqlSource = new RawSqlSource(this.configuration, sql, Object.class);
        }
        this.addDeleteMappedStatement(mapperClass, sqlMethod.getMethod(), (SqlSource)sqlSource);
    }

    protected void injectUpdateByIdSql(boolean selective, Class<?> mapperClass, Class<?> modelClass, TableInfo table) {
        SqlMethod sqlMethod = SqlMethod.UPDATE_BY_ID;
        if (selective) {
            sqlMethod = SqlMethod.UPDATE_SELECTIVE_BY_ID;
        }
        String sql = String.format(sqlMethod.getSql(), table.getTableName(), this.sqlSet(selective, table), table.getKeyColumn(), table.getKeyProperty());
        SqlSource sqlSource = this.languageDriver.createSqlSource(this.configuration, sql, modelClass);
        this.addUpdateMappedStatement(mapperClass, modelClass, sqlMethod.getMethod(), sqlSource);
    }

    protected void injectUpdateBatchById(Class<?> mapperClass, Class<?> modelClass, TableInfo table) {
        List<TableFieldInfo> fieldList;
        StringBuilder set = new StringBuilder();
        set.append("<trim prefix=\"SET\" suffixOverrides=\",\">\n");
        SqlMethod sqlMethod = SqlMethod.UPDATE_BATCH_BY_ID_MYSQL;
        if (DBType.ORACLE == this.dbType) {
            sqlMethod = SqlMethod.UPDATE_BATCH_BY_ID_ORACLE;
            fieldList = table.getFieldList();
            for (TableFieldInfo fieldInfo : fieldList) {
                set.append(fieldInfo.getColumn()).append("=#{item.").append(fieldInfo.getEl()).append("},");
            }
        } else if (DBType.MYSQL == this.dbType) {
            fieldList = table.getFieldList();
            for (TableFieldInfo fieldInfo : fieldList) {
                set.append("\n<trim prefix=\"").append(fieldInfo.getColumn()).append("=CASE ");
                set.append(table.getKeyColumn()).append("\" suffix=\"END,\">");
                set.append("\n<foreach collection=\"list\" item=\"i\" index=\"index\">");
                set.append(this.convertIfTag(fieldInfo, "i.", false));
                set.append("\nWHEN ").append("#{i.").append(table.getKeyProperty());
                set.append("} THEN #{i.").append(fieldInfo.getEl()).append("}");
                set.append(this.convertIfTag(fieldInfo, true));
                set.append("\n</foreach>");
                set.append("\n</trim>");
            }
        }
        set.append("\n</trim>");
        String sql = String.format(sqlMethod.getSql(), table.getTableName(), set.toString(), table.getKeyColumn(), table.getKeyProperty());
        SqlSource sqlSource = this.languageDriver.createSqlSource(this.configuration, sql, modelClass);
        this.addUpdateMappedStatement(mapperClass, modelClass, sqlMethod.getMethod(), sqlSource);
    }

    protected void injectUpdateSql(boolean selective, Class<?> mapperClass, Class<?> modelClass, TableInfo table) {
        SqlMethod sqlMethod = SqlMethod.UPDATE;
        if (selective) {
            sqlMethod = SqlMethod.UPDATE_SELECTIVE;
        }
        String sql = String.format(sqlMethod.getSql(), table.getTableName(), this.sqlSet(selective, table), this.sqlWhere(table, true));
        SqlSource sqlSource = this.languageDriver.createSqlSource(this.configuration, sql, modelClass);
        this.addUpdateMappedStatement(mapperClass, modelClass, sqlMethod.getMethod(), sqlSource);
    }

    protected void injectSelectSql(boolean batch, Class<?> mapperClass, Class<?> modelClass, TableInfo table) {
        SqlMethod sqlMethod = SqlMethod.SELECT_BY_ID;
        RawSqlSource sqlSource = null;
        if (batch) {
            sqlMethod = SqlMethod.SELECT_BATCH;
            StringBuilder ids = new StringBuilder();
            ids.append("\n<foreach item=\"item\" index=\"index\" collection=\"list\" separator=\",\">");
            ids.append("#{item}");
            ids.append("\n</foreach>");
            sqlSource = this.languageDriver.createSqlSource(this.configuration, String.format(sqlMethod.getSql(), this.sqlSelectColumns(table, false), table.getTableName(), table.getKeyColumn(), ids.toString()), modelClass);
        } else {
            sqlSource = new RawSqlSource(this.configuration, String.format(sqlMethod.getSql(), this.sqlSelectColumns(table, false), table.getTableName(), table.getKeyColumn(), table.getKeyProperty()), Object.class);
        }
        this.addSelectMappedStatement(mapperClass, sqlMethod.getMethod(), (SqlSource)sqlSource, modelClass, table);
    }

    protected void injectSelectByMapSql(Class<?> mapperClass, Class<?> modelClass, TableInfo table) {
        SqlMethod sqlMethod = SqlMethod.SELECT_BY_MAP;
        String sql = String.format(sqlMethod.getSql(), this.sqlSelectColumns(table, false), table.getTableName(), this.sqlWhereByMap());
        SqlSource sqlSource = this.languageDriver.createSqlSource(this.configuration, sql, Map.class);
        this.addSelectMappedStatement(mapperClass, sqlMethod.getMethod(), sqlSource, modelClass, table);
    }

    protected void injectSelectOneSql(Class<?> mapperClass, Class<?> modelClass, TableInfo table) {
        SqlMethod sqlMethod = SqlMethod.SELECT_ONE;
        String sql = String.format(sqlMethod.getSql(), this.sqlSelectColumns(table, false), table.getTableName(), this.sqlWhere(table, false));
        SqlSource sqlSource = this.languageDriver.createSqlSource(this.configuration, sql, modelClass);
        this.addSelectMappedStatement(mapperClass, sqlMethod.getMethod(), sqlSource, modelClass, table);
    }

    protected void injectSelectCountSql(Class<?> mapperClass, Class<?> modelClass, TableInfo table) {
        SqlMethod sqlMethod = SqlMethod.SELECT_COUNT;
        String sql = String.format(sqlMethod.getSql(), table.getTableName(), this.sqlWhere(table, true));
        SqlSource sqlSource = this.languageDriver.createSqlSource(this.configuration, sql, modelClass);
        this.addSelectMappedStatement(mapperClass, sqlMethod.getMethod(), sqlSource, Integer.class, null);
    }

    protected void injectSelectListSql(SqlMethod sqlMethod, Class<?> mapperClass, Class<?> modelClass, TableInfo table) {
        String sql = String.format(sqlMethod.getSql(), this.sqlSelectColumns(table, true), table.getTableName(), this.sqlWhereEntityWrapper(table));
        SqlSource sqlSource = this.languageDriver.createSqlSource(this.configuration, sql, modelClass);
        this.addSelectMappedStatement(mapperClass, sqlMethod.getMethod(), sqlSource, modelClass, table);
    }

    protected void injectSelectCountByEWSql(SqlMethod sqlMethod, Class<?> mapperClass, Class<?> modelClass, TableInfo table) {
        String sql = String.format(sqlMethod.getSql(), table.getTableName(), this.sqlWhereEntityWrapper(table));
        SqlSource sqlSource = this.languageDriver.createSqlSource(this.configuration, sql, modelClass);
        this.addSelectMappedStatement(mapperClass, sqlMethod.getMethod(), sqlSource, Integer.class, null);
    }

    protected String sqlWhereEntityWrapper(TableInfo table) {
        StringBuilder where = new StringBuilder("\n<if test=\"ew!=null\">");
        where.append("\n<if test=\"ew.entity!=null\">\n<where>");
        where.append("\n<if test=\"ew.entity.").append(table.getKeyProperty()).append("!=null\">\n");
        where.append(table.getKeyColumn()).append("=#{ew.entity.").append(table.getKeyProperty()).append("}");
        where.append("\n</if>");
        List<TableFieldInfo> fieldList = table.getFieldList();
        for (TableFieldInfo fieldInfo : fieldList) {
            where.append(this.convertIfTag(fieldInfo, "ew.entity.", false));
            where.append(" AND ").append(fieldInfo.getColumn()).append("=#{ew.entity.").append(fieldInfo.getEl()).append("}");
            where.append(this.convertIfTag(fieldInfo, true));
        }
        where.append("\n</where>\n</if>");
        where.append("\n<if test=\"ew.sqlSegment!=null\">\n${ew.sqlSegment}\n</if>");
        where.append("\n</if>");
        return where.toString();
    }

    protected String sqlSet(boolean selective, TableInfo table) {
        StringBuilder set = new StringBuilder();
        set.append("<trim prefix=\"SET\" suffixOverrides=\",\">");
        List<TableFieldInfo> fieldList = table.getFieldList();
        for (TableFieldInfo fieldInfo : fieldList) {
            if (selective) {
                set.append(this.convertIfTag(fieldInfo, "et.", false));
            }
            set.append(fieldInfo.getColumn()).append("=#{et.").append(fieldInfo.getEl()).append("},");
            if (!selective) continue;
            set.append(this.convertIfTag(fieldInfo, true));
        }
        set.append("\n</trim>");
        return set.toString();
    }

    protected String sqlSelectColumns(TableInfo table, boolean entityWrapper) {
        StringBuilder columns = new StringBuilder();
        if (null != table.getResultMap()) {
            if (entityWrapper) {
                columns.append("<choose><when test=\"ew != null and ew.sqlSelect != null\">${ew.sqlSelect}</when><otherwise>");
            }
            columns.append("*");
            if (entityWrapper) {
                columns.append("</otherwise></choose>");
            }
        } else {
            if (entityWrapper) {
                columns.append("<choose><when test=\"ew != null and ew.sqlSelect != null\">${ew.sqlSelect}</when><otherwise>");
            }
            if (table.isKeyRelated()) {
                columns.append(table.getKeyColumn()).append(" AS ").append(table.getKeyProperty());
            } else {
                columns.append(table.getKeyProperty());
            }
            List<TableFieldInfo> fieldList = table.getFieldList();
            for (TableFieldInfo fieldInfo : fieldList) {
                columns.append(",").append(fieldInfo.getColumn());
                if (!fieldInfo.isRelated()) continue;
                columns.append(" AS ").append(fieldInfo.getProperty());
            }
            if (entityWrapper) {
                columns.append("</otherwise></choose>");
            }
        }
        return columns.toString();
    }

    protected String sqlWhere(TableInfo table, boolean space) {
        StringBuilder where = new StringBuilder();
        if (space) {
            where.append("\n<if test=\"ew!=null\">");
        }
        where.append("\n<where>");
        where.append("\n<if test=\"ew.").append(table.getKeyProperty()).append("!=null\">\n");
        where.append(table.getKeyColumn()).append("=#{ew.").append(table.getKeyProperty()).append("}");
        where.append("\n</if>");
        List<TableFieldInfo> fieldList = table.getFieldList();
        for (TableFieldInfo fieldInfo : fieldList) {
            where.append(this.convertIfTag(fieldInfo, "ew.", false));
            where.append(" AND ").append(fieldInfo.getColumn()).append("=#{ew.").append(fieldInfo.getEl()).append("}");
            where.append(this.convertIfTag(fieldInfo, true));
        }
        where.append("\n</where>");
        if (space) {
            where.append("\n</if>");
        }
        return where.toString();
    }

    protected String sqlWhereByMap() {
        StringBuilder where = new StringBuilder();
        where.append("\n<if test=\"cm!=null and !cm.isEmpty\">");
        where.append("\n WHERE ");
        where.append("\n<foreach collection=\"cm.keys\" item=\"k\" separator=\"AND\"> ");
        where.append("\n${k}=#{cm[${k}]}");
        where.append("\n</foreach>");
        where.append("\n</if>");
        return where.toString();
    }

    protected String convertIfTag(SqlCommandType sqlCommandType, TableFieldInfo fieldInfo, String prefix, boolean colse) {
        String property = fieldInfo.getProperty();
        if (null != prefix) {
            property = prefix + property;
        }
        if (sqlCommandType == SqlCommandType.INSERT && fieldInfo.getFieldStrategy() == FieldStrategy.FILL) {
            return "";
        }
        if (fieldInfo.getFieldStrategy() == FieldStrategy.IGNORED) {
            return "";
        }
        if (fieldInfo.getFieldStrategy() == FieldStrategy.NOT_EMPTY) {
            if (colse) {
                return "</if>";
            }
            return String.format("\n\t<if test=\"%s!=null and %s!=''\">", property, property);
        }
        if (colse) {
            return "</if>";
        }
        return String.format("\n\t<if test=\"%s!=null\">", property);
    }

    protected String convertIfTagInsert(TableFieldInfo fieldInfo, boolean colse) {
        return this.convertIfTag(SqlCommandType.INSERT, fieldInfo, null, colse);
    }

    protected String convertIfTag(TableFieldInfo fieldInfo, String prefix, boolean colse) {
        return this.convertIfTag(SqlCommandType.UNKNOWN, fieldInfo, prefix, colse);
    }

    protected String convertIfTag(TableFieldInfo fieldInfo, boolean colse) {
        return this.convertIfTag(fieldInfo, null, colse);
    }

    public MappedStatement addSelectMappedStatement(Class<?> mapperClass, String id, SqlSource sqlSource, Class<?> resultType, TableInfo table) {
        String resultMap;
        if (null != table && null != (resultMap = table.getResultMap())) {
            return this.addMappedStatement(mapperClass, id, sqlSource, SqlCommandType.SELECT, null, resultMap, null, (KeyGenerator)new NoKeyGenerator(), null, null);
        }
        return this.addMappedStatement(mapperClass, id, sqlSource, SqlCommandType.SELECT, null, null, resultType, (KeyGenerator)new NoKeyGenerator(), null, null);
    }

    public MappedStatement addInsertMappedStatement(Class<?> mapperClass, Class<?> modelClass, String id, SqlSource sqlSource, KeyGenerator keyGenerator, String keyProperty, String keyColumn) {
        return this.addMappedStatement(mapperClass, id, sqlSource, SqlCommandType.INSERT, modelClass, null, Integer.class, keyGenerator, keyProperty, keyColumn);
    }

    public MappedStatement addDeleteMappedStatement(Class<?> mapperClass, String id, SqlSource sqlSource) {
        return this.addMappedStatement(mapperClass, id, sqlSource, SqlCommandType.DELETE, null, null, Integer.class, (KeyGenerator)new NoKeyGenerator(), null, null);
    }

    public MappedStatement addUpdateMappedStatement(Class<?> mapperClass, Class<?> modelClass, String id, SqlSource sqlSource) {
        return this.addMappedStatement(mapperClass, id, sqlSource, SqlCommandType.UPDATE, modelClass, null, Integer.class, (KeyGenerator)new NoKeyGenerator(), null, null);
    }

    public MappedStatement addMappedStatement(Class<?> mapperClass, String id, SqlSource sqlSource, SqlCommandType sqlCommandType, Class<?> parameterClass, String resultMap, Class<?> resultType, KeyGenerator keyGenerator, String keyProperty, String keyColumn) {
        String statementName = mapperClass.getName() + "." + id;
        if (this.configuration.hasStatement(statementName)) {
            System.err.println("{" + statementName + "} Has been loaded by XML or SqlProvider, ignoring the injection of the SQL.");
            return null;
        }
        boolean isSelect = false;
        if (sqlCommandType == SqlCommandType.SELECT) {
            isSelect = true;
        }
        return this.builderAssistant.addMappedStatement(id, sqlSource, StatementType.PREPARED, sqlCommandType, null, null, null, parameterClass, resultMap, resultType, null, !isSelect, isSelect, false, keyGenerator, keyProperty, keyColumn, this.configuration.getDatabaseId(), this.languageDriver, null);
    }
}

