/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.plugins;

import com.baomidou.mybatisplus.exceptions.MybatisPlusException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Properties;
import java.util.logging.Logger;
import org.apache.ibatis.builder.StaticSqlSource;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.scripting.defaults.DefaultParameterHandler;
import org.apache.ibatis.session.Configuration;

@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
public class SqlExplainInterceptor
implements Interceptor {
    protected final Logger logger = Logger.getLogger("SqlExplainInterceptor");
    private boolean stopProceed = false;

    public Object intercept(Invocation invocation) throws Throwable {
        MappedStatement ms = (MappedStatement)invocation.getArgs()[0];
        if (ms.getSqlCommandType() == SqlCommandType.DELETE || ms.getSqlCommandType() == SqlCommandType.UPDATE) {
            Configuration configuration = ms.getConfiguration();
            Object parameter = invocation.getArgs()[1];
            BoundSql boundSql = ms.getBoundSql(parameter);
            Executor exe = (Executor)invocation.getTarget();
            Connection connection = exe.getTransaction().getConnection();
            this.sqlExplain(configuration, ms, boundSql, connection, parameter);
        }
        return invocation.proceed();
    }

    protected void sqlExplain(Configuration configuration, MappedStatement mappedStatement, BoundSql boundSql, Connection connection, Object parameter) throws Exception {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            StringBuilder explain = new StringBuilder("EXPLAIN ");
            explain.append(boundSql.getSql());
            String sqlExplain = explain.toString();
            StaticSqlSource sqlsource = new StaticSqlSource(configuration, sqlExplain, boundSql.getParameterMappings());
            MappedStatement.Builder builder = new MappedStatement.Builder(configuration, "explain_sql", (SqlSource)sqlsource, SqlCommandType.SELECT);
            builder.resultMaps(mappedStatement.getResultMaps()).resultSetType(mappedStatement.getResultSetType()).statementType(mappedStatement.getStatementType());
            MappedStatement query_statement = builder.build();
            DefaultParameterHandler handler = new DefaultParameterHandler(query_statement, parameter, boundSql);
            stmt = connection.prepareStatement(sqlExplain);
            handler.setParameters((PreparedStatement)stmt);
            rs = stmt.executeQuery();
            while (rs.next()) {
                if ("Using where".equals(rs.getString("Extra"))) continue;
                String tip = " Full table operation is prohibited. SQL: " + boundSql.getSql();
                if (this.isStopProceed()) {
                    throw new MybatisPlusException(tip);
                }
                this.logger.severe(tip);
                break;
            }
        }
        catch (Exception e) {
            throw new MybatisPlusException(e);
        }
        finally {
            if (rs != null) {
                rs.close();
                rs = null;
            }
            if (stmt != null) {
                stmt.close();
                stmt = null;
            }
        }
    }

    public Object plugin(Object target) {
        if (target instanceof Executor) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void setProperties(Properties prop) {
    }

    public boolean isStopProceed() {
        return this.stopProceed;
    }

    public void setStopProceed(boolean stopProceed) {
        this.stopProceed = stopProceed;
    }
}

