/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.toolkit;

public class StringEscape {
    private static boolean isEscapeNeededForString(String x, int stringLength) {
        boolean needsHexEscape = false;
        for (int i = 0; i < stringLength; ++i) {
            char c = x.charAt(i);
            switch (c) {
                case '\\': {
                    needsHexEscape = true;
                    break;
                }
                case '\'': {
                    needsHexEscape = true;
                    break;
                }
                case '\"': {
                    needsHexEscape = true;
                }
            }
            if (needsHexEscape) break;
        }
        return needsHexEscape;
    }

    public static String escapeString(String x) {
        if (x.matches("'(.+)'")) {
            x = x.substring(1, x.length() - 1);
        }
        String parameterAsString = x;
        int stringLength = x.length();
        if (StringEscape.isEscapeNeededForString(x, stringLength)) {
            StringBuilder buf = new StringBuilder((int)((double)x.length() * 1.1));
            block5: for (int i = 0; i < stringLength; ++i) {
                char c = x.charAt(i);
                switch (c) {
                    case '\\': {
                        buf.append('\\');
                        buf.append('\\');
                        continue block5;
                    }
                    case '\'': {
                        buf.append('\\');
                        buf.append('\'');
                        continue block5;
                    }
                    case '\"': {
                        buf.append('\\');
                        buf.append('\"');
                        continue block5;
                    }
                    default: {
                        buf.append(c);
                    }
                }
            }
            parameterAsString = buf.toString();
        }
        return "'" + parameterAsString + "'";
    }
}

