/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.entity;

import com.baomidou.mybatisplus.annotations.KeySequence;
import com.baomidou.mybatisplus.entity.GlobalConfiguration;
import com.baomidou.mybatisplus.entity.TableFieldInfo;
import com.baomidou.mybatisplus.enums.IdType;
import com.baomidou.mybatisplus.exceptions.MybatisPlusException;
import java.util.List;
import org.apache.ibatis.session.Configuration;

public class TableInfo {
    private IdType idType = IdType.NONE;
    private String tableName;
    private String resultMap;
    private boolean keyRelated = false;
    private String keyProperty;
    private String keyColumn;
    private KeySequence keySequence;
    private List<TableFieldInfo> fieldList;
    private String currentNamespace;
    private String configMark;
    private boolean logicDelete = false;

    public String getSqlStatement(String sqlMethod) {
        StringBuilder statement = new StringBuilder();
        statement.append(this.currentNamespace);
        statement.append(".");
        statement.append(sqlMethod);
        return statement.toString();
    }

    public IdType getIdType() {
        return this.idType;
    }

    public void setIdType(IdType idType) {
        this.idType = idType;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getResultMap() {
        return this.resultMap;
    }

    public void setResultMap(String resultMap) {
        this.resultMap = resultMap;
    }

    public boolean isKeyRelated() {
        return this.keyRelated;
    }

    public void setKeyRelated(boolean keyRelated) {
        this.keyRelated = keyRelated;
    }

    public String getKeyProperty() {
        return this.keyProperty;
    }

    public void setKeyProperty(String keyProperty) {
        this.keyProperty = keyProperty;
    }

    public String getKeyColumn() {
        return this.keyColumn;
    }

    public void setKeyColumn(String keyColumn) {
        this.keyColumn = keyColumn;
    }

    public KeySequence getKeySequence() {
        return this.keySequence;
    }

    public void setKeySequence(KeySequence keySequence) {
        this.keySequence = keySequence;
    }

    public List<TableFieldInfo> getFieldList() {
        return this.fieldList;
    }

    public void setFieldList(GlobalConfiguration globalConfig, List<TableFieldInfo> fieldList) {
        this.fieldList = fieldList;
        if (null != globalConfig.getLogicDeleteValue()) {
            for (TableFieldInfo tfi : fieldList) {
                if (!tfi.isLogicDelete()) continue;
                this.setLogicDelete(true);
                break;
            }
        }
    }

    public String getCurrentNamespace() {
        return this.currentNamespace;
    }

    public void setCurrentNamespace(String currentNamespace) {
        this.currentNamespace = currentNamespace;
    }

    public String getConfigMark() {
        return this.configMark;
    }

    public void setConfigMark(Configuration configuration) {
        if (configuration == null) {
            throw new MybatisPlusException("Error: You need Initialize MybatisConfiguration !");
        }
        this.configMark = configuration.toString();
    }

    public boolean isLogicDelete() {
        return this.logicDelete;
    }

    public void setLogicDelete(boolean logicDelete) {
        if (logicDelete) {
            this.logicDelete = logicDelete;
        }
    }
}

