/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.toolkit;

import com.baomidou.mybatisplus.entity.CountOptimize;
import com.baomidou.mybatisplus.toolkit.CollectionUtils;
import java.util.ArrayList;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.select.Distinct;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;

public class JsqlParserUtils {
    private static List<SelectItem> countSelectItem = null;

    public static CountOptimize jsqlparserCount(CountOptimize countOptimize, String originalSql) {
        String sqlCount;
        try {
            Select selectStatement = (Select)CCJSqlParserUtil.parse((String)originalSql);
            PlainSelect plainSelect = (PlainSelect)selectStatement.getSelectBody();
            Distinct distinct = plainSelect.getDistinct();
            List groupBy = plainSelect.getGroupByColumnReferences();
            List orderBy = plainSelect.getOrderByElements();
            if (CollectionUtils.isEmpty(groupBy) && CollectionUtils.isNotEmpty(orderBy)) {
                plainSelect.setOrderByElements(null);
                countOptimize.setOrderBy(false);
            }
            if (distinct != null || CollectionUtils.isNotEmpty(groupBy)) {
                String sqlCount2 = String.format("SELECT COUNT(1) FROM ( %s ) TOTAL", selectStatement.toString());
                countOptimize.setCountSQL(sqlCount2);
                return countOptimize;
            }
            List<SelectItem> selectCount = JsqlParserUtils.countSelectItem();
            plainSelect.setSelectItems(selectCount);
            sqlCount = selectStatement.toString();
        }
        catch (Exception e) {
            sqlCount = String.format("SELECT COUNT(1) FROM ( %s ) TOTAL", originalSql);
        }
        countOptimize.setCountSQL(sqlCount);
        return countOptimize;
    }

    private static List<SelectItem> countSelectItem() {
        if (CollectionUtils.isNotEmpty(countSelectItem)) {
            return countSelectItem;
        }
        Function function = new Function();
        function.setName("COUNT");
        ArrayList<LongValue> expressions = new ArrayList<LongValue>();
        LongValue longValue = new LongValue(1L);
        ExpressionList expressionList = new ExpressionList();
        expressions.add(longValue);
        expressionList.setExpressions(expressions);
        function.setParameters(expressionList);
        countSelectItem = new ArrayList<SelectItem>();
        SelectExpressionItem selectExpressionItem = new SelectExpressionItem((Expression)function);
        countSelectItem.add((SelectItem)selectExpressionItem);
        return countSelectItem;
    }
}

