/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.generator;

import com.baomidou.mybatisplus.generator.InjectionConfig;
import com.baomidou.mybatisplus.generator.config.ConstVal;
import com.baomidou.mybatisplus.generator.config.DataSourceConfig;
import com.baomidou.mybatisplus.generator.config.FileOutConfig;
import com.baomidou.mybatisplus.generator.config.GlobalConfig;
import com.baomidou.mybatisplus.generator.config.PackageConfig;
import com.baomidou.mybatisplus.generator.config.StrategyConfig;
import com.baomidou.mybatisplus.generator.config.TemplateConfig;
import com.baomidou.mybatisplus.generator.config.builder.ConfigBuilder;
import com.baomidou.mybatisplus.generator.config.po.TableField;
import com.baomidou.mybatisplus.generator.config.po.TableInfo;
import com.baomidou.mybatisplus.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.toolkit.StringUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

public class AutoGenerator {
    private static final Log logger = LogFactory.getLog(AutoGenerator.class);
    protected ConfigBuilder config;
    protected InjectionConfig injectionConfig;
    private DataSourceConfig dataSource;
    private StrategyConfig strategy;
    private PackageConfig packageInfo;
    private TemplateConfig template;
    private GlobalConfig globalConfig;
    private VelocityEngine engine;

    public void execute() {
        logger.debug("==========================\u51c6\u5907\u751f\u6210\u6587\u4ef6...==========================");
        this.initConfig();
        this.mkdirs(this.config.getPathInfo());
        Map<String, VelocityContext> ctxData = this.analyzeData(this.config);
        for (Map.Entry<String, VelocityContext> ctx : ctxData.entrySet()) {
            this.batchOutput(ctx.getKey(), ctx.getValue());
        }
        if (this.config.getGlobalConfig().isOpen()) {
            try {
                String osName = System.getProperty("os.name");
                if (osName != null) {
                    if (osName.contains("Mac")) {
                        Runtime.getRuntime().exec("open " + this.config.getGlobalConfig().getOutputDir());
                    } else if (osName.contains("Windows")) {
                        Runtime.getRuntime().exec("cmd /c start " + this.config.getGlobalConfig().getOutputDir());
                    } else {
                        logger.debug("\u6587\u4ef6\u8f93\u51fa\u76ee\u5f55:" + this.config.getGlobalConfig().getOutputDir());
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        logger.debug("==========================\u6587\u4ef6\u751f\u6210\u5b8c\u6210\uff01\uff01\uff01==========================");
    }

    protected List<TableInfo> getAllTableInfoList(ConfigBuilder config) {
        return config.getTableInfoList();
    }

    private Map<String, VelocityContext> analyzeData(ConfigBuilder config) {
        List<TableInfo> tableList = this.getAllTableInfoList(config);
        Map<String, String> packageInfo = config.getPackageInfo();
        HashMap<String, VelocityContext> ctxData = new HashMap<String, VelocityContext>();
        String superEntityClass = this.getSuperClassName(config.getSuperEntityClass());
        String superMapperClass = this.getSuperClassName(config.getSuperMapperClass());
        String superServiceClass = this.getSuperClassName(config.getSuperServiceClass());
        String superServiceImplClass = this.getSuperClassName(config.getSuperServiceImplClass());
        String superControllerClass = this.getSuperClassName(config.getSuperControllerClass());
        String date = new SimpleDateFormat("yyyy-MM-dd").format(new Date());
        for (TableInfo tableInfo : tableList) {
            VelocityContext ctx = new VelocityContext();
            if (null != this.injectionConfig) {
                this.injectionConfig.initMap();
                ctx.put("cfg", this.injectionConfig.getMap());
            }
            if (config.getGlobalConfig().isActiveRecord()) {
                tableInfo.setImportPackages("com.baomidou.mybatisplus.activerecord.Model");
            }
            if (tableInfo.isConvert()) {
                tableInfo.setImportPackages("com.baomidou.mybatisplus.annotations.TableName");
            }
            if (tableInfo.isLogicDelete(config.getStrategyConfig().getLogicDeleteFieldName())) {
                tableInfo.setImportPackages("com.baomidou.mybatisplus.annotations.TableLogic");
            }
            if (StringUtils.isNotEmpty(config.getSuperEntityClass())) {
                tableInfo.setImportPackages(config.getSuperEntityClass());
            } else {
                tableInfo.setImportPackages("java.io.Serializable");
            }
            if (config.getStrategyConfig().isEntityBooleanColumnRemoveIsPrefix()) {
                for (TableField field : tableInfo.getFields()) {
                    if (!field.getPropertyType().equalsIgnoreCase("boolean") || field.getPropertyName().indexOf("is") == -1) continue;
                    field.setPropertyName(config.getStrategyConfig(), field.getPropertyName().substring(0, 3).toLowerCase().substring(2));
                }
            }
            if (config.getStrategyConfig().isControllerMappingHyphenStyle()) {
                ctx.put("controllerMappingHyphenStyle", (Object)config.getStrategyConfig().isControllerMappingHyphenStyle());
                ctx.put("controllerMappingHyphen", (Object)StringUtils.camelToHyphen(tableInfo.getEntityPath()));
            }
            ctx.put("restControllerStyle", (Object)config.getStrategyConfig().isRestControllerStyle());
            ctx.put("package", packageInfo);
            ctx.put("author", (Object)config.getGlobalConfig().getAuthor());
            ctx.put("logicDeleteFieldName", (Object)config.getStrategyConfig().getLogicDeleteFieldName());
            ctx.put("activeRecord", (Object)config.getGlobalConfig().isActiveRecord());
            ctx.put("date", (Object)date);
            ctx.put("table", (Object)tableInfo);
            ctx.put("enableCache", (Object)config.getGlobalConfig().isEnableCache());
            ctx.put("baseResultMap", (Object)config.getGlobalConfig().isBaseResultMap());
            ctx.put("baseColumnList", (Object)config.getGlobalConfig().isBaseColumnList());
            ctx.put("entity", (Object)tableInfo.getEntityName());
            ctx.put("entityColumnConstant", (Object)config.getStrategyConfig().isEntityColumnConstant());
            ctx.put("entityBuilderModel", (Object)config.getStrategyConfig().isEntityBuilderModel());
            ctx.put("entityLombokModel", (Object)config.getStrategyConfig().isEntityLombokModel());
            ctx.put("entityBooleanColumnRemoveIsPrefix", (Object)config.getStrategyConfig().isEntityBooleanColumnRemoveIsPrefix());
            ctx.put("superEntityClass", (Object)superEntityClass);
            ctx.put("superMapperClassPackage", (Object)config.getSuperMapperClass());
            ctx.put("superMapperClass", (Object)superMapperClass);
            ctx.put("superServiceClassPackage", (Object)config.getSuperServiceClass());
            ctx.put("superServiceClass", (Object)superServiceClass);
            ctx.put("superServiceImplClassPackage", (Object)config.getSuperServiceImplClass());
            ctx.put("superServiceImplClass", (Object)superServiceImplClass);
            ctx.put("superControllerClassPackage", (Object)config.getSuperControllerClass());
            ctx.put("superControllerClass", (Object)superControllerClass);
            ctxData.put(tableInfo.getEntityName(), ctx);
        }
        return ctxData;
    }

    private String getSuperClassName(String classPath) {
        if (StringUtils.isEmpty(classPath)) {
            return null;
        }
        return classPath.substring(classPath.lastIndexOf(".") + 1);
    }

    private void mkdirs(Map<String, String> pathInfo) {
        for (Map.Entry<String, String> entry : pathInfo.entrySet()) {
            boolean result;
            File dir = new File(entry.getValue());
            if (dir.exists() || !(result = dir.mkdirs())) continue;
            logger.debug("\u521b\u5efa\u76ee\u5f55\uff1a [" + entry.getValue() + "]");
        }
    }

    private void batchOutput(String entityName, VelocityContext context) {
        try {
            List<FileOutConfig> focList;
            TableInfo tableInfo = (TableInfo)context.get("table");
            Map<String, String> pathInfo = this.config.getPathInfo();
            String entityFile = String.format(pathInfo.get("entity_path") + ConstVal.ENTITY_NAME, entityName);
            String mapperFile = String.format(pathInfo.get("mapper_path") + File.separator + tableInfo.getMapperName() + ".java", entityName);
            String xmlFile = String.format(pathInfo.get("xml_path") + File.separator + tableInfo.getXmlName() + ".xml", entityName);
            String serviceFile = String.format(pathInfo.get("serivce_path") + File.separator + tableInfo.getServiceName() + ".java", entityName);
            String implFile = String.format(pathInfo.get("serviceimpl_path") + File.separator + tableInfo.getServiceImplName() + ".java", entityName);
            String controllerFile = String.format(pathInfo.get("controller_path") + File.separator + tableInfo.getControllerName() + ".java", entityName);
            TemplateConfig template = this.config.getTemplate();
            if (this.isCreate(entityFile)) {
                this.vmToFile(context, template.getEntity(), entityFile);
            }
            if (this.isCreate(mapperFile)) {
                this.vmToFile(context, template.getMapper(), mapperFile);
            }
            if (this.isCreate(xmlFile)) {
                this.vmToFile(context, template.getXml(), xmlFile);
            }
            if (this.isCreate(serviceFile)) {
                this.vmToFile(context, template.getService(), serviceFile);
            }
            if (this.isCreate(implFile)) {
                this.vmToFile(context, template.getServiceImpl(), implFile);
            }
            if (this.isCreate(controllerFile)) {
                this.vmToFile(context, template.getController(), controllerFile);
            }
            if (this.injectionConfig != null && CollectionUtils.isNotEmpty(focList = this.injectionConfig.getFileOutConfigList())) {
                for (FileOutConfig foc : focList) {
                    this.vmToFile(context, foc.getTemplatePath(), foc.outputFile(tableInfo));
                }
            }
        }
        catch (IOException e) {
            logger.error("\u65e0\u6cd5\u521b\u5efa\u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u4fe1\u606f\uff01", (Throwable)e);
        }
    }

    private void vmToFile(VelocityContext context, String templatePath, String outputFile) throws IOException {
        if (StringUtils.isEmpty(templatePath)) {
            return;
        }
        VelocityEngine velocity = this.getVelocityEngine();
        Template template = velocity.getTemplate(templatePath, ConstVal.UTF8);
        File file = new File(outputFile);
        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            logger.debug("\u521b\u5efa\u6587\u4ef6\u6240\u5728\u7684\u76ee\u5f55\u5931\u8d25!");
            return;
        }
        FileOutputStream fos = new FileOutputStream(outputFile);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, ConstVal.UTF8));
        template.merge((Context)context, (Writer)writer);
        writer.close();
        logger.debug("\u6a21\u677f:" + templatePath + ";  \u6587\u4ef6:" + outputFile);
    }

    private VelocityEngine getVelocityEngine() {
        if (this.engine == null) {
            Properties p = new Properties();
            p.setProperty("file.resource.loader.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
            p.setProperty("file.resource.loader.path", "");
            p.setProperty("ISO-8859-1", ConstVal.UTF8);
            p.setProperty("input.encoding", ConstVal.UTF8);
            p.setProperty("output.encoding", ConstVal.UTF8);
            p.setProperty("file.resource.loader.unicode", "true");
            this.engine = new VelocityEngine(p);
        }
        return this.engine;
    }

    private boolean isCreate(String filePath) {
        File file = new File(filePath);
        return !file.exists() || this.config.getGlobalConfig().isFileOverride();
    }

    protected void initConfig() {
        if (null == this.config) {
            this.config = new ConfigBuilder(this.packageInfo, this.dataSource, this.strategy, this.template, this.globalConfig);
            if (null != this.injectionConfig) {
                this.injectionConfig.setConfig(this.config);
            }
        }
    }

    public DataSourceConfig getDataSource() {
        return this.dataSource;
    }

    public AutoGenerator setDataSource(DataSourceConfig dataSource) {
        this.dataSource = dataSource;
        return this;
    }

    public StrategyConfig getStrategy() {
        return this.strategy;
    }

    public AutoGenerator setStrategy(StrategyConfig strategy) {
        this.strategy = strategy;
        return this;
    }

    public PackageConfig getPackageInfo() {
        return this.packageInfo;
    }

    public AutoGenerator setPackageInfo(PackageConfig packageInfo) {
        this.packageInfo = packageInfo;
        return this;
    }

    public TemplateConfig getTemplate() {
        return this.template;
    }

    public AutoGenerator setTemplate(TemplateConfig template) {
        this.template = template;
        return this;
    }

    public ConfigBuilder getConfig() {
        return this.config;
    }

    public AutoGenerator setConfig(ConfigBuilder config) {
        this.config = config;
        return this;
    }

    public GlobalConfig getGlobalConfig() {
        return this.globalConfig;
    }

    public AutoGenerator setGlobalConfig(GlobalConfig globalConfig) {
        this.globalConfig = globalConfig;
        return this;
    }

    public InjectionConfig getCfg() {
        return this.injectionConfig;
    }

    public AutoGenerator setCfg(InjectionConfig injectionConfig) {
        this.injectionConfig = injectionConfig;
        return this;
    }
}

