/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou;

import com.baomidou.AbstractGenerateMojo;
import com.baomidou.config.ConstVal;
import com.baomidou.config.TemplateConfig;
import com.baomidou.config.builder.ConfigBuilder;
import com.baomidou.config.po.TableInfo;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mojo(name="code", threadSafe=true)
public class GenerateMojo
extends AbstractGenerateMojo {
    private VelocityEngine engine;
    private Map<String, String> outputFiles;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.log.info((CharSequence)"==========================\u51c6\u5907\u751f\u6210\u6587\u4ef6...==========================");
        this.initConfig();
        this.initOutputFiles();
        this.mkdirs(this.config.getPathInfo());
        Map<String, VelocityContext> ctxData = this.analyzeData(this.config);
        for (Map.Entry<String, VelocityContext> ctx : ctxData.entrySet()) {
            this.batchOutput(ctx.getKey(), ctx.getValue());
        }
        if (this.isOpen()) {
            try {
                String osName = System.getProperty("os.name");
                if (osName != null) {
                    if (osName.contains("Mac")) {
                        Runtime.getRuntime().exec("open " + this.getOutputDir());
                    } else if (osName.contains("Windows")) {
                        Runtime.getRuntime().exec("cmd /c start " + this.getOutputDir());
                    } else {
                        this.log.info((CharSequence)("\u6587\u4ef6\u8f93\u51fa\u76ee\u5f55:" + this.getOutputDir()));
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.log.info((CharSequence)"==========================\u6587\u4ef6\u751f\u6210\u5b8c\u6210\uff01\uff01\uff01==========================");
    }

    private Map<String, VelocityContext> analyzeData(ConfigBuilder config) {
        List<TableInfo> tableList = config.getTableInfoList();
        Map<String, String> packageInfo = config.getPackageInfo();
        HashMap<String, VelocityContext> ctxData = new HashMap<String, VelocityContext>();
        String superEntityClass = this.getSuperClassName(config.getSuperEntityClass());
        String superMapperClass = this.getSuperClassName(config.getSuperMapperClass());
        String superServiceClass = this.getSuperClassName(config.getSuperServiceClass());
        String superServiceImplClass = this.getSuperClassName(config.getSuperServiceImplClass());
        String superControllerClass = this.getSuperClassName(config.getSuperControllerClass());
        String date = new SimpleDateFormat("yyyy-MM-dd").format(new Date());
        for (TableInfo tableInfo : tableList) {
            VelocityContext ctx = new VelocityContext();
            ctx.put("package", packageInfo);
            ctx.put("table", (Object)tableInfo);
            ctx.put("entity", (Object)tableInfo.getEntityName());
            ctx.put("addTabeName", (Object)(!tableInfo.getEntityName().toLowerCase().equals(tableInfo.getName().toLowerCase()) ? 1 : 0));
            ctx.put("idGenType", (Object)config.getIdType());
            ctx.put("superEntityClassPackage", (Object)config.getSuperEntityClass());
            ctx.put("superEntityClass", (Object)superEntityClass);
            ctx.put("superMapperClassPackage", (Object)config.getSuperMapperClass());
            ctx.put("superMapperClass", (Object)superMapperClass);
            ctx.put("superServiceClassPackage", (Object)config.getSuperServiceClass());
            ctx.put("superServiceClass", (Object)superServiceClass);
            ctx.put("superServiceImplClassPackage", (Object)config.getSuperServiceImplClass());
            ctx.put("superServiceImplClass", (Object)superServiceImplClass);
            ctx.put("superControllerClassPackage", (Object)config.getSuperControllerClass());
            ctx.put("superControllerClass", (Object)superControllerClass);
            ctx.put("enableCache", (Object)this.isEnableCache());
            ctx.put("author", (Object)this.getAuthor());
            ctx.put("activeRecord", (Object)this.isActiveRecord());
            ctx.put("date", (Object)date);
            ctxData.put(tableInfo.getEntityName(), ctx);
        }
        return ctxData;
    }

    private String getSuperClassName(String classPath) {
        if (StringUtils.isBlank((String)classPath)) {
            return null;
        }
        return classPath.substring(classPath.lastIndexOf(".") + 1);
    }

    private void mkdirs(Map<String, String> pathInfo) {
        for (Map.Entry<String, String> entry : pathInfo.entrySet()) {
            boolean result;
            File dir = new File(entry.getValue());
            if (dir.exists() || !(result = dir.mkdirs())) continue;
            this.log.info((CharSequence)("\u521b\u5efa\u76ee\u5f55\uff1a [" + entry.getValue() + "]"));
        }
    }

    private void initOutputFiles() {
        this.outputFiles = new HashMap<String, String>();
        Map<String, String> pathInfo = this.config.getPathInfo();
        this.outputFiles.put("Entity", pathInfo.get("entity_path") + ConstVal.ENTITY_NAME);
        this.outputFiles.put("Mapper", pathInfo.get("mapper_path") + ConstVal.MAPPER_NAME);
        this.outputFiles.put("Xml", pathInfo.get("xml_path") + ConstVal.XML_NAME);
        this.outputFiles.put("Service", pathInfo.get("serivce_path") + ConstVal.SERVICE_NAME);
        this.outputFiles.put("ServiceImpl", pathInfo.get("serviceimpl_path") + ConstVal.SERVICEIMPL_NAME);
        this.outputFiles.put("ServiceImpl", pathInfo.get("serviceimpl_path") + ConstVal.SERVICEIMPL_NAME);
        this.outputFiles.put("Controller", pathInfo.get("controller_path") + ConstVal.CONTROLLER_NAME);
    }

    private void batchOutput(String entityName, VelocityContext context) {
        try {
            String entityFile = String.format(this.outputFiles.get("Entity"), entityName);
            String mapperFile = String.format(this.outputFiles.get("Mapper"), entityName);
            String xmlFile = String.format(this.outputFiles.get("Xml"), entityName);
            String serviceFile = String.format(this.outputFiles.get("Service"), entityName);
            String implFile = String.format(this.outputFiles.get("ServiceImpl"), entityName);
            String controllerFile = String.format(this.outputFiles.get("Controller"), entityName);
            TemplateConfig template = this.config.getTemplate();
            if (this.isCreate(entityFile)) {
                this.vmToFile(context, template.getEntity(), entityFile);
            }
            if (this.isCreate(mapperFile)) {
                this.vmToFile(context, template.getMapper(), mapperFile);
            }
            if (this.isCreate(xmlFile)) {
                this.vmToFile(context, template.getXml(), xmlFile);
            }
            if (this.isCreate(serviceFile)) {
                this.vmToFile(context, template.getService(), serviceFile);
            }
            if (this.isCreate(implFile)) {
                this.vmToFile(context, template.getServiceImpl(), implFile);
            }
            if (this.isCreate(controllerFile)) {
                this.vmToFile(context, template.getController(), controllerFile);
            }
        }
        catch (IOException e) {
            this.log.error((CharSequence)"\u65e0\u6cd5\u521b\u5efa\u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u4fe1\u606f\uff01");
            e.printStackTrace();
        }
    }

    private void vmToFile(VelocityContext context, String templatePath, String outputFile) throws IOException {
        VelocityEngine velocity = this.getVelocityEngine();
        Template template = velocity.getTemplate(templatePath, ConstVal.UTF8);
        FileOutputStream fos = new FileOutputStream(outputFile);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, ConstVal.UTF8));
        template.merge((Context)context, (Writer)writer);
        writer.close();
        this.log.info((CharSequence)("\u6a21\u677f:" + templatePath + ";  \u6587\u4ef6:" + outputFile));
    }

    private VelocityEngine getVelocityEngine() {
        if (this.engine == null) {
            Properties p = new Properties();
            p.setProperty("file.resource.loader.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
            p.setProperty("file.resource.loader.path", "");
            p.setProperty("ISO-8859-1", ConstVal.UTF8);
            p.setProperty("input.encoding", ConstVal.UTF8);
            p.setProperty("output.encoding", ConstVal.UTF8);
            p.setProperty("file.resource.loader.unicode", "true");
            this.engine = new VelocityEngine(p);
        }
        return this.engine;
    }

    private boolean isCreate(String filePath) {
        File file = new File(filePath);
        return !file.exists() || this.isFileOverride();
    }
}

