/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.config.rules;

import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum NamingStrategy {
    nochange,
    underline_to_camel,
    remove_prefix,
    remove_prefix_and_camel;


    public static String underlineToCamel(String name) {
        String[] camels;
        if (StringUtils.isBlank((String)name)) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        for (String camel : camels = name.toLowerCase().split("_")) {
            if (StringUtils.isBlank((String)camel)) continue;
            if (result.length() == 0) {
                result.append(camel);
                continue;
            }
            result.append(NamingStrategy.capitalFirst(camel));
        }
        return result.toString();
    }

    public static String removePrefix(String name) {
        if (StringUtils.isBlank((String)name)) {
            return "";
        }
        int idx = name.indexOf("_");
        if (idx == -1) {
            return name;
        }
        return name.substring(idx + 1);
    }

    public static String removePrefix(String name, String prefix) {
        if (StringUtils.isBlank((String)name)) {
            return "";
        }
        int idx = name.indexOf("_");
        if (prefix != null && !"".equals(prefix.trim()) && name.toLowerCase().matches("^" + prefix.toLowerCase() + ".*")) {
            idx = prefix.length() - 1;
        }
        if (idx == -1) {
            return name;
        }
        return name.substring(idx + 1);
    }

    public static String removePrefixAndCamel(String name, String tablePrefix) {
        return NamingStrategy.underlineToCamel(NamingStrategy.removePrefix(name, tablePrefix));
    }

    public static String capitalFirst(String name) {
        if (StringUtils.isNotBlank((String)name)) {
            char[] array = name.toCharArray();
            array[0] = (char)(array[0] - 32);
            return String.valueOf(array);
        }
        return "";
    }
}

