/*
 * Decompiled with CFR 0.152.
 */
package com.barrybecker4.game.twoplayer.gomoku;

import com.barrybecker4.common.geometry.ByteLocation;
import com.barrybecker4.common.geometry.Location;
import com.barrybecker4.game.common.board.BoardPosition;
import com.barrybecker4.game.twoplayer.gomoku.GoMokuBoard;

public class CandidateMoves {
    private static ByteLocation[] SPLAT = new ByteLocation[]{new ByteLocation(-1, -1), new ByteLocation(-1, 0), new ByteLocation(-1, 1), new ByteLocation(0, -1), new ByteLocation(0, 1), new ByteLocation(1, -1), new ByteLocation(1, 0), new ByteLocation(1, 1)};
    private int numRows;
    private int numCols;
    private boolean[][] candidateMoves_;

    public CandidateMoves(GoMokuBoard board) {
        this.numRows = board.getNumRows();
        this.numCols = board.getNumCols();
        this.candidateMoves_ = new boolean[this.numRows + 2][this.numCols + 2];
        this.determineCandidateMoves(board);
    }

    protected CandidateMoves() {
    }

    public boolean isCandidateMove(int row, int col) {
        return this.candidateMoves_[row][col];
    }

    public void setCandidate(BoardPosition pos) {
        if (pos != null && !pos.isOccupied()) {
            this.candidateMoves_[pos.getRow()][pos.getCol()] = true;
        }
    }

    protected void determineCandidateMoves(GoMokuBoard board) {
        boolean hasCandidates = false;
        for (int i = 1; i <= this.numRows; ++i) {
            for (int j = 1; j <= this.numCols; ++j) {
                if (!board.getPosition(i, j).isOccupied()) continue;
                ByteLocation location = new ByteLocation(i, j);
                for (ByteLocation offset : SPLAT) {
                    BoardPosition pos = board.getPosition(location.incrementOnCopy((Location)offset));
                    this.setCandidate(pos);
                }
                hasCandidates = true;
            }
        }
        ByteLocation center = new ByteLocation(this.numRows / 2 + 1, this.numCols / 2 + 1);
        BoardPosition pos = board.getPosition((Location)center);
        if (!hasCandidates) {
            this.setCandidate(pos);
        }
    }
}

