/*
 * Decompiled with CFR 0.152.
 */
package com.barrybecker4.game.twoplayer.gomoku;

import com.barrybecker4.game.common.GameContext;
import com.barrybecker4.game.common.board.Board;
import com.barrybecker4.game.common.board.GamePiece;
import com.barrybecker4.game.common.player.PlayerList;
import com.barrybecker4.game.common.player.PlayerOptions;
import com.barrybecker4.game.twoplayer.common.TwoPlayerController;
import com.barrybecker4.game.twoplayer.common.TwoPlayerMove;
import com.barrybecker4.game.twoplayer.common.TwoPlayerOptions;
import com.barrybecker4.game.twoplayer.gomoku.GoMokuBoard;
import com.barrybecker4.game.twoplayer.gomoku.GoMokuPlayerOptions;
import com.barrybecker4.game.twoplayer.gomoku.GoMokuSearchable;
import com.barrybecker4.game.twoplayer.gomoku.pattern.GoMokuWeights;
import java.awt.Color;
import java.awt.Dimension;

public class GoMokuController<B extends GoMokuBoard>
extends TwoPlayerController<TwoPlayerMove, B> {
    private static final int DEFAULT_NUM_ROWS = 20;
    private Dimension size;

    public GoMokuController() {
        this.size = new Dimension(20, 20);
        this.initializeData();
    }

    public GoMokuController(int nrows, int ncols) {
        this.size = new Dimension(nrows, ncols);
        this.initializeData();
    }

    protected B createBoard() {
        return (B)((Object)new GoMokuBoard(this.size.width, this.size.height));
    }

    protected TwoPlayerOptions createOptions() {
        return new TwoPlayerOptions();
    }

    protected PlayerOptions createPlayerOptions(String playerName, Color color) {
        return new GoMokuPlayerOptions(playerName, color);
    }

    protected void initializeData() {
        this.weights_ = new GoMokuWeights();
    }

    public void computerMovesFirst() {
        int delta = this.getWinRunLength() - 1;
        Board board = (Board)this.getBoard();
        int col = (int)(GameContext.random().nextFloat() * (float)(board.getNumCols() - 2 * delta) + (float)delta + 1.0f);
        int row = (int)(GameContext.random().nextFloat() * (float)(board.getNumRows() - 2 * delta) + (float)delta + 1.0f);
        TwoPlayerMove move = TwoPlayerMove.createMove((int)row, (int)col, (int)0, (GamePiece)new GamePiece(true));
        this.makeMove(move);
    }

    protected int getWinRunLength() {
        return 5;
    }

    public synchronized GoMokuSearchable<B> getSearchable() {
        return (GoMokuSearchable)super.getSearchable();
    }

    protected GoMokuSearchable<B> createSearchable(B board, PlayerList players) {
        return new GoMokuSearchable<B>(board, players);
    }
}

