/*
 * Decompiled with CFR 0.152.
 */
package com.barrybecker4.game.twoplayer.gomoku;

import com.barrybecker4.common.geometry.Location;
import com.barrybecker4.game.common.Move;
import com.barrybecker4.game.common.MoveList;
import com.barrybecker4.game.common.board.GamePiece;
import com.barrybecker4.game.twoplayer.common.BestMoveFinder;
import com.barrybecker4.game.twoplayer.common.TwoPlayerBoard;
import com.barrybecker4.game.twoplayer.common.TwoPlayerMove;
import com.barrybecker4.game.twoplayer.gomoku.CandidateMoves;
import com.barrybecker4.game.twoplayer.gomoku.GoMokuSearchable;
import com.barrybecker4.optimization.parameter.ParameterArray;

final class GoMokuMoveGenerator {
    public final MoveList<TwoPlayerMove> generateMoves(GoMokuSearchable searchable, TwoPlayerMove lastMove, ParameterArray weights) {
        MoveList moveList = new MoveList();
        TwoPlayerBoard pb = searchable.getBoard();
        CandidateMoves candMoves = pb.getCandidateMoves();
        boolean player1 = lastMove == null || !lastMove.isPlayer1();
        int ncols = pb.getNumCols();
        int nrows = pb.getNumRows();
        for (int i = 1; i <= nrows; ++i) {
            for (int j = 1; j <= ncols; ++j) {
                if (!candMoves.isCandidateMove(i, j)) continue;
                int lastValue = lastMove == null ? 0 : lastMove.getValue();
                TwoPlayerMove move = TwoPlayerMove.createMove((int)i, (int)j, (int)lastValue, (GamePiece)new GamePiece(player1));
                searchable.makeInternalMove(move);
                move.setValue(searchable.worth(move, weights));
                searchable.undoInternalMove(move);
                moveList.add((Move)move);
            }
        }
        BestMoveFinder finder = new BestMoveFinder(searchable.getSearchOptions().getBestMovesSearchOptions());
        return finder.getBestMoves(moveList);
    }

    public MoveList<TwoPlayerMove> generateUrgentMoves(GoMokuSearchable searchable, TwoPlayerMove lastMove, ParameterArray weights) {
        if (lastMove == null) {
            return new MoveList();
        }
        MoveList<TwoPlayerMove> allMoves = this.findMovesForBothPlayers(searchable, lastMove, weights);
        MoveList urgentMoves = new MoveList();
        boolean currentPlayer = !lastMove.isPlayer1();
        for (TwoPlayerMove move : allMoves) {
            if (Math.abs(move.getValue()) < 4096 || this.contains(move, (MoveList<TwoPlayerMove>)urgentMoves)) continue;
            move.setUrgent(true);
            move.setPlayer1(currentPlayer);
            move.setPiece(new GamePiece(currentPlayer));
            urgentMoves.add((Move)move);
        }
        return urgentMoves;
    }

    private MoveList<TwoPlayerMove> findMovesForBothPlayers(GoMokuSearchable searchable, TwoPlayerMove lastMove, ParameterArray weights) {
        MoveList allMoves = new MoveList();
        MoveList<TwoPlayerMove> moves = this.generateMoves(searchable, lastMove, weights);
        allMoves.addAll(moves);
        TwoPlayerMove oppLastMove = lastMove.copy();
        oppLastMove.setPlayer1(!lastMove.isPlayer1());
        MoveList<TwoPlayerMove> opponentMoves = this.generateMoves(searchable, oppLastMove, weights);
        for (TwoPlayerMove m : opponentMoves) {
            allMoves.add((Move)m);
        }
        return allMoves;
    }

    private boolean contains(TwoPlayerMove move, MoveList<TwoPlayerMove> moves) {
        for (TwoPlayerMove m : moves) {
            Location moveLocation = m.getToLocation();
            if (!moveLocation.equals((Object)move.getToLocation())) continue;
            return true;
        }
        return false;
    }
}

