/*
 * Decompiled with CFR 0.152.
 */
package com.barrybecker4.game.twoplayer.gomoku;

import com.barrybecker4.game.common.MoveList;
import com.barrybecker4.game.common.player.PlayerList;
import com.barrybecker4.game.twoplayer.common.TwoPlayerMove;
import com.barrybecker4.game.twoplayer.common.TwoPlayerSearchable;
import com.barrybecker4.game.twoplayer.gomoku.GoMokuBoard;
import com.barrybecker4.game.twoplayer.gomoku.GoMokuMoveGenerator;
import com.barrybecker4.game.twoplayer.gomoku.analysis.MoveEvaluator;
import com.barrybecker4.game.twoplayer.gomoku.pattern.GoMokuPatterns;
import com.barrybecker4.game.twoplayer.gomoku.pattern.Patterns;
import com.barrybecker4.optimization.parameter.ParameterArray;

public class GoMokuSearchable<B extends GoMokuBoard>
extends TwoPlayerSearchable<TwoPlayerMove, B> {
    private MoveEvaluator moveEvaluator;
    private GoMokuMoveGenerator generator;

    public GoMokuSearchable(B board, PlayerList players) {
        super(board, players);
        this.init();
    }

    public GoMokuSearchable(GoMokuSearchable<B> searchable) {
        super(searchable);
        this.init();
    }

    private void init() {
        this.generator = new GoMokuMoveGenerator();
        this.moveEvaluator = new MoveEvaluator(this.createPatterns());
    }

    public GoMokuSearchable<B> copy() {
        return new GoMokuSearchable<B>(this);
    }

    public B getBoard() {
        return (B)((Object)((GoMokuBoard)this.board_));
    }

    protected Patterns createPatterns() {
        return new GoMokuPatterns();
    }

    public int worth(TwoPlayerMove lastMove, ParameterArray weights) {
        return this.moveEvaluator.worth((GoMokuBoard)this.getBoard(), lastMove, weights);
    }

    public MoveList<TwoPlayerMove> generateMoves(TwoPlayerMove lastMove, ParameterArray weights) {
        return this.generator.generateMoves(this, lastMove, weights);
    }

    public MoveList<TwoPlayerMove> generateUrgentMoves(TwoPlayerMove lastMove, ParameterArray weights) {
        return this.generator.generateUrgentMoves(this, lastMove, weights);
    }

    public boolean inJeopardy(TwoPlayerMove move, ParameterArray weights) {
        if (move == null) {
            return false;
        }
        double newValue = this.worth(move, weights);
        double diff = newValue - (double)move.getValue();
        return diff > (double)this.getJeopardyWeight();
    }

    protected int getJeopardyWeight() {
        return 80;
    }
}

