/*
 * Decompiled with CFR 0.152.
 */
package com.barrybecker4.game.twoplayer.gomoku.analysis;

import com.barrybecker4.game.common.GameContext;
import com.barrybecker4.game.common.board.BoardPosition;
import com.barrybecker4.game.twoplayer.gomoku.analysis.LineEvaluator;

public class Line {
    protected StringBuilder line;
    private LineEvaluator evaluator;

    public Line(LineEvaluator evaluator) {
        this.evaluator = evaluator;
        this.line = new StringBuilder();
    }

    public void append(BoardPosition pos) {
        assert (pos != null) : "Cannot append at null board position.";
        if (pos.getPiece() == null) {
            this.line.append('_');
        } else {
            char symb = pos.getPiece().getSymbol();
            this.line.append(symb);
        }
    }

    public int computeValueDifference(int position) {
        char symb = this.line.charAt(position);
        if (symb == '_') {
            throw new IllegalStateException("The piece just played at position " + position + " in line " + this.line + " must be a symbol.");
        }
        boolean player1Perspective = symb == 'X';
        int len = this.line.length();
        if (len < this.evaluator.getMinInterestingLength()) {
            return 0;
        }
        this.line.setCharAt(position, '_');
        int maxpos = len - 1;
        int oldScore = this.evaluator.evaluate(this.line, player1Perspective, position, 0, maxpos);
        boolean bl = !player1Perspective;
        this.line.setCharAt(position, symb);
        int newScore = this.evaluator.evaluate(this.line, player1Perspective, position, 0, maxpos);
        return (newScore += this.evaluator.evaluate(this.line, !player1Perspective, position, 0, maxpos)) - (oldScore += this.evaluator.evaluate(this.line, bl, position, 0, maxpos));
    }

    public void worthDebug(String dir, int pos, int diff) {
        GameContext.log((int)0, (String)(dir + " " + this.line + "  Pos: " + pos + "  difference:" + diff));
    }

    LineEvaluator getLineEvaluator() {
        return this.evaluator;
    }

    public String toString() {
        return this.line.toString();
    }
}

