/*
 * Decompiled with CFR 0.152.
 */
package com.barrybecker4.game.twoplayer.gomoku.analysis;

import com.barrybecker4.game.twoplayer.gomoku.analysis.PatternExtractor;
import com.barrybecker4.game.twoplayer.gomoku.pattern.Patterns;
import com.barrybecker4.optimization.parameter.ParameterArray;

public class LineEvaluator {
    protected Patterns patterns_;
    private ParameterArray weights_;

    public LineEvaluator(Patterns patterns, ParameterArray weights) {
        this.patterns_ = patterns;
        this.weights_ = weights;
    }

    public int getMinInterestingLength() {
        return this.patterns_.getMinInterestingLength();
    }

    public int evaluate(CharSequence line, boolean player1Perspective, int pos, int minpos, int maxpos) {
        char opponentSymb;
        assert (pos >= minpos && pos <= maxpos);
        int length = maxpos - minpos + 1;
        if (length < this.patterns_.getMinInterestingLength()) {
            return 0;
        }
        char c = opponentSymb = player1Perspective ? (char)'O' : 'X';
        if (line.charAt(pos) == opponentSymb && pos != minpos && pos != maxpos) {
            return this.evaluate(line, player1Perspective, pos - 1, minpos, pos - 1) + this.evaluate(line, player1Perspective, pos + 1, pos + 1, maxpos);
        }
        return this.getWeight(line, opponentSymb, pos, minpos, maxpos);
    }

    private int getWeight(CharSequence line, char opponentSymb, int pos, int minpos, int maxpos) {
        int index = this.getWeightIndex(line, opponentSymb, pos, minpos, maxpos);
        if (index >= 0) {
            int weight = (int)this.weights_.get(index).getValue();
            return opponentSymb == 'O' ? weight : -weight;
        }
        return 0;
    }

    protected int getWeightIndex(CharSequence line, char opponentSymb, int pos, int minpos, int maxpos) {
        CharSequence pattern = this.getPattern(line, opponentSymb, pos, minpos, maxpos);
        return this.patterns_.getWeightIndexForPattern(pattern);
    }

    protected CharSequence getPattern(CharSequence line, char opponentSymb, int pos, int minpos, int maxpos) {
        PatternExtractor extractor = new PatternExtractor(line);
        return extractor.getPattern(opponentSymb, pos, minpos, maxpos);
    }
}

