/*
 * Decompiled with CFR 0.152.
 */
package com.barrybecker4.game.twoplayer.gomoku.analysis;

import com.barrybecker4.game.common.board.GamePiece;
import com.barrybecker4.game.twoplayer.common.TwoPlayerMove;
import com.barrybecker4.game.twoplayer.gomoku.GoMokuBoard;
import com.barrybecker4.game.twoplayer.gomoku.analysis.Direction;
import com.barrybecker4.game.twoplayer.gomoku.analysis.LineFactory;
import com.barrybecker4.game.twoplayer.gomoku.analysis.differencers.ValueDifferencer;
import com.barrybecker4.game.twoplayer.gomoku.analysis.differencers.ValueDifferencerFactory;
import com.barrybecker4.game.twoplayer.gomoku.pattern.Patterns;
import com.barrybecker4.optimization.parameter.ParameterArray;

public class MoveEvaluator {
    Patterns patterns;
    ValueDifferencerFactory differencerFactory;
    private ValueDifferencer vertDifferencer;
    private ValueDifferencer horzDifferencer;
    private ValueDifferencer upDiagDifferencer;
    private ValueDifferencer downDiagDifferencer;

    public MoveEvaluator(Patterns patterns) {
        this.patterns = patterns;
        this.differencerFactory = new ValueDifferencerFactory(patterns, new LineFactory());
    }

    public void setValueDifferencerFactory(ValueDifferencerFactory differencerFactory) {
        this.differencerFactory = differencerFactory;
    }

    private void createDifferencers(GoMokuBoard board) {
        this.vertDifferencer = this.differencerFactory.createValueDifferencer(board, Direction.VERTICAL);
        this.horzDifferencer = this.differencerFactory.createValueDifferencer(board, Direction.HORIZONTAL);
        this.upDiagDifferencer = this.differencerFactory.createValueDifferencer(board, Direction.UP_DIAGONAL);
        this.downDiagDifferencer = this.differencerFactory.createValueDifferencer(board, Direction.DOWN_DIAGONAL);
    }

    public int worth(GoMokuBoard board, TwoPlayerMove lastMove, ParameterArray weights) {
        byte row = lastMove.getToRow();
        byte col = lastMove.getToCol();
        this.createDifferencers(board);
        GamePiece piece = board.getPosition(row, col).getPiece();
        if (piece == null) {
            throw new IllegalStateException("There must be a piece where the last move was played (" + row + ", " + col + ")");
        }
        if (lastMove.isPlayer1() != piece.isOwnedByPlayer1()) {
            throw new IllegalStateException("The last move played must be for the same player found on the board.");
        }
        int diff = this.horzDifferencer.findValueDifference(row, col, weights);
        diff += this.vertDifferencer.findValueDifference(row, col, weights);
        diff += this.upDiagDifferencer.findValueDifference(row, col, weights);
        return lastMove.getValue() + (diff += this.downDiagDifferencer.findValueDifference(row, col, weights));
    }
}

