/*
 * Decompiled with CFR 0.152.
 */
package com.barrybecker4.game.twoplayer.gomoku.analysis;

public class PatternExtractor {
    private static final int BACK = -1;
    private static final int FORWARD = 1;
    private CharSequence line;

    public PatternExtractor(CharSequence line) {
        this.line = line;
    }

    protected CharSequence getPattern(char opponentSymb, int pos, int minpos, int maxpos) {
        if (this.line.charAt(pos) == opponentSymb) {
            return "";
        }
        int start = this.getEndPosition(this.line, opponentSymb, pos, minpos, -1);
        int stop = this.getEndPosition(this.line, opponentSymb, pos, maxpos, 1);
        return this.line.subSequence(start, stop + 1);
    }

    protected int getEndPosition(CharSequence line, char opponentSymb, int pos, int extremePos, int direction) {
        int end = pos;
        if (line.charAt(pos) == opponentSymb && pos == extremePos) {
            end -= direction;
        } else {
            while (direction * end < direction * extremePos && line.charAt(end + direction) != opponentSymb && !this.next2Unoccupied(line, end, direction)) {
                end += direction;
            }
        }
        return end;
    }

    private boolean next2Unoccupied(CharSequence line, int position, int dir) {
        return line.charAt(position) == '_' && line.charAt(position + dir) == '_';
    }
}

