/*
 * Decompiled with CFR 0.152.
 */
package com.barrybecker4.game.twoplayer.gomoku.analysis.differencers;

import com.barrybecker4.game.twoplayer.common.TwoPlayerBoard;
import com.barrybecker4.game.twoplayer.gomoku.analysis.Line;
import com.barrybecker4.game.twoplayer.gomoku.analysis.LineFactory;
import com.barrybecker4.game.twoplayer.gomoku.analysis.differencers.DiagonalDifferencer;
import com.barrybecker4.game.twoplayer.gomoku.pattern.Patterns;
import com.barrybecker4.optimization.parameter.ParameterArray;

public class DownDiagonalDifferencer
extends DiagonalDifferencer {
    public DownDiagonalDifferencer(TwoPlayerBoard board, Patterns patterns, LineFactory lineFactory) {
        super(board, patterns, lineFactory);
    }

    @Override
    public int findValueDifference(int row, int col, ParameterArray weights) {
        this.init();
        int startc = col - this.winLength;
        int startr = row - this.winLength;
        if (startc < 1) {
            startr += 1 - startc;
            startc = 1;
        }
        if (startr < 1) {
            startc += 1 - startr;
            startr = 1;
        }
        int stopc = col + this.winLength;
        int stopr = row + this.winLength;
        if (stopc > this.numCols) {
            stopr += this.numCols - stopc;
        }
        if (stopr > this.numRows) {
            stopr = this.numRows;
        }
        Line line = this.lineFactory_.createLine(this.patterns_, weights);
        for (int i = startr; i <= stopr; ++i) {
            line.append(this.board_.getPosition(i, startc + i - startr));
        }
        int position = row - startr;
        return line.computeValueDifference(position);
    }
}

