/*
 * Decompiled with CFR 0.152.
 */
package com.barrybecker4.game.twoplayer.gomoku.analysis.differencers;

import com.barrybecker4.game.twoplayer.common.TwoPlayerBoard;
import com.barrybecker4.game.twoplayer.gomoku.analysis.Direction;
import com.barrybecker4.game.twoplayer.gomoku.analysis.Line;
import com.barrybecker4.game.twoplayer.gomoku.analysis.LineFactory;
import com.barrybecker4.game.twoplayer.gomoku.analysis.differencers.ValueDifferencer;
import com.barrybecker4.game.twoplayer.gomoku.pattern.Patterns;
import com.barrybecker4.optimization.parameter.ParameterArray;

public class StraightDifferencer
extends ValueDifferencer {
    private boolean isVertical;

    public StraightDifferencer(TwoPlayerBoard board, Patterns patterns, LineFactory lineFactory, Direction dir) {
        super(board, patterns, lineFactory);
        assert (dir == Direction.VERTICAL || dir == Direction.HORIZONTAL) : "unexpected direction";
        this.isVertical = dir == Direction.VERTICAL;
    }

    @Override
    public int findValueDifference(int row, int col, ParameterArray weights) {
        int stop;
        int numMax = this.isVertical ? this.board_.getNumRows() : this.board_.getNumCols();
        int currentPos = this.isVertical ? row : col;
        int start = currentPos - this.winLength;
        if (start < 1) {
            start = 1;
        }
        if ((stop = currentPos + this.winLength) > numMax) {
            stop = numMax;
        }
        Line line = this.lineFactory_.createLine(this.patterns_, weights);
        for (int i = start; i <= stop; ++i) {
            if (this.isVertical) {
                line.append(this.board_.getPosition(i, col));
                continue;
            }
            line.append(this.board_.getPosition(row, i));
        }
        int position = currentPos - start;
        return line.computeValueDifference(position);
    }
}

