/*
 * Decompiled with CFR 0.152.
 */
package com.barrybecker4.game.twoplayer.gomoku.analysis.differencers;

import com.barrybecker4.game.twoplayer.common.TwoPlayerBoard;
import com.barrybecker4.game.twoplayer.gomoku.analysis.Line;
import com.barrybecker4.game.twoplayer.gomoku.analysis.LineFactory;
import com.barrybecker4.game.twoplayer.gomoku.analysis.differencers.DiagonalDifferencer;
import com.barrybecker4.game.twoplayer.gomoku.pattern.Patterns;
import com.barrybecker4.optimization.parameter.ParameterArray;

public class UpDiagonalDifferencer
extends DiagonalDifferencer {
    public UpDiagonalDifferencer(TwoPlayerBoard board, Patterns patterns, LineFactory lineFactory) {
        super(board, patterns, lineFactory);
    }

    @Override
    public int findValueDifference(int row, int col, ParameterArray weights) {
        this.init();
        int startc = col - this.winLength;
        int startr = row + this.winLength;
        if (startc < 1) {
            startr += startc - 1;
            startc = 1;
        }
        if (startr > this.numRows) {
            startc += startr - this.numRows;
            startr = this.numRows;
        }
        int stopc = col + this.winLength;
        int stopr = row - this.winLength;
        if (stopc > this.numCols) {
            stopr += stopc - this.numCols;
            stopc = this.numCols;
        }
        if (stopr < 1) {
            stopc += stopr - 1;
        }
        Line line = this.lineFactory_.createLine(this.patterns_, weights);
        for (int i = startc; i <= stopc; ++i) {
            line.append(this.board_.getPosition(startr - i + startc, i));
        }
        int position = col - startc;
        return line.computeValueDifference(position);
    }
}

