/*
 * Decompiled with CFR 0.152.
 */
package com.barrybecker4.game.twoplayer.gomoku.analysis.differencers;

import com.barrybecker4.game.twoplayer.common.TwoPlayerBoard;
import com.barrybecker4.game.twoplayer.gomoku.analysis.Direction;
import com.barrybecker4.game.twoplayer.gomoku.analysis.LineFactory;
import com.barrybecker4.game.twoplayer.gomoku.analysis.differencers.DownDiagonalDifferencer;
import com.barrybecker4.game.twoplayer.gomoku.analysis.differencers.StraightDifferencer;
import com.barrybecker4.game.twoplayer.gomoku.analysis.differencers.UpDiagonalDifferencer;
import com.barrybecker4.game.twoplayer.gomoku.analysis.differencers.ValueDifferencer;
import com.barrybecker4.game.twoplayer.gomoku.pattern.Patterns;

public class ValueDifferencerFactory {
    protected Patterns patterns_;
    protected LineFactory lineFactory_;

    public ValueDifferencerFactory(Patterns patterns, LineFactory factory) {
        this.patterns_ = patterns;
        this.lineFactory_ = factory;
    }

    public ValueDifferencer createValueDifferencer(TwoPlayerBoard board, Direction dir) {
        ValueDifferencer differencer = null;
        switch (dir) {
            case VERTICAL: 
            case HORIZONTAL: {
                differencer = new StraightDifferencer(board, this.patterns_, this.lineFactory_, dir);
                break;
            }
            case UP_DIAGONAL: {
                differencer = new UpDiagonalDifferencer(board, this.patterns_, this.lineFactory_);
                break;
            }
            case DOWN_DIAGONAL: {
                differencer = new DownDiagonalDifferencer(board, this.patterns_, this.lineFactory_);
            }
        }
        return differencer;
    }
}

