/*
 * Decompiled with CFR 0.152.
 */
package com.barrybecker4.game.twoplayer.gomoku.data;

import com.barrybecker4.game.common.GameContext;
import com.barrybecker4.game.twoplayer.gomoku.pattern.GoMokuPatterns;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.StreamTokenizer;

public class GoMokuPatternsFile
extends GoMokuPatterns {
    private String[] patterns_ = null;

    public GoMokuPatternsFile() {
        this.readPatternFile();
    }

    @Override
    protected int getNumPatterns() {
        return this.patterns_.length;
    }

    @Override
    protected String getPatternString(int i) {
        return this.patterns_[i];
    }

    protected String getPatternFile() {
        return "com/barrybecker4/game/gomoku/GoMoku.patterns1.dat";
    }

    protected String getExportFile() {
        return "com/barrybecker4/game/gomoku/GoMoku.export.dat";
    }

    protected void readPatternFile() {
        FileInputStream patternFile;
        String patternFileName = this.getPatternFile();
        File file = new File(patternFileName);
        int wtIndex = 0;
        try {
            patternFile = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            GameContext.log((int)0, (String)("file " + patternFileName + " not found." + e.getMessage()));
            return;
        }
        InputStreamReader iStreamReader = new InputStreamReader(patternFile);
        BufferedReader inData = new BufferedReader(iStreamReader);
        StreamTokenizer inStream = new StreamTokenizer(inData);
        inStream.commentChar(35);
        inStream.slashSlashComments(true);
        inStream.wordChars(95, 96);
        try {
            int numPatterns = (int)inStream.nval;
            this.patterns_ = new String[numPatterns];
            for (int i = 0; i < numPatterns; ++i) {
                int token = inStream.nextToken();
                if (token == -3) {
                    this.patterns_[i] = inStream.sval;
                } else {
                    GameContext.log((int)0, (String)("unexpected token type = " + token + "   nval = " + inStream.nval));
                }
                token = inStream.nextToken();
                if (token == -2) {
                    wtIndex = (int)inStream.nval;
                } else {
                    GameContext.log((int)0, (String)("unexpected token type = " + token + "   sval = " + inStream.sval));
                }
                String pattern = this.patterns_[i];
                this.setPatternWeightInTable(pattern, wtIndex);
            }
            iStreamReader.close();
        }
        catch (IOException e) {
            GameContext.log((int)0, (String)("error occurred while reading " + patternFileName));
        }
    }

    protected void writePatternFile() {
        FileOutputStream patternFile;
        String exportFile = this.getExportFile();
        File file = new File(exportFile);
        try {
            patternFile = new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            GameContext.log((int)0, (String)("can't open " + exportFile + " for write"));
            e.printStackTrace();
            return;
        }
        OutputStreamWriter oStreamWriter = new OutputStreamWriter(patternFile);
        BufferedWriter outData = new BufferedWriter(oStreamWriter);
        try {
            int i;
            int numPatterns = this.getNumPatterns();
            GameContext.log((int)0, (String)("there are " + numPatterns + " patterns. "));
            for (i = 0; i < numPatterns; ++i) {
                outData.write("\"" + this.patterns_[i] + "\", ");
            }
            outData.write("\r\n");
            for (i = 0; i < numPatterns; ++i) {
                int index = this.getWeightIndexForPattern(this.patterns_[i]);
                outData.write(index + ", ");
            }
            outData.write("\r\n");
            outData.flush();
            patternFile.flush();
            outData.close();
            patternFile.close();
        }
        catch (IOException e) {
            GameContext.log((int)0, (String)("error occurred while writing " + exportFile));
            e.printStackTrace();
        }
    }
}

