/*
 * Decompiled with CFR 0.152.
 */
package com.barrybecker4.game.twoplayer.gomoku.pattern;

import com.barrybecker4.game.twoplayer.gomoku.pattern.PatternToIntConverter;

public class PatternTable {
    private static final int TABLE_SIZE = 4096;
    private int[] weightIndexTable_;
    private PatternToIntConverter converter;

    public PatternTable() {
        this.initTable();
        this.converter = new PatternToIntConverter();
    }

    protected void initTable() {
        this.weightIndexTable_ = new int[4096];
        for (int i = 0; i < 4096; ++i) {
            this.weightIndexTable_[i] = -1;
        }
    }

    public int getWeightIndexForPattern(CharSequence pattern, int minpos, int maxpos) {
        return this.weightIndexTable_[this.converter.convertPatternToInt(pattern, minpos, maxpos)];
    }

    public void setPatternWeightInTable(String pattern, int wtIndex) {
        int hash = this.converter.convertPatternToInt(pattern);
        this.weightIndexTable_[hash] = wtIndex;
        StringBuilder reverse = new StringBuilder(pattern);
        reverse.reverse();
        hash = this.converter.convertPatternToInt(reverse.toString());
        this.weightIndexTable_[hash] = wtIndex;
    }
}

