/*
 * Decompiled with CFR 0.152.
 */
package com.barrybecker4.game.twoplayer.gomoku.ui;

import com.barrybecker4.common.geometry.Location;
import com.barrybecker4.game.common.GameContext;
import com.barrybecker4.game.common.board.BoardPosition;
import com.barrybecker4.game.common.board.IRectangularBoard;
import com.barrybecker4.game.common.ui.viewer.GameBoardRenderer;
import com.barrybecker4.game.common.ui.viewer.GameBoardViewer;
import com.barrybecker4.game.common.ui.viewer.ViewerMouseListener;
import com.barrybecker4.game.twoplayer.common.TwoPlayerMove;
import com.barrybecker4.game.twoplayer.common.ui.AbstractTwoPlayerBoardViewer;
import com.barrybecker4.game.twoplayer.gomoku.GoMokuBoard;
import com.barrybecker4.game.twoplayer.gomoku.GoMokuController;
import com.barrybecker4.game.twoplayer.gomoku.ui.GoMokuBoardRenderer;
import com.barrybecker4.game.twoplayer.gomoku.ui.GoMokuViewerMouseListener;
import java.awt.event.MouseEvent;

public class GoMokuBoardViewer
extends AbstractTwoPlayerBoardViewer {
    protected GoMokuController createController() {
        return new GoMokuController();
    }

    protected GameBoardRenderer getBoardRenderer() {
        return GoMokuBoardRenderer.getRenderer();
    }

    protected ViewerMouseListener createViewerMouseListener() {
        return new GoMokuViewerMouseListener((GameBoardViewer<TwoPlayerMove, GoMokuBoard>)this);
    }

    public String getToolTipText(MouseEvent e) {
        if (this.get2PlayerController().isProcessing() || GameContext.getDebugMode() < 1) {
            return "";
        }
        Location loc = this.getBoardRenderer().createLocation(e);
        StringBuilder sb = new StringBuilder("<html><font=-3>");
        BoardPosition space = ((IRectangularBoard)this.controller.getBoard()).getPosition(loc);
        if (space != null && GameContext.getDebugMode() > 0) {
            sb.append(space.getLocation());
        } else {
            sb.append(loc);
        }
        sb.append("</font></html>");
        return sb.toString();
    }
}

