/*
 * Decompiled with CFR 0.152.
 */
package com.barrybecker4.game.twoplayer.gomoku.ui;

import com.barrybecker4.common.geometry.Location;
import com.barrybecker4.game.common.board.BoardPosition;
import com.barrybecker4.game.common.board.GamePiece;
import com.barrybecker4.game.common.ui.viewer.GameBoardViewer;
import com.barrybecker4.game.common.ui.viewer.ViewerMouseListener;
import com.barrybecker4.game.twoplayer.common.TwoPlayerMove;
import com.barrybecker4.game.twoplayer.gomoku.GoMokuBoard;
import com.barrybecker4.game.twoplayer.gomoku.GoMokuController;
import com.barrybecker4.game.twoplayer.gomoku.ui.GoMokuBoardViewer;
import java.awt.event.MouseEvent;

class GoMokuViewerMouseListener
extends ViewerMouseListener<TwoPlayerMove, GoMokuBoard> {
    GoMokuViewerMouseListener(GameBoardViewer<TwoPlayerMove, GoMokuBoard> viewer) {
        super(viewer);
    }

    public void mousePressed(MouseEvent e) {
        GoMokuBoardViewer viewer = (GoMokuBoardViewer)this.viewer;
        GoMokuController controller = (GoMokuController)viewer.getController();
        if (controller.isProcessing() || controller.isDone()) {
            return;
        }
        Location loc = this.getRenderer().createLocation(e);
        GoMokuBoard board = (GoMokuBoard)controller.getBoard();
        BoardPosition p = board.getPosition(loc);
        if (p == null || !p.isUnoccupied()) {
            return;
        }
        TwoPlayerMove m = TwoPlayerMove.createMove((int)loc.row(), (int)loc.col(), (int)0, (GamePiece)new GamePiece(controller.isPlayer1sTurn()));
        viewer.continuePlay(m);
    }
}

