/*
 * Decompiled with CFR 0.152.
 */
package com.barrybecker4.simulation.liquid.compute;

import com.barrybecker4.simulation.common.PhysicsConstants$;
import com.barrybecker4.simulation.liquid.Logger$;
import com.barrybecker4.simulation.liquid.compute.GridUpdater$;
import com.barrybecker4.simulation.liquid.compute.ParticleAdvector;
import com.barrybecker4.simulation.liquid.compute.PressureUpdater;
import com.barrybecker4.simulation.liquid.compute.SurfaceVelocityUpdater;
import com.barrybecker4.simulation.liquid.compute.VelocityUpdater;
import com.barrybecker4.simulation.liquid.model.Grid;
import com.barrybecker4.simulation.liquid.model.Particles;
import java.io.Serializable;
import javax.vecmath.Vector2d;
import scala.Function1;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005A<Q\u0001G\r\t\u0002\u00112QAJ\r\t\u0002\u001dBQAL\u0001\u0005\u0002=Bq\u0001M\u0001C\u0002\u0013\u0005\u0011\u0007\u0003\u00046\u0003\u0001\u0006IA\r\u0005\bm\u0005\u0011\r\u0011\"\u00012\u0011\u00199\u0014\u0001)A\u0005e\u0019!a%\u0007\u00019\u0011!ItA!a\u0001\n\u0003Q\u0004\u0002C!\b\u0005\u0003\u0007I\u0011\u0001\"\t\u0011!;!\u0011!Q!\nmBQAL\u0004\u0005\u0002%Cq\u0001T\u0004A\u0002\u0013%\u0011\u0007C\u0004N\u000f\u0001\u0007I\u0011\u0002(\t\rA;\u0001\u0015)\u00033\u0011\u001d\tv\u00011A\u0005\nEBqAU\u0004A\u0002\u0013%1\u000b\u0003\u0004V\u000f\u0001\u0006KA\r\u0005\u0006-\u001e!\ta\u0016\u0005\u00065\u001e!\ta\u0017\u0005\u0006;\u001e!\tA\u0018\u0005\u0006G\u001e!\t\u0001\u001a\u0005\u0006M\u001e!\ta\u001a\u0005\u0006Q\u001e!\t![\u0001\f\u000fJLG-\u00169eCR,'O\u0003\u0002\u001b7\u000591m\\7qkR,'B\u0001\u000f\u001e\u0003\u0019a\u0017.];jI*\u0011adH\u0001\u000bg&lW\u000f\\1uS>t'B\u0001\u0011\"\u00031\u0011\u0017M\u001d:zE\u0016\u001c7.\u001a:5\u0015\u0005\u0011\u0013aA2p[\u000e\u0001\u0001CA\u0013\u0002\u001b\u0005I\"aC$sS\u0012,\u0006\u000fZ1uKJ\u001c\"!\u0001\u0015\u0011\u0005%bS\"\u0001\u0016\u000b\u0003-\nQa]2bY\u0006L!!\f\u0016\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tA%A\tE\u000b\u001a\u000bU\u000b\u0014+`-&\u001b6iT*J)f+\u0012A\r\t\u0003SMJ!\u0001\u000e\u0016\u0003\r\u0011{WO\u00197f\u0003I!UIR!V\u0019R{f+S*D\u001fNKE+\u0017\u0011\u0002\u0015\u0011+e)Q+M)~\u0013\u0005'A\u0006E\u000b\u001a\u000bU\u000b\u0014+`\u0005B\u00023CA\u0004)\u0003\u00119'/\u001b3\u0016\u0003m\u0002\"\u0001P \u000e\u0003uR!AP\u000e\u0002\u000b5|G-\u001a7\n\u0005\u0001k$\u0001B$sS\u0012\f\u0001b\u001a:jI~#S-\u001d\u000b\u0003\u0007\u001a\u0003\"!\u000b#\n\u0005\u0015S#\u0001B+oSRDqaR\u0005\u0002\u0002\u0003\u00071(A\u0002yIE\nQa\u001a:jI\u0002\"\"AS&\u0011\u0005\u0015:\u0001\"B\u001d\f\u0001\u0004Y\u0014!\u0003<jg\u000e|7/\u001b;z\u000351\u0018n]2pg&$\u0018p\u0018\u0013fcR\u00111i\u0014\u0005\b\u000f6\t\t\u00111\u00013\u0003)1\u0018n]2pg&$\u0018\u0010I\u0001\u0003EB\naA\u0019\u0019`I\u0015\fHCA\"U\u0011\u001d9\u0005#!AA\u0002I\n1A\u0019\u0019!\u00031\u0019X\r\u001e,jg\u000e|7/\u001b;z)\t\u0019\u0005\fC\u0003Z%\u0001\u0007!'A\u0001w\u0003\u0015\u0019X\r\u001e\"1)\t\u0019E\fC\u0003R'\u0001\u0007!'\u0001\bva\u0012\fG/\u001a,fY>\u001c\u0017\u000e^=\u0015\u0007\r{\u0016\rC\u0003a)\u0001\u0007!'\u0001\u0005uS6,7\u000b^3q\u0011\u0015\u0011G\u00031\u00013\u0003\u001d9'/\u0019<jif\fa\"\u001e9eCR,\u0007K]3tgV\u0014X\r\u0006\u00023K\")\u0001-\u0006a\u0001e\u0005)R\u000f\u001d3bi\u0016\u001cVO\u001d4bG\u00164V\r\\8dSRLH#A\"\u0002-U\u0004H-\u0019;f!\u0006\u0014H/[2mKB{7/\u001b;j_:$2A\r6l\u0011\u0015\u0001w\u00031\u00013\u0011\u0015aw\u00031\u0001n\u0003%\u0001\u0018M\u001d;jG2,7\u000f\u0005\u0002=]&\u0011q.\u0010\u0002\n!\u0006\u0014H/[2mKN\u0004")
public class GridUpdater {
    private Grid grid;
    private double viscosity;
    private double b0;

    public static double DEFAULT_B0() {
        return GridUpdater$.MODULE$.DEFAULT_B0();
    }

    public static double DEFAULT_VISCOSITY() {
        return GridUpdater$.MODULE$.DEFAULT_VISCOSITY();
    }

    public Grid grid() {
        return this.grid;
    }

    public void grid_$eq(Grid x$1) {
        this.grid = x$1;
    }

    private double viscosity() {
        return this.viscosity;
    }

    private void viscosity_$eq(double x$1) {
        this.viscosity = x$1;
    }

    private double b0() {
        return this.b0;
    }

    private void b0_$eq(double x$1) {
        this.b0 = x$1;
    }

    public void setViscosity(double v) {
        this.viscosity_$eq(v);
    }

    public void setB0(double b0) {
        this.b0_$eq(b0);
    }

    public void updateVelocity(double timeStep, double gravity) {
        Logger$.MODULE$.log(1, new StringBuilder(58).append("stepForward: about to update the velocity field (timeStep=").append(timeStep).append(')').toString());
        Vector2d force = new Vector2d(0.0, gravity);
        VelocityUpdater velocityUpdater = new VelocityUpdater();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), this.grid().getYDimension() - 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)j -> RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), this.grid().getXDimension() - 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> velocityUpdater.updateTildeVelocities(this.grid().getCell(i, j), this.grid().getNeighbors(i, j), this.grid().getCell(i - 1, j + 1), this.grid().getCell(i + 1, j - 1), timeStep, force, this.viscosity())));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), this.grid().getYDimension() - 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)j -> RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), this.grid().getXDimension() - 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.grid().getCell(i, j).swap()));
    }

    public double updatePressure(double timeStep) {
        double div;
        block0: {
            PressureUpdater updater = new PressureUpdater(this.grid(), this.b0());
            div = updater.updatePressure(timeStep);
            if (updater.getNumIterations() <= 10) break block0;
            Logger$.MODULE$.log(1, new StringBuilder(55).append(" updatePress: converged to maxDiv = ").append(div).append(" after ").append(updater.getNumIterations()).append(" iterations.").toString());
        }
        return div;
    }

    public void updateSurfaceVelocity() {
        SurfaceVelocityUpdater surfaceUpdater = new SurfaceVelocityUpdater(PhysicsConstants$.MODULE$.ATMOSPHERIC_PRESSURE());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), this.grid().getYDimension() - 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)j -> RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), this.grid().getXDimension() - 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> surfaceUpdater.updateSurfaceVelocities(this.grid().getCell(i, j), this.grid().getNeighbors(i, j))));
    }

    public double updateParticlePosition(double timeStep, Particles particles) {
        ParticleAdvector updater = new ParticleAdvector(this.grid());
        return updater.advectParticles(timeStep, particles);
    }

    public GridUpdater(Grid grid) {
        this.grid = grid;
        this.viscosity = GridUpdater$.MODULE$.DEFAULT_VISCOSITY();
        this.b0 = GridUpdater$.MODULE$.DEFAULT_B0();
    }
}

