/*
 * Decompiled with CFR 0.152.
 */
package com.barrybecker4.simulation.liquid.compute;

import com.barrybecker4.simulation.liquid.model.Cell;
import com.barrybecker4.simulation.liquid.model.CellDimensions;
import com.barrybecker4.simulation.liquid.model.CellNeighbors;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005-3Aa\u0003\u0007\u0001/!Aa\u0004\u0001BA\u0002\u0013\u0005q\u0004\u0003\u0005$\u0001\t\u0005\r\u0011\"\u0001%\u0011!Q\u0003A!A!B\u0013\u0001\u0003\u0002C\u0016\u0001\u0005\u0003\u0007I\u0011A\u0010\t\u00111\u0002!\u00111A\u0005\u00025B\u0001b\f\u0001\u0003\u0002\u0003\u0006K\u0001\t\u0005\u0006a\u0001!\t!\r\u0005\bm\u0001\u0011\r\u0011\"\u00048\u0011\u0019q\u0004\u0001)A\u0007q!)q\b\u0001C\u0001\u0001\niQ*Y:t\u0007>t7/\u001a:wKJT!!\u0004\b\u0002\u000f\r|W\u000e];uK*\u0011q\u0002E\u0001\u0007Y&\fX/\u001b3\u000b\u0005E\u0011\u0012AC:j[Vd\u0017\r^5p]*\u00111\u0003F\u0001\rE\u0006\u0014(/\u001f2fG.,'\u000f\u000e\u0006\u0002+\u0005\u00191m\\7\u0004\u0001M\u0011\u0001\u0001\u0007\t\u00033qi\u0011A\u0007\u0006\u00027\u0005)1oY1mC&\u0011QD\u0007\u0002\u0007\u0003:L(+\u001a4\u0002\u0005\t\u0004T#\u0001\u0011\u0011\u0005e\t\u0013B\u0001\u0012\u001b\u0005\u0019!u.\u001e2mK\u00061!\rM0%KF$\"!\n\u0015\u0011\u0005e1\u0013BA\u0014\u001b\u0005\u0011)f.\u001b;\t\u000f%\u0012\u0011\u0011!a\u0001A\u0005\u0019\u0001\u0010J\u0019\u0002\u0007\t\u0004\u0004%\u0001\u0002ei\u00061A\r^0%KF$\"!\n\u0018\t\u000f%*\u0011\u0011!a\u0001A\u0005\u0019A\r\u001e\u0011\u0002\rqJg.\u001b;?)\r\u0011D'\u000e\t\u0003g\u0001i\u0011\u0001\u0004\u0005\u0006=\u001d\u0001\r\u0001\t\u0005\u0006W\u001d\u0001\r\u0001I\u0001\u0005I&l7/F\u00019!\tID(D\u0001;\u0015\tYd\"A\u0003n_\u0012,G.\u0003\u0002>u\tq1)\u001a7m\t&lWM\\:j_:\u001c\u0018!\u00023j[N\u0004\u0013AF;qI\u0006$X-T1tg\u000e{gn]3sm\u0006$\u0018n\u001c8\u0015\u0007\u0001\ne\tC\u0003C\u0015\u0001\u00071)\u0001\u0003dK2d\u0007CA\u001dE\u0013\t)%H\u0001\u0003DK2d\u0007\"B$\u000b\u0001\u0004A\u0015!\u00038fS\u001eD'm\u001c:t!\tI\u0014*\u0003\u0002Ku\ti1)\u001a7m\u001d\u0016Lw\r\u001b2peN\u0004")
public class MassConserver {
    private double b0;
    private double dt;
    private final CellDimensions dims;

    public double b0() {
        return this.b0;
    }

    public void b0_$eq(double x$1) {
        this.b0 = x$1;
    }

    public double dt() {
        return this.dt;
    }

    public void dt_$eq(double x$1) {
        this.dt = x$1;
    }

    private final CellDimensions dims() {
        return this.dims;
    }

    public double updateMassConservation(Cell cell, CellNeighbors neighbors) {
        if (!cell.isFull()) {
            return 0.0;
        }
        double divergence = (neighbors.getLeft().getU() - cell.getU()) / this.dims().dx() + (neighbors.getBottom().getV() - cell.getV()) / this.dims().dy();
        double b = this.b0() / (this.dt() * (2.0 / this.dims().dxSq() + 2.0 / this.dims().dySq()));
        double dp = b * divergence;
        double dpdx = this.dt() * dp / this.dims().dx();
        double dpdy = this.dt() * dp / this.dims().dy();
        if (!neighbors.getRight().isObstacle()) {
            cell.incrementU(dpdx);
        }
        if (!neighbors.getLeft().isObstacle()) {
            neighbors.getLeft().incrementU(-dpdx);
        }
        if (!neighbors.getTop().isObstacle()) {
            cell.incrementV(dpdy);
        }
        if (!neighbors.getBottom().isObstacle()) {
            neighbors.getBottom().incrementV(-dpdy);
        }
        cell.setPressure(cell.getPressure() + dp);
        return Math.abs(divergence);
    }

    public MassConserver(double b0, double dt) {
        this.b0 = b0;
        this.dt = dt;
        this.dims = new CellDimensions();
    }
}

