/*
 * Decompiled with CFR 0.152.
 */
package com.barrybecker4.simulation.liquid.compute;

import com.barrybecker4.simulation.liquid.Logger$;
import com.barrybecker4.simulation.liquid.compute.ParticleAdvector$;
import com.barrybecker4.simulation.liquid.compute.VelocityInterpolator;
import com.barrybecker4.simulation.liquid.model.Cell;
import com.barrybecker4.simulation.liquid.model.CellDimensions$;
import com.barrybecker4.simulation.liquid.model.CellStatus$;
import com.barrybecker4.simulation.liquid.model.Grid;
import com.barrybecker4.simulation.liquid.model.Particle;
import com.barrybecker4.simulation.liquid.model.Particles;
import java.io.Serializable;
import javax.vecmath.Vector2d;
import scala.Double$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.DoubleRef;

@ScalaSignature(bytes="\u0006\u0005Y<QAE\n\t\u0002y1Q\u0001I\n\t\u0002\u0005BQ\u0001K\u0001\u0005\u0002%BqAK\u0001C\u0002\u0013%1\u0006\u0003\u00040\u0003\u0001\u0006I\u0001\f\u0004\u0005AM\u0001\u0001\u0007\u0003\u00052\u000b\t\u0005\r\u0011\"\u00013\u0011!ITA!a\u0001\n\u0003Q\u0004\u0002\u0003!\u0006\u0005\u0003\u0005\u000b\u0015B\u001a\t\u000b!*A\u0011A!\t\u0011\u0011+\u0001\u0019!C\u0001'\u0015C\u0001\"S\u0003A\u0002\u0013\u00051C\u0013\u0005\u0007\u0019\u0016\u0001\u000b\u0015\u0002$\t\u000b5+A\u0011\u0001(\t\u000bY+A\u0011B,\t\u000by+A\u0011B0\t\u000b%,A\u0011\u00026\t\u000bE,A\u0011\u0002:\u0002!A\u000b'\u000f^5dY\u0016\fEM^3di>\u0014(B\u0001\u000b\u0016\u0003\u001d\u0019w.\u001c9vi\u0016T!AF\f\u0002\r1L\u0017/^5e\u0015\tA\u0012$\u0001\u0006tS6,H.\u0019;j_:T!AG\u000e\u0002\u0019\t\f'O]=cK\u000e\\WM\u001d\u001b\u000b\u0003q\t1aY8n\u0007\u0001\u0001\"aH\u0001\u000e\u0003M\u0011\u0001\u0003U1si&\u001cG.Z!em\u0016\u001cGo\u001c:\u0014\u0005\u0005\u0011\u0003CA\u0012'\u001b\u0005!#\"A\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u001d\"#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002=\u00059Q\tU*J\u0019>sU#\u0001\u0017\u0011\u0005\rj\u0013B\u0001\u0018%\u0005\u0019!u.\u001e2mK\u0006AQ\tU*J\u0019>s\u0005e\u0005\u0002\u0006E\u0005!qM]5e+\u0005\u0019\u0004C\u0001\u001b8\u001b\u0005)$B\u0001\u001c\u0016\u0003\u0015iw\u000eZ3m\u0013\tATG\u0001\u0003He&$\u0017\u0001C4sS\u0012|F%Z9\u0015\u0005mr\u0004CA\u0012=\u0013\tiDE\u0001\u0003V]&$\bbB \b\u0003\u0003\u0005\raM\u0001\u0004q\u0012\n\u0014!B4sS\u0012\u0004CC\u0001\"D!\tyR\u0001C\u00032\u0013\u0001\u00071'\u0001\u0007j]R,'\u000f]8mCR|'/F\u0001G!\tyr)\u0003\u0002I'\t!b+\u001a7pG&$\u00180\u00138uKJ\u0004x\u000e\\1u_J\f\u0001#\u001b8uKJ\u0004x\u000e\\1u_J|F%Z9\u0015\u0005mZ\u0005bB \f\u0003\u0003\u0005\rAR\u0001\u000eS:$XM\u001d9pY\u0006$xN\u001d\u0011\u0002\u001f\u0005$g/Z2u!\u0006\u0014H/[2mKN$2\u0001L(R\u0011\u0015\u0001V\u00021\u0001-\u0003!!\u0018.\\3Ti\u0016\u0004\b\"\u0002*\u000e\u0001\u0004\u0019\u0016!\u00039beRL7\r\\3t!\t!D+\u0003\u0002Vk\tI\u0001+\u0019:uS\u000edWm]\u0001\u000fC\u00124Xm\u0019;QCJ$\u0018n\u00197f)\ra\u0003,\u0017\u0005\u0006!:\u0001\r\u0001\f\u0005\u00065:\u0001\raW\u0001\ta\u0006\u0014H/[2mKB\u0011A\u0007X\u0005\u0003;V\u0012\u0001\u0002U1si&\u001cG.Z\u0001\u0014C\u00124Xm\u0019;XCR,'\u000fU1si&\u001cG.\u001a\u000b\u0006Y\u0001\f'm\u001a\u0005\u0006!>\u0001\r\u0001\f\u0005\u00065>\u0001\ra\u0017\u0005\u0006G>\u0001\r\u0001Z\u0001\u0002SB\u00111%Z\u0005\u0003M\u0012\u00121!\u00138u\u0011\u0015Aw\u00021\u0001e\u0003\u0005Q\u0017a\u00044j]\u0012tUm\u001e%p[\u0016\u001cU\r\u001c7\u0015\t-tw\u000e\u001d\t\u0003i1L!!\\\u001b\u0003\t\r+G\u000e\u001c\u0005\u00065B\u0001\ra\u0017\u0005\u0006GB\u0001\r\u0001\u001a\u0005\u0006QB\u0001\r\u0001Z\u0001\u000fC\u0012TWo\u001d;US6,7\u000b^3q)\ra3\u000f\u001e\u0005\u0006!F\u0001\r\u0001\f\u0005\u0006kF\u0001\r\u0001L\u0001\n[\u0006DH*\u001a8hi\"\u0004")
public class ParticleAdvector {
    private Grid grid;
    private VelocityInterpolator interpolator;

    public Grid grid() {
        return this.grid;
    }

    public void grid_$eq(Grid x$1) {
        this.grid = x$1;
    }

    public VelocityInterpolator interpolator() {
        return this.interpolator;
    }

    public void interpolator_$eq(VelocityInterpolator x$1) {
        this.interpolator = x$1;
    }

    public double advectParticles(double timeStep, Particles particles) {
        DoubleRef maxLength = DoubleRef.create((double)Double$.MODULE$.MinValue());
        particles.iterator().foreach((Function1 & Serializable)particle -> {
            ParticleAdvector.$anonfun$advectParticles$1(this, timeStep, maxLength, particle);
            return BoxedUnit.UNIT;
        });
        this.adjustTimeStep(timeStep, maxLength.elem);
        return timeStep;
    }

    private double advectParticle(double timeStep, Particle particle) {
        double magnitude;
        block0: {
            int i = (int)Math.floor(particle.x);
            int j = (int)Math.floor(particle.y);
            Enumeration.Value status = this.grid().getCell(i, j).getStatus();
            magnitude = 0.0;
            if (status != CellStatus$.MODULE$.FULL() && status != CellStatus$.MODULE$.SURFACE() && status != CellStatus$.MODULE$.ISOLATED()) break block0;
            magnitude = this.advectWaterParticle(timeStep, particle, i, j);
        }
        return magnitude;
    }

    private double advectWaterParticle(double timeStep, Particle particle, int i, int j) {
        Vector2d vel = this.interpolator().findVelocity(particle);
        vel.scale(CellDimensions$.MODULE$.INVERSE_CELL_SIZE());
        double xChange = timeStep * vel.x;
        double yChange = timeStep * vel.y;
        particle.set(particle.x + xChange, particle.y + yChange);
        particle.incAge(timeStep);
        Cell newHomeCell = this.findNewHomeCell(particle, i, j);
        Predef$.MODULE$.assert(particle.x >= 1.0 && particle.y >= 1.0 && particle.x < (double)(this.grid().getXDimension() - 1) && particle.y < (double)(this.grid().getYDimension() - 1), (Function0 & Serializable)() -> new StringBuilder(22).append("particle.x=").append(particle$1.x).append("particle.y=").append(particle$1.y).toString());
        newHomeCell.incParticles();
        this.grid().getCell(i, j).decParticles();
        particle.setCell(newHomeCell);
        Predef$.MODULE$.assert(this.grid().getCell(i, j).getNumParticles() >= 0, (Function0 & Serializable)() -> new StringBuilder(39).append("The number of particles in grid[").append(i).append("][").append(j).append("] is ").append(this.grid().getCell(i, j).getNumParticles()).toString());
        Predef$.MODULE$.assert(newHomeCell.getNumParticles() >= 0);
        return vel.length();
    }

    private Cell findNewHomeCell(Particle particle, int i, int j) {
        int ii = (int)Math.floor(particle.x);
        int jj = (int)Math.floor(particle.y);
        if (ii < 0) {
            particle.x = 0.0;
            ii = 0;
        }
        if (jj < 0) {
            particle.y = 0.0;
            jj = 0;
        }
        if (ii >= this.grid().getXDimension()) {
            ii = this.grid().getXDimension() - 1;
            particle.x = ii;
        }
        if (jj >= this.grid().getYDimension()) {
            jj = this.grid().getYDimension() - 1;
            particle.y = jj;
        }
        if (this.grid().getCell(ii, jj).getStatus() == CellStatus$.MODULE$.OBSTACLE()) {
            if (i < ii) {
                particle.set((double)ii - ParticleAdvector$.MODULE$.com$barrybecker4$simulation$liquid$compute$ParticleAdvector$$EPSILON(), particle.y);
            } else if (i > ii) {
                particle.set((double)ii + 1.0 + ParticleAdvector$.MODULE$.com$barrybecker4$simulation$liquid$compute$ParticleAdvector$$EPSILON(), particle.y);
            }
            if (j < jj) {
                particle.set(particle.x, (double)jj - ParticleAdvector$.MODULE$.com$barrybecker4$simulation$liquid$compute$ParticleAdvector$$EPSILON());
            } else if (j > jj) {
                particle.set(particle.x, (double)jj + 1.0 + ParticleAdvector$.MODULE$.com$barrybecker4$simulation$liquid$compute$ParticleAdvector$$EPSILON());
            }
        }
        ii = (int)particle.x;
        jj = (int)particle.y;
        return this.grid().getCell(ii, jj);
    }

    private double adjustTimeStep(double timeStep, double maxLength) {
        double newTimeStep;
        block1: {
            double increment;
            double minDistance;
            block0: {
                double maxDistance = CellDimensions$.MODULE$.CELL_SIZE() / 10.0;
                minDistance = CellDimensions$.MODULE$.CELL_SIZE() / 10000.0;
                increment = timeStep * maxLength;
                newTimeStep = timeStep;
                if (!(increment > maxDistance)) break block0;
                newTimeStep /= 2.0;
                Logger$.MODULE$.log(1, new StringBuilder(38).append("advectParticles: HALVED dt=").append(timeStep).append(" increment=").append(increment).toString());
                break block1;
            }
            if (!(increment < minDistance)) break block1;
            newTimeStep *= 2.0;
            Logger$.MODULE$.log(1, new StringBuilder(50).append("advectParticles: DOUBLED dt=").append(timeStep).append(" increment=").append(increment).append(" maxLength=").append(maxLength).toString());
        }
        return newTimeStep;
    }

    public static final /* synthetic */ void $anonfun$advectParticles$1(ParticleAdvector $this, double timeStep$1, DoubleRef maxLength$1, Particle particle) {
        block0: {
            double length = $this.advectParticle(timeStep$1, particle);
            if (!(length > maxLength$1.elem)) break block0;
            maxLength$1.elem = length;
        }
    }

    public ParticleAdvector(Grid grid) {
        this.grid = grid;
        this.interpolator = new VelocityInterpolator(this.grid());
    }
}

