/*
 * Decompiled with CFR 0.152.
 */
package com.barrybecker4.simulation.liquid.compute;

import com.barrybecker4.simulation.liquid.compute.SurfaceVelocityUpdater$;
import com.barrybecker4.simulation.liquid.model.Cell;
import com.barrybecker4.simulation.liquid.model.CellDimensions;
import com.barrybecker4.simulation.liquid.model.CellNeighbors;
import scala.Predef$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005i;QAD\b\t\u0002i1Q\u0001H\b\t\u0002uAQ\u0001J\u0001\u0005\u0002\u0015BqAJ\u0001C\u0002\u0013%q\u0005\u0003\u0004,\u0003\u0001\u0006I\u0001\u000b\u0004\u00059=\u0001A\u0006\u0003\u0005.\u000b\t\u0005\r\u0011\"\u0001/\u0011!\u0011TA!a\u0001\n\u0003\u0019\u0004\u0002C\u001d\u0006\u0005\u0003\u0005\u000b\u0015B\u0018\t\u000b\u0011*A\u0011\u0001\u001e\t\u000fu*!\u0019!C\u0007}!1Q)\u0002Q\u0001\u000e}BQAR\u0003\u0005\u0002\u001dCQAU\u0003\u0005\nM\u000bacU;sM\u0006\u001cWMV3m_\u000eLG/_+qI\u0006$XM\u001d\u0006\u0003!E\tqaY8naV$XM\u0003\u0002\u0013'\u00051A.[9vS\u0012T!\u0001F\u000b\u0002\u0015MLW.\u001e7bi&|gN\u0003\u0002\u0017/\u0005a!-\u0019:ss\n,7m[3si)\t\u0001$A\u0002d_6\u001c\u0001\u0001\u0005\u0002\u001c\u00035\tqB\u0001\fTkJ4\u0017mY3WK2|7-\u001b;z+B$\u0017\r^3s'\t\ta\u0004\u0005\u0002 E5\t\u0001EC\u0001\"\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0003E\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003i\taBT+N?\u000e+E\nT0G\u0003\u000e+5+F\u0001)!\ty\u0012&\u0003\u0002+A\t\u0019\u0011J\u001c;\u0002\u001f9+VjX\"F\u00192{f)Q\"F'\u0002\u001a\"!\u0002\u0010\u0002\u0013A\u0014Xm]:ve\u0016\u0004T#A\u0018\u0011\u0005}\u0001\u0014BA\u0019!\u0005\u0019!u.\u001e2mK\u0006i\u0001O]3tgV\u0014X\rM0%KF$\"\u0001N\u001c\u0011\u0005})\u0014B\u0001\u001c!\u0005\u0011)f.\u001b;\t\u000fa:\u0011\u0011!a\u0001_\u0005\u0019\u0001\u0010J\u0019\u0002\u0015A\u0014Xm]:ve\u0016\u0004\u0004\u0005\u0006\u0002<yA\u00111$\u0002\u0005\u0006[%\u0001\raL\u0001\u0005I&l7/F\u0001@!\t\u00015)D\u0001B\u0015\t\u0011\u0015#A\u0003n_\u0012,G.\u0003\u0002E\u0003\nq1)\u001a7m\t&lWM\\:j_:\u001c\u0018!\u00023j[N\u0004\u0013aF;qI\u0006$XmU;sM\u0006\u001cWMV3m_\u000eLG/[3t)\r!\u0004*\u0014\u0005\u0006\u00132\u0001\rAS\u0001\u0005G\u0016dG\u000e\u0005\u0002A\u0017&\u0011A*\u0011\u0002\u0005\u0007\u0016dG\u000eC\u0003O\u0019\u0001\u0007q*A\u0005oK&<\u0007NY8sgB\u0011\u0001\tU\u0005\u0003#\u0006\u0013QbQ3mY:+\u0017n\u001a5c_J\u001c\u0018!\u00053jgNL\u0007/\u0019;f\u001fZ,'O\u001a7poR)A\u0007V+X3\")\u0011*\u0004a\u0001\u0015\")a+\u0004a\u0001Q\u0005Ya.^7TkJ4\u0017mY3t\u0011\u0015AV\u00021\u00010\u0003!yg/\u001a:gY><\b\"\u0002(\u000e\u0001\u0004y\u0005")
public class SurfaceVelocityUpdater {
    private double pressure0;
    private final CellDimensions dims;

    public double pressure0() {
        return this.pressure0;
    }

    public void pressure0_$eq(double x$1) {
        this.pressure0 = x$1;
    }

    private final CellDimensions dims() {
        return this.dims;
    }

    public void updateSurfaceVelocities(Cell cell, CellNeighbors neighbors) {
        if (!cell.isSurface() && !cell.isIsolated()) {
            return;
        }
        int count = 0;
        double overflow = 0.0;
        if (!neighbors.getRight().isEmpty()) {
            ++count;
            overflow += cell.getU() / this.dims().dx();
        }
        if (!neighbors.getLeft().isEmpty()) {
            ++count;
            overflow -= neighbors.getLeft().getU() / this.dims().dx();
        }
        if (!neighbors.getTop().isEmpty()) {
            ++count;
            overflow += cell.getV() / this.dims().dy();
        }
        if (!neighbors.getBottom().isEmpty()) {
            ++count;
            overflow -= neighbors.getBottom().getV() / this.dims().dy();
        }
        if (count < SurfaceVelocityUpdater$.MODULE$.com$barrybecker4$simulation$liquid$compute$SurfaceVelocityUpdater$$NUM_CELL_FACES() && Math.abs(overflow) > 0.0) {
            this.dissipateOverflow(cell, SurfaceVelocityUpdater$.MODULE$.com$barrybecker4$simulation$liquid$compute$SurfaceVelocityUpdater$$NUM_CELL_FACES() - count, overflow, neighbors);
        }
        cell.setPressure(this.pressure0());
    }

    private void dissipateOverflow(Cell cell, int numSurfaces, double overflow, CellNeighbors neighbors) {
        if (Math.abs(overflow) > (double)100) {
            Predef$.MODULE$.println((Object)new StringBuilder(28).append("dissipating large overflow =").append(overflow).toString());
        }
        int count = 0;
        double overflowX = this.dims().dx() * overflow / (double)numSurfaces;
        double overflowY = this.dims().dy() * overflow / (double)numSurfaces;
        if (neighbors.getRight().isEmpty()) {
            ++count;
            cell.setU(-overflowX);
        }
        if (neighbors.getLeft().isEmpty()) {
            ++count;
            neighbors.getLeft().setU(overflowX);
        }
        if (neighbors.getTop().isEmpty()) {
            ++count;
            cell.setV(-overflowY);
        }
        if (neighbors.getBottom().isEmpty()) {
            ++count;
            neighbors.getBottom().setV(overflowY);
        }
        Predef$.MODULE$.assert(count == numSurfaces);
    }

    public SurfaceVelocityUpdater(double pressure0) {
        this.pressure0 = pressure0;
        this.dims = new CellDimensions();
    }
}

