/*
 * Decompiled with CFR 0.152.
 */
package com.barrybecker4.simulation.liquid.compute;

import com.barrybecker4.simulation.liquid.model.Cell;
import com.barrybecker4.simulation.liquid.model.Grid;
import com.barrybecker4.simulation.liquid.model.Particle;
import java.io.Serializable;
import javax.vecmath.Point2d;
import javax.vecmath.Vector2d;
import scala.Function0;
import scala.Predef$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005U3Aa\u0002\u0005\u0001'!A!\u0004\u0001BA\u0002\u0013\u00051\u0004\u0003\u0005#\u0001\t\u0005\r\u0011\"\u0001$\u0011!I\u0003A!A!B\u0013a\u0002\"\u0002\u0016\u0001\t\u0003Y\u0003\"B\u0018\u0001\t\u0003\u0001\u0004\"\u0002 \u0001\t\u0003y$\u0001\u0006,fY>\u001c\u0017\u000e^=J]R,'\u000f]8mCR|'O\u0003\u0002\n\u0015\u000591m\\7qkR,'BA\u0006\r\u0003\u0019a\u0017.];jI*\u0011QBD\u0001\u000bg&lW\u000f\\1uS>t'BA\b\u0011\u00031\u0011\u0017M\u001d:zE\u0016\u001c7.\u001a:5\u0015\u0005\t\u0012aA2p[\u000e\u00011C\u0001\u0001\u0015!\t)\u0002$D\u0001\u0017\u0015\u00059\u0012!B:dC2\f\u0017BA\r\u0017\u0005\u0019\te.\u001f*fM\u0006!qM]5e+\u0005a\u0002CA\u000f!\u001b\u0005q\"BA\u0010\u000b\u0003\u0015iw\u000eZ3m\u0013\t\tcD\u0001\u0003He&$\u0017\u0001C4sS\u0012|F%Z9\u0015\u0005\u0011:\u0003CA\u000b&\u0013\t1cC\u0001\u0003V]&$\bb\u0002\u0015\u0003\u0003\u0003\u0005\r\u0001H\u0001\u0004q\u0012\n\u0014!B4sS\u0012\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0002-]A\u0011Q\u0006A\u0007\u0002\u0011!)!\u0004\u0002a\u00019\u0005aa-\u001b8e-\u0016dwnY5usR\u0011\u0011'\u000f\t\u0003e]j\u0011a\r\u0006\u0003iU\nqA^3d[\u0006$\bNC\u00017\u0003\u0015Q\u0017M^1y\u0013\tA4G\u0001\u0005WK\u000e$xN\u001d\u001ae\u0011\u0015QT\u00011\u0001<\u0003!\u0001\u0018M\u001d;jG2,\u0007CA\u000f=\u0013\tidD\u0001\u0005QCJ$\u0018n\u00197f\u0003MIg\u000e^3sa>d\u0017\r^3WK2|7-\u001b;z)%\t\u0004\tR%L\u001b>\u000b6\u000bC\u0003;\r\u0001\u0007\u0011\t\u0005\u00023\u0005&\u00111i\r\u0002\b!>Lg\u000e\u001e\u001ae\u0011\u0015)e\u00011\u0001G\u0003\u0011\u0019W\r\u001c7\u0011\u0005u9\u0015B\u0001%\u001f\u0005\u0011\u0019U\r\u001c7\t\u000b)3\u0001\u0019\u0001$\u0002\u0005\rD\u0006\"\u0002'\u0007\u0001\u00041\u0015AA2Z\u0011\u0015qe\u00011\u0001G\u0003\u0011\u0019\u0007,\\\u0019\t\u000bA3\u0001\u0019\u0001$\u0002\u000b\rDV.M=\t\u000bI3\u0001\u0019\u0001$\u0002\t\rLV.\r\u0005\u0006)\u001a\u0001\rAR\u0001\u0006Gfk\u0017\u0007\u001f")
public class VelocityInterpolator {
    private Grid grid;

    public Grid grid() {
        return this.grid;
    }

    public void grid_$eq(Grid x$1) {
        this.grid = x$1;
    }

    public Vector2d findVelocity(Particle particle) {
        int i = (int)particle.x;
        int j = (int)particle.y;
        int ii = particle.x - (double)i > 0.5 ? i + 1 : i - 1;
        int jj = particle.y - (double)j > 0.5 ? j + 1 : j - 1;
        return this.interpolateVelocity(particle, this.grid().getCell(i, j), this.grid().getCell(ii, j), this.grid().getCell(i, jj), this.grid().getCell(i - 1, j), this.grid().getCell(i - 1, jj), this.grid().getCell(i, j - 1), this.grid().getCell(ii, j - 1));
    }

    public Vector2d interpolateVelocity(Point2d particle, Cell cell, Cell cX, Cell cY, Cell cXm1, Cell cXm1y, Cell cYm1, Cell cYm1x) {
        Predef$.MODULE$.assert(!cell.isObstacle() && !cell.isEmpty(), (Function0 & Serializable)() -> new StringBuilder(51).append("Error: interpVelocity cell status=").append(cell.getStatus()).append(" num particles = ").append(cell.getNumParticles()).toString());
        double x = particle.x - Math.floor(particle.x);
        double y = particle.y - Math.floor(particle.y);
        double xx = x > 0.5 ? 1.5 - x : 0.5 + x;
        double yy = y > 0.5 ? 1.5 - y : 0.5 + y;
        double x1 = (1.0 - x) * cXm1.getU() + x * cell.getU();
        double x2 = (1.0 - x) * cXm1y.getU() + x * cY.getU();
        double pu = x1 * yy + x2 * (1.0 - yy);
        double y1 = (1.0 - y) * cYm1.getV() + y * cell.getV();
        double y2 = (1.0 - y) * cYm1x.getV() + y * cX.getV();
        double pv = y1 * xx + y2 * (1.0 - xx);
        return new Vector2d(pu, pv);
    }

    public VelocityInterpolator(Grid grid) {
        this.grid = grid;
    }
}

